/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework;

import org.maskat.ide.property.descriptor.DeleteChildCommand;

/**
 * BasicDefs should have its parent reference. But under most circumstances
 * BasicDef don't need to have any knowledge of its parent, for the time being,
 * only object of this interface could see its parent.<br>
 * For example: Header could see its parent so that it could delete itself from
 * its parent.<br>
 * Note: the parentDef may not hold this "child" object as a child. For example,
 * the header removed from the parent, but the parentDef property is not set to
 * null.
 * 
 * @see DeleteChildCommand
 * 
 * @author shengshen
 */
public interface IParentAwareDef extends IBasicDef {

	/**
	 * @return parent basicDef
	 */
	public IBasicDef getParentDef();

	public void setParentDef(IBasicDef parentDef);
}
