/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties.tabbed.treenodewrapper;

import java.util.Iterator;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.maskat.core.MaskatElement;
import org.maskat.core.event.Component;
import org.maskat.core.event.Event;
import org.maskat.core.event.EventDef;
import org.maskat.core.event.Header;
import org.maskat.ui.Messages;
import org.maskat.ui.views.properties.tabbed.beanwrapper.HeaderTreeNode;
import org.maskat.ui.views.properties.tabbed.command.AddTreeNodeCommand;
import org.maskat.ui.views.properties.tabbed.masterdetails.EventPropertiesMasterDetailsBlock;

public class HTTPHeaderTreeNode extends AbstractTreeNode {
	private static final String HTTP_HEADER =
		Messages.getString("httpHeaderTreeNode.httpHeaders"); //$NON-NLS-1$		

	private static final String ADD_HEADER =
		Messages.getString("httpHeaderTreeNode.addHeader"); //$NON-NLS-1$
	
	public HTTPHeaderTreeNode(Event event) {
		super(event);
	}

	public Iterator getLocalHeaders() {
		return maskatElement.getTypedChildren(Header.class);
	}

	public Iterator getGlobalHeaders() {
		MaskatElement basicDef = maskatElement.getParent();
		EventDef eventDef = null;

		if (basicDef instanceof Component) {
			eventDef = (EventDef) basicDef.getParent();
		} else if (basicDef instanceof EventDef) {
			eventDef = (EventDef) basicDef;
		}

		return eventDef.getTypedChildren(Header.class); // eventDef.getTypedChildren(Header.class);
	}

	protected void loadChildren() {
		Iterator iterator = getLocalHeaders();
		while (iterator != null && iterator.hasNext()) {
			addChild(new HeaderTreeNode((Header)iterator.next(), false));
		}

		iterator = getGlobalHeaders();
		while (iterator != null && iterator.hasNext()) {
			addChild(new HeaderTreeNode((Header)iterator.next(), true));
		}
	}

	public String getDisplayText() {
		return HTTP_HEADER;
	}
	
	/**when the child was removed, the Header bean of the child will be destroyed*/
	public void removeChild(ITreeNode child) {
		super.removeChild(child);
		//destroy the header bean
		Event event = (Event)maskatElement;
		if (((HeaderTreeNode)child).getModel().getParent() instanceof EventDef){
			((HeaderTreeNode)child).getModel().getParent().removeChild(child.getModel());
		}else {
			event.removeChild(child.getModel());
		}
	}
	
	/**add the model relation when add child*/
	public void addChild(ITreeNode child) {
		super.addChild(child);
//		if (child.getModel().getParent() == null || child.getModel().getParent() instanceof Event) {
		if (!((HeaderTreeNode)child).isGlobal()) {
			maskatElement.addChild(child.getModel());
		}else{
			if (maskatElement.getParent() instanceof EventDef) {
				maskatElement.getParent().addChild(child.getModel());
			}else {//if (maskatElement.getParent() != null && maskatElement.getParent().getParent() instanceof EventDef)
				maskatElement.getParent().getParent().addChild(child.getModel());
			}
		}
	}
	
	public boolean isDeletable() {
		return false;
	}
	
	public IMenuManager fillContextMenu(final TreeViewer treeViewer, IMenuManager manager) {
		final ITreeNode node = this;
		manager.add(new Action(ADD_HEADER){
			public void run() {
				//default,we add it as a local header.
				Header header = new Header();
				//header.setName("headerName");
				//header.setValue("");
				ITreeNode childNode = new HeaderTreeNode(header,false); 
				EventPropertiesMasterDetailsBlock.executeCommand(new AddTreeNodeCommand(treeViewer,node,childNode));
			}
		});
		return super.fillContextMenu(treeViewer, manager);
	}
}
