/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties.tabbed.masterdetails;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

import org.maskat.core.event.Source;
import org.maskat.ui.Messages;
import org.maskat.ui.views.properties.tabbed.beanwrapper.SourceChildNode;
import org.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;

public class SourceChildNodeDetailsPage extends AbstractMaskatDetailsPage {

	private static final String SECTION_TEXT = Messages
			.getString("sourceChildNodeDetails.sectionText"); //$NON-NLS-1$

	private static final String SECTION_DESCRIPTION = Messages
			.getString("sourceChildNodeDetails.description"); //$NON-NLS-1$

	private Text nodeNameText;

	private Source source;

	public SourceChildNodeDetailsPage(TreeViewer masterBlockTreeViewer) {
		this.masterBlockTreeViewer = masterBlockTreeViewer;
	}

	public void createContents(Composite parent) {
		TableWrapLayout layout = new TableWrapLayout();
		layout.topMargin = 0;
		layout.leftMargin = 5;
		layout.rightMargin = 5;
		layout.bottomMargin = 5;
		parent.setLayout(layout);

		FormToolkit toolkit = managedForm.getToolkit();

		Section childNodeSection = toolkit.createSection(parent,
				ExpandableComposite.TITLE_BAR | Section.DESCRIPTION);
		childNodeSection.setText(SECTION_TEXT);
		childNodeSection.setDescription(SECTION_DESCRIPTION);
		TableWrapData tableWrapData = new TableWrapData(TableWrapData.FILL,
				TableWrapData.TOP);
		tableWrapData.grabHorizontal = true;
		childNodeSection.setLayoutData(tableWrapData);

		Composite childNodeComposite = toolkit
				.createComposite(childNodeSection);
		childNodeComposite.setLayout(new GridLayout(3, false));

		toolkit.createLabel(childNodeComposite, Messages
				.getString("sourceChildNodeDetails.nodeNameLabel")); //$NON-NLS-1$
		toolkit.createLabel(childNodeComposite, ":");
		nodeNameText = toolkit.createText(childNodeComposite, "", SWT.SINGLE
				| SWT.BORDER);
		nodeNameText.setLayoutData(new GridData(SWT.FILL, 0, true, false));

		nodeNameText.addKeyListener(new KeyAdapter() {

			private int oldCaretPosition;

			public void keyReleased(KeyEvent e) {
				if (!nodeNameText.equals("")) {
					if (source.getChildNode() == null
							|| !source.getChildNode().equals(
									nodeNameText.getText())) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								SourceChildNode.class, source, "childNode",
								nodeNameText.getText());
					}
				} else {
					if (source.getChildNode() != null) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								SourceChildNode.class, source, "childNode",
								null);
					}
				}
				oldCaretPosition = nodeNameText.getCaretPosition();
				updateTreeViewer();
				nodeNameText.setSelection(oldCaretPosition);
			}
		});

		nodeNameText.addFocusListener(new FocusAdapter() {

			public void focusLost(FocusEvent e) {
				boolean changed = false;
				if (!nodeNameText.equals("")) {
					if (source.getChildNode() == null
							|| !source.getChildNode().equals(
									nodeNameText.getText())) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								SourceChildNode.class, source, "childNode",
								nodeNameText.getText());
						changed = true;
					}
				} else {
					if (source.getChildNode() != null) {
						EventPropertiesMasterDetailsBlock.setEventProperty(masterBlockTreeViewer,
								SourceChildNode.class, source, "childNode",
								null);
						changed = true;
					}
				}
				if (changed) {
					int oldCaretPosition = nodeNameText.getCaretPosition();
					updateTreeViewer();
					nodeNameText.setSelection(oldCaretPosition);
				}
			}
		});

		childNodeSection.setClient(childNodeComposite);

	}

	protected void update() {

		if (source.getChildNode() != null) {
			nodeNameText.setText(source.getChildNode());
		} else {
			nodeNameText.setText("");
		}

	}

	public void setSource(Source source) {
		this.source = source;
	}

	protected void initializeInterface() {
		update();
		setDirtyFlag(false);
	}

	private void updateTreeViewer() {
		ITreeNode treeNode = EventPropertiesMasterDetailsBlock.getTreeNode(
				source, SourceChildNode.class);
		if (treeNode != null) {
			masterBlockTreeViewer.update(treeNode, null);
			masterBlockTreeViewer.setSelection(
					new StructuredSelection(treeNode), true);
		}
	}
}
