/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties.tabbed.command;

import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

import org.maskat.ui.views.properties.tabbed.beanwrapper.EventTreeNode;
import org.maskat.ui.views.properties.tabbed.masterdetails.EventPropertiesMasterDetailsBlock;
import org.maskat.ui.views.properties.tabbed.treenodewrapper.EventTreeNodeWrapper;
import org.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;

public class DeleteMultiTreeNodesCommand extends Command {
	
	private TreeViewer treeViewer;
	
	private Object[] nodesToBeDeleted;
	
	public DeleteMultiTreeNodesCommand(TreeViewer treeViewer, Object[] nodesToBeDeleted) {
		super();
		this.treeViewer = treeViewer;
		this.nodesToBeDeleted = nodesToBeDeleted;
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.commands.Command#canUndo()
	 */
	public boolean canUndo() {
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.commands.Command#execute()
	 */
	public void execute() {
		try {
			ITreeNode refreshParent = getRefreshNode();
			for (int i=0; i<nodesToBeDeleted.length; i++) {
				ITreeNode parent = ((ITreeNode)nodesToBeDeleted[i]).getParent();
				parent.removeChild((ITreeNode)nodesToBeDeleted[i]);
			}
			if (refreshParent != null && !(refreshParent instanceof EventTreeNodeWrapper)) {
				treeViewer.refresh(refreshParent, true);
				treeViewer.setSelection(new StructuredSelection(refreshParent));
			} else if (refreshParent != null && refreshParent instanceof EventTreeNodeWrapper){
				treeViewer.refresh();
				treeViewer.expandToLevel(2);
				ITreeNode eventTreeNode = EventPropertiesMasterDetailsBlock.getTreeNode(refreshParent.getModel(), EventTreeNode.class);
				treeViewer.setSelection(new StructuredSelection(eventTreeNode));
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
		}
	}
	
	/**
	 * @return null if all the tree should be refreshed , otherwise the node need to be refreshed 
	 */
	private ITreeNode getRefreshNode() {
		ITreeNode firstNodeParent = (ITreeNode)nodesToBeDeleted[0];
		while ((firstNodeParent = firstNodeParent.getParent()) != null) {
			
			boolean isAncestor = true;
			for (int i=1; i<nodesToBeDeleted.length; i++) {
				if (!isAncestor(firstNodeParent, (ITreeNode)nodesToBeDeleted[i])) {
					isAncestor = false;
					break;
				}
			}
			if (isAncestor) {
				return firstNodeParent;
			}
		}
		return null;
	}
	
	private boolean isAncestor(ITreeNode ancestor, ITreeNode node) {
		ITreeNode parent = node;
		while ((parent = parent.getParent()) != null) {
			if (parent == ancestor) {
				return true;
			}
		}
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.commands.Command#undo()
	 */
	public void undo() {
	}
	
}
