/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties;

import org.eclipse.ui.views.properties.PropertyDescriptor;

import org.maskat.core.layout.TreeView;
import org.maskat.ui.views.properties.descriptor.BooleanComboBoxPropertyDescriptor;
import org.maskat.ui.views.properties.descriptor.MaskatTextPropertyDescriptor;

public class TreeViewPropertySource extends AbstractComponentPropertySource {

	public static final String PROP_NAME = "_prop_name_";
	
	public static final String PROP_TOP = "_prop_top_";
	
	public static final String PROP_LEFT = "_prop_left_";
	
	public static final String PROP_WIDTH = "_prop_width_";
	
	public static final String PROP_HEIGHT = "_prop_height_";
	
	public static final String PROP_AUTORESIZABLEH = "_prop_autoResizableH_";
	
	public static final String PROP_AUTORESIZABLEW = "_prop_autoResizableW_";
	
	public static final String PROP_BOOLSELACTIVE = "_prop_boolSelActive_";
	
	public static final String PROP_DRAGGABLE = "_prop_draggable_";
	
	public static final String PROP_DRAGGABLENODE = "_prop_draggableNode_";
	
	public static final String PROP_POSITION = "_prop_position_";
	
	public static final String PROP_TABINDEX = "_prop_tabIndex_";
	
	public static final String PROP_WITHROOT = "_prop_withRoot_";
	
	public static final String PROP_WITHT = "_prop_withT_";
	
	public static final String PROP_ROOTOPEN = "_prop_rootOpen_";

	public TreeViewPropertySource(TreeView treeView) {
		super(treeView);
	}
	
	protected void initialize() {
		descriptor = new PropertyDescriptor[] {
				  new MaskatTextPropertyDescriptor(PROP_NAME, "name"),
				  new MaskatTextPropertyDescriptor(PROP_LEFT, "left"),
				  new MaskatTextPropertyDescriptor(PROP_TOP, "top"),
				  new MaskatTextPropertyDescriptor(PROP_WIDTH, "width"),
				  new MaskatTextPropertyDescriptor(PROP_HEIGHT, "height"),
				  new MaskatTextPropertyDescriptor(PROP_TABINDEX, "tabIndex"),
				  new BooleanComboBoxPropertyDescriptor(PROP_AUTORESIZABLEH, "autoResizableH"),
				  new BooleanComboBoxPropertyDescriptor(PROP_AUTORESIZABLEW, "autoResizableW"),
				  new BooleanComboBoxPropertyDescriptor(PROP_BOOLSELACTIVE, "boolSelActive"),
				  new BooleanComboBoxPropertyDescriptor(PROP_DRAGGABLE, "draggable"),
				  new BooleanComboBoxPropertyDescriptor(PROP_DRAGGABLENODE, "draggableNode"),
//				  new MaskatComboBoxPropertyDescriptor(PROP_POSITION, "position", ComboBoxLabelConstants.POSITION),
//				  new BooleanComboBoxPropertyDescriptor(PROP_ROOTOPEN, "rootOpen"),
				  new BooleanComboBoxPropertyDescriptor(PROP_WITHROOT, "withRoot"),
				  new BooleanComboBoxPropertyDescriptor(PROP_WITHT, "withT")};
		
		//make sure the "..." values are the same as bean's properties.
	    propMap.put(PROP_NAME, "name");
	    propMap.put(PROP_TOP, "top");
	    propMap.put(PROP_LEFT, "left");
	    propMap.put(PROP_WIDTH, "width");
	    propMap.put(PROP_HEIGHT, "height");
	    propMap.put(PROP_AUTORESIZABLEH, "autoResizableH");
	    propMap.put(PROP_AUTORESIZABLEW, "autoResizableW");
	    propMap.put(PROP_BOOLSELACTIVE, "boolSelActive");
	    propMap.put(PROP_DRAGGABLE, "draggable");
	    propMap.put(PROP_DRAGGABLENODE, "draggableNode");
//	    propMap.put(PROP_POSITION, "position");
	    propMap.put(PROP_TABINDEX, "tabIndex");
	    propMap.put(PROP_WITHROOT, "withRoot");
	    propMap.put(PROP_WITHT, "withT");
//	    propMap.put(PROP_ROOTOPEN, "rootOpen");

	}
}
