/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.swt.graphics.Image;

import org.maskat.ui.ISharedImages;
import org.maskat.ui.MaskatUIPlugin;

public class CodeLibFigure extends Label {
	private boolean withLabelInput;
	
	public CodeLibFigure(boolean isLabel) {
		setForegroundColor(ColorConstants.black);
		setLayoutManager(new XYLayout());
		withLabelInput = isLabel;
	}
	
	protected void paintFigure(Graphics graphics) {
		super.paintFigure(graphics);
		graphics.translate(bounds.x, bounds.y);
		graphics.drawRectangle(3, 3, 30, 14);
		
		Image icon = MaskatUIPlugin.getImage(ISharedImages.IMG_CODELIBBUTTON);
		graphics.drawImage(icon, 37, 2);
		if (withLabelInput) {
			graphics.drawRectangle(60, 3, bounds.width - 65, 14);
		}
		graphics.translate(-bounds.x, -bounds.y);
	}

	public void setWithLabelInput(boolean withLabelInput) {
		this.withLabelInput = withLabelInput;
	}
}
