/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout.custom;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.beanutils.BasicDynaClass;
import org.apache.commons.beanutils.DynaProperty;

import org.maskat.core.MaskatElement;

public class DynaComponentClass extends BasicDynaClass {
	
	private static final long serialVersionUID = 5110101941810053916L;

	public static final int NONE = 0;

	public static final int RESIZABLE_WIDTH = 0x01;

	public static final int RESIZABLE_HEIGHT = 0x02;

	public static final int RESIZABLE_BOTH = RESIZABLE_WIDTH | RESIZABLE_HEIGHT;

	public static final int NO_FOCUS = 0x04;

	public static final int CONTAINER = 0x08;

	private ComponentLibrary library;
	
	private String[] eventTypes;

	private int flag;
	
	private String qualifiedName; 	

	public DynaComponentClass() {
		super();
	}
	
	public DynaComponentClass(String name, Class dynaBeanClass, DynaProperty[] properties) {
		super(name, dynaBeanClass, properties);
	}
	
	public DynaComponentClass(ComponentLibrary library, String name,
			DynaProperty[] properties, String[] eventTypes, int flag) {
		super(name, null, null);
		this.library = library;
		this.flag = flag;
		if (library.getPrefix() != null) {
			this.qualifiedName = library.getPrefix() + ":" + name;
		}
		setDynaBeanClass(isContainer() ? DynaContainer.class
				: DynaComponent.class);
		setProperties(properties);
		setEventTypes(eventTypes);
	}
	
	protected void setProperties(DynaProperty[] properties) {
		List list = new ArrayList();
		list.add(new DynaProperty("parent", MaskatElement.class));
		list.add(new DynaProperty("children", List.class));
		list.add(new DynaProperty("name", String.class));
		list.add(new DynaProperty("left", Integer.class));
		list.add(new DynaProperty("top", Integer.class));

		if (isWidthResizable()) {
			list.add(new DynaProperty("width", Integer.class));
		}
		if (isHeightResizable()) {
			list.add(new DynaProperty("height", Integer.class));
		}
		if (canFocus()) {
			list.add(new DynaProperty("tabIndex", Integer.class));
		}
		
		if (properties != null) {
			for (int i = 0; i < properties.length; i++) {
				list.add(properties[i]);
			}
		}

		super.setProperties((DynaProperty[]) list.toArray(new DynaProperty[list
				.size()]));
	}
	
	public void setDynaProperties(DynaProperty[] properties) {
        setProperties(properties);
    }
	
	public void setDynaBeanClass(Class dynaBeanClass) {
        super.setDynaBeanClass(dynaBeanClass);
    }
	
	public String[] getEventTypes() {
		return eventTypes;
	}
	
	protected void setEventTypes(String[] eventTypes) {
		this.eventTypes = eventTypes;
	}

	public ComponentLibrary getLibrary() {
		return library;
	}

	public boolean isFlagSet(int check) {
		return (flag & check) > 0;
	}

	public boolean isWidthResizable() {
		return isFlagSet(RESIZABLE_WIDTH);
	}
	
	public boolean isHeightResizable() {
		return isFlagSet(RESIZABLE_HEIGHT);
	}
	
	public boolean isContainer() {
		return isFlagSet(CONTAINER);
	}

	public boolean canFocus() {
		return !isFlagSet(NO_FOCUS);
	}

	public String getQualifiedName() {
		return this.qualifiedName;
	}
	
	public void setqualifiedName(String name) {
		this.qualifiedName = name;
	}
}
