/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout.custom;

import java.util.HashMap;
import java.util.Map;

public class ComponentLibrary {
	
	private String prefix;

	private String namespaceURI;

	/**
	 * Map of the configuration of customized component. key is component node
	 * name. value is one IComponentPluginConfig.
	 */
	private Map types;

	public ComponentLibrary(String prefix, String namespaceURI) {
		super();
		this.prefix = prefix;
		this.namespaceURI = namespaceURI;
	}

	public String getPrefix() {
		return prefix;
	}

	public String getNamespaceURI() {
		return namespaceURI;
	}

	public Object getComponentType(String name)
			/*throws UnknownComponentException */{
		if (types == null || !types.containsKey(name)) {
//			throw new UnknownComponentException("Component definition for \"" + name
//					+ "\" is not found.");
			return null;
		}
		return types.get(name);
	}
	
	public boolean containsComponent(String name) {
		return !(types == null || !types.containsKey(name));
	}

	public Object[] getComponentTypes() {
		return types.values().toArray();
	}

	public void registerComponentType(String name, Object type) {
		if (types == null) {
			types = new HashMap();
		}
		types.put(name, type);
	}

}
