/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

public class Window extends AbstractContainer {
	
	public static final String TITLE_DEFAULT = "Window";
	
	public static final String ICONE_DEFAULT = "images/imgFenSimple/picto-gr_default.gif";
	
	public static final boolean WITHOUT_PLACE_IN_DEFAULT = false;
	
	public static final boolean WITH_CLOSE_BUTTON_DEFAULT = true;
	
	public static final boolean AUTO_RESIZABLE_H_DEFAULT = true;
	
	public static final boolean AUTO_RESIZABLE_W_DEFAULT = true;
	
	public static final String POSITION_DEFAULT = "absolute";
	
	public static final int TOP_DEFAULT = 0;
	
	public static final int LEFT_DEFAULT = 0;
	
	public static final String STYLE_DEFAULT = "fenetre";

	private String title = TITLE_DEFAULT;

	private String icone = ICONE_DEFAULT;
	
	private boolean bWithoutPlaceIn = WITHOUT_PLACE_IN_DEFAULT;
	
	private boolean withCloseButon = WITH_CLOSE_BUTTON_DEFAULT;
	
	private boolean autoResizableH = AUTO_RESIZABLE_H_DEFAULT;
	
	private boolean autoResizableW = AUTO_RESIZABLE_W_DEFAULT;
	
	private String position = POSITION_DEFAULT;
	
	private String style = STYLE_DEFAULT;

	
	public String getIcone() {
		return icone;
	}

	public void setIcone(String icone) {
		this.icone = icone;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public boolean isBWithoutPlaceIn() {
		return bWithoutPlaceIn;
	}

	public void setBWithoutPlaceIn(boolean withoutPlaceIn) {
		bWithoutPlaceIn = withoutPlaceIn;
	}

	public boolean isWithCloseButon() {
		return withCloseButon;
	}

	public void setWithCloseButon(boolean withCloseButon) {
		this.withCloseButon = withCloseButon;
	}

	public boolean isAutoResizableH() {
		return autoResizableH;
	}

	public void setAutoResizableH(boolean autoResizableH) {
		this.autoResizableH = autoResizableH;
	}

	public boolean isAutoResizableW() {
		return autoResizableW;
	}

	public void setAutoResizableW(boolean autoResizableW) {
		this.autoResizableW = autoResizableW;
	}

	public String getPosition() {
		return position;
	}

	public void setPosition(String position) {
		this.position = position;
	}
	
	public String getStyle() {
		return this.style;
	}
	
	public void setStyle(String v) {
		this.style = v;
	}

}
