/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

import org.maskat.core.event.EventTypeConstants;

public class TreeView extends AbstractStructuredComponent {
	
	public static final String POSITION_DEFAULT = "absolute";
	
	public static final boolean BOOL_SEL_ACTIVE_DEFAULT = true;
	
	public static final boolean WITH_ROOT_DEFAULT = true;
	
	public static final boolean WITH_T_DEFAULT = true;
	
	public static final boolean DRAGGABLE_DEFAULT = false;
	
	public static final boolean DRAGGABLE_NODE_DEFAULT = false;
	
	public static final boolean AUTO_RESIZABLE_H_DEFAULT = false;
	
	public static final boolean AUTO_RESIZABLE_W_DEFAULT = false;
	
	public static final int TABINDEX_DEFAULT = -1;
	
//	public static final boolean ROOT_OPEN_DEFAULT = true;

	private boolean boolSelActive = BOOL_SEL_ACTIVE_DEFAULT;

	private boolean withRoot = WITH_ROOT_DEFAULT;

//	private boolean rootOpen = ROOT_OPEN_DEFAULT;

	private boolean withT = WITH_T_DEFAULT;

	private boolean autoResizableH = AUTO_RESIZABLE_H_DEFAULT;

	private boolean autoResizableW = AUTO_RESIZABLE_W_DEFAULT;

	private boolean draggable = DRAGGABLE_DEFAULT;
	
	private boolean draggableNode = DRAGGABLE_NODE_DEFAULT;

	private String rootNode;
	
	private String position = POSITION_DEFAULT;

	public TreeView() {
		setTabIndex(TABINDEX_DEFAULT);
	}
	
	public boolean isAutoResizableH() {
		return autoResizableH;
	}

	public void setAutoResizableH(boolean autoResizableH) {
		this.autoResizableH = autoResizableH;
	}

	public boolean isAutoResizableW() {
		return autoResizableW;
	}

	public void setAutoResizableW(boolean autoResizableW) {
		this.autoResizableW = autoResizableW;
	}
	
	public boolean isDraggable() {
		return draggable;
	}

	public void setDraggable(boolean draggable) {
		this.draggable = draggable;
	}

	public boolean isDraggableNode() {
		return draggableNode;
	}

	public void setDraggableNode(boolean draggableNode) {
		this.draggableNode = draggableNode;
	}

	public boolean isBoolSelActive() {
		return boolSelActive;
	}

	public void setBoolSelActive(boolean boolSelActive) {
		this.boolSelActive = boolSelActive;
	}

//	public boolean isRootOpen() {
//		return rootOpen;
//	}
//
//	public void setRootOpen(boolean rootOpen) {
//		this.rootOpen = rootOpen;
//	}

	public boolean isWithRoot() {
		return withRoot;
	}

	public void setWithRoot(boolean withRoot) {
		this.withRoot = withRoot;
	}

	public boolean isWithT() {
		return withT;
	}

	public void setWithT(boolean withT) {
		this.withT = withT;
	}

	public String getRootNode() {
		return rootNode;
	}

	public void setRootNode(String rootNode) {
		this.rootNode = rootNode;
	}

	public String getPosition() {
		return position;
	}

	public void setPosition(String position) {
		this.position = position;
	}

	public void iterateTree() {
		// TODO 子ノードとしていくつかのTreeNodeDefを持っている可能性もある
		TreeNode def = (TreeNode) getChildByTypeIdx(TreeNode.class, 0);
		if (def != null) {
			def.setLayer(0);
			def.travel(0);
		}
	}

	public void removeChild(Object obj) {
		super.removeChild(obj);
		firePropertyChange("removeChild", "", null);
	}

	public void addChild(Object obj) {
		super.addChild(obj);
		firePropertyChange("addChild", "", null);
	}

	public void addChildToIdx(Object child, int idx) {
		super.addChildToIdx(child, idx);
		firePropertyChange("addChild", "", null);
	}

	public String[] getEventTypes() {
		return new String[] {EventTypeConstants.ON_CLICK};
	}

	public boolean canAddPart(ComponentPart child) {
		return (child instanceof TreeNode);
	}
}
