/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

public class Label extends AbstractComponent {
	
	public static final String CLASS_NAME_DEFAULT = "libNormal";
	
	public static final String POSITION_DEFAULT = "relative";

	private String text;

	private String className = CLASS_NAME_DEFAULT;
	
	private String position = POSITION_DEFAULT;

	public String getText() {
		return text;
	}

	public void setText(String text) {
		String oldText = this.text;
		this.text = text;
		firePropertyChange("text", oldText, text);
	}

	public String getClassName() {
		return className;
	}

	public void setClassName(String className) {
		this.className = className;
	}
	
	public String getPosition() {
		return position;
	}
	
	public void setPosition(String position) {
		this.position = position;
	}
}
