/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

/**
 * XXX comboItem should not extends ComponentDef. It don't has many features of
 * component. for example: no name, no size...
 */
public class ComboItem extends AbstractComponent implements ComponentPart {

	private String text;

	private String value;

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
		this.firePropertyChange("text", null, "");
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

}
