#ifndef __VVDOBJECT_H__
#define __VVDOBJECT_H__

#include <stdio.h>
#include <stdlib.h>

#include <iostream>
#include <fstream>
#include <sstream>
#include <string>
#include <vector>

#include "GLObject.h"


using namespace std;

float CalcTriangleArea(float *v0,float *v1,float *v2);

class VVDImage{
 private:
  int width,height;
  vector<unsigned char> buf;

 public:
  VVDImage();
  VVDImage(int w,int h);

  ~VVDImage(){}

  void setImage(int nw,int nh,unsigned char *nbuf);
  int getWidth(){return width;}
  int getHeight(){return height;}
  unsigned char *getBuffer(){return &buf[0];}
};


class VVDObject{
 private:
  vector <float> vertices;
  vector <int> faces;
  vector <float> texcoords;
  vector <int> texindexes;
  vector <float> facenormals;

  vector <VVDImage *> images;

  // for GLObject
  vector <GLMaterial *> materials;
  vector <int> nfaces;
  vector <int> tfaces;

 public:
  VVDObject(){}
  ~VVDObject(){}

  void setVertices(vector<float> &vv);
  void setFaces(vector<int> &ff);
  void setTexCoords(vector<float> &tc);
  void setTexIndexes(vector<int> &ti);

  void setVertices(int length,float *vv);
  void setFaces(int length,int *ff);
  void setTexCoords(int length,float *tc);
  void setTexIndexes(int length,int *ti);

  int getVerticesLength(){return vertices.size()/3;}
  int getFacesLength(){return faces.size()/3;}
  int getTexCoordsLength(){return texcoords.size()/6;}
  int getTexIndexesLength(){return texindexes.size();}

  float *getVertices(){return &vertices[0];}
  int *getFaces(){return &faces[0];}
  float *getTexCoords(){return &texcoords[0];}
  int *getTexIndexes(){return &texindexes[0];}

  void createVVDImageList(int num);
  void setImage(int idx,int width,int height,unsigned char *buf);

  void convertImageToMaterial();
  void calcFaceNormal();
  void recreateFaces();
  GLPolygon *createGLPolygon();
  
  void calcFaceArea();
};

#endif
