// Symmetric Hough

#include "SymmetricHough.h"



// SymmetricHough
/*
SymmetricHough::SymmetricHough(){
  init();
}
*/

SymmetricHough::SymmetricHough(const IplImage *img){
  init();
  setInImage(img);
  setHoughSpace(height/2,2,180,2);
  setRegion(height*8/10);
}

SymmetricHough::~SymmetricHough(){
  cvReleaseImage(&inimage);
  cvReleaseImage(&rotimage);
  cvReleaseImage(&bimage);
  cvReleaseImage(&veimage);
  cvReleaseImage(&hsimage);
}

void SymmetricHough::init(){
  width=640;
  height=480;
  rsize=400;

  inimage=cvCreateImage(cvSize(width,height),IPL_DEPTH_8U,1);
  binimage.resize(width*height);

  rotimage=NULL;
  bimage=cvCreateImage(cvSize(width,height),IPL_DEPTH_8U,1);
  hsimage=NULL;

  minrange=5;maxrange=100;

  pi=atan(1.0)*4.0;

  btenarray.resize(3*10);

  veimage=cvCreateImage(cvSize(width,height),IPL_DEPTH_8U,3);
}

void SymmetricHough::setInImage(const IplImage *img){
  cvCopy(img,inimage);
  createBinImage();
}

void SymmetricHough::setRegion(int nrsize){
  setRegion(nrsize,width/2,height/2);
}

void SymmetricHough::setRegion(int nrsize,int ccx,int ccy){
  bool isreconst=nrsize!=rsize;
  if(isreconst) rsize=nrsize;

  cx=ccx;cy=ccy;

  if(rotimage==NULL || isreconst){
    if(rotimage!=NULL) cvReleaseImage(&rotimage);
    rotimage=cvCreateImage(cvSize(rsize,rsize),IPL_DEPTH_8U,1);
  }
  sedgearray.resize(rsize*rsize*2);
  rotregion.resize(rsize*rsize);

}

void SymmetricHough::setHoughSpace(int rrange,int rskip,int trange,int tskip){
  setHoughSpace(-rrange/2,rrange/2,rskip,-trange/2,trange/2,tskip);
}

void SymmetricHough::setHoughSpace(int rstart,int rend,int rskip,int tstart,int tend,int tskip){
  int nhsr,nhst;
  bool isreconst;

  rhostart=rstart;
  rhoend=rend;
  rhoskip=rskip;

  thetastart=tstart;
  thetaend=tend;
  thetaskip=tskip;

  nhsr=abs((rend-rstart)/rhoskip);
  nhst=abs((tend-tstart)/thetaskip);
  isreconst=(hsrsize!=nhsr || hstsize!=nhst);

  if(isreconst){
    hsrsize=nhsr;hstsize=nhst;
  }

  if(hsimage==NULL || isreconst){
    if(hsimage!=NULL) cvReleaseImage(&hsimage);
    hsimage=cvCreateImage(cvSize(hsrsize,hstsize),IPL_DEPTH_8U,1);
  }

  createVoteArray();
}

void SymmetricHough::setRange(int minr,int maxr){
  minrange=minr;
  maxrange=maxr;
}

void SymmetricHough::createBinImage(){
  int i,j,xidx;
  unsigned char *buf;

  buf=(unsigned char *)inimage->imageData;
  for(j=0;j<height;j++){
    xidx=j*width;
      for(i=0;i<width;i++){
      if(buf[i+xidx]>127){
	binimage[i+xidx]=1;
      }else{
	binimage[i+xidx]=0;
      }
    }
  }
}

void SymmetricHough::setValidRegion(int *itable,int bw,int bh){
  int i,j,k,l,txidx,tidx,ixidx,ixxidx,iidx;;
  int wl=width/bw;
  int hl=height/bh;

  for(i=0;i<hl;i++){
    txidx=i*wl;
    for(j=0;j<wl;j++){
      tidx=txidx+j;
      ixidx=(i*bh)*width+(j*bw);

      if(itable[tidx]==0){
	for(k=0;k<bh;k++){
	  ixxidx=ixidx+k*width;
	  for(l=0;l<bw;l++){
	    iidx=ixxidx+l;
	    binimage[iidx]=0;
	  }
	}
      }

    }
  }

}

void SymmetricHough::createVoteArray(){
  int i;

  votearray.resize(hsrsize*hstsize);

  for(i=0;i<hsrsize*hstsize;i++)
    votearray[i]=0;
}

void SymmetricHough::rotateBinImage(int theta){
  int i,j;
  int inx,iny,targx,targy;
  double dtheta=(theta*pi/180.0);
  double cost=cos(dtheta),sint=sin(dtheta);

  for(i=0;i<rsize;i++){
    targx=i-(rsize/2);
    for(j=0;j<rsize;j++){
      targy=j-(rsize/2);

      inx=(int)(cost*targx+sint*targy+0.5)+cx;
      iny=(int)(-sint*targx+cost*targy+0.5)+cy;

      if(inx>=0 && inx<width && iny>=0 && iny<height){
	rotregion[i+j*rsize]=binimage[inx+iny*width];
      }else{
	rotregion[i+j*rsize]=0;
      }

    }
  }
}


int SymmetricHough::getHSSize(){
  return hsrsize*hstsize;
}


void *SymmetricHough::getRotateImage(int theta){
  unsigned char *buf=(unsigned char *)rotimage->imageData;
  rotateBinImage(theta);
  for(int i=0;i<rsize;i++){
    for(int j=0;j<rsize;j++){
      buf[i*rsize+j]=rotregion[i*rsize+j]*255;
    }
  }
  return rotimage;
}

void *SymmetricHough::getBinImage(){
  unsigned char *buf=(unsigned char *)bimage->imageData;
  for(int i=0;i<width;i++){
    for(int j=0;j<height;j++){
      buf[j*width+i]=binimage[j*width+i]*255;
    }
  }
  return bimage;
}

void *SymmetricHough::getHoughSpaceImage(){
  int i,j,maxv=0,idx;
  double rate;
  unsigned char *buf=(unsigned char *)hsimage->imageData;

  // max value
  for(i=0;i<(hsrsize*hstsize);i++){
    if(maxv<votearray[i]) maxv=votearray[i];
  }

  rate=254.0/(double)maxv;

  for(i=0;i<hsrsize;i++){
    for(j=0;j<hstsize;j++){
      idx=j*hsrsize+i;
      buf[idx]=(int)(rate*votearray[idx]);
    }
  }

  return hsimage;
}


void SymmetricHough::convertOnce(int rho,int theta){
  unsigned char *outbuf=(unsigned char *)veimage->imageData;
  int ofs=(height-rsize)/2,val=0,i,j,k,ix,rx,px,exx,isfind,bw,inx,iny;
  double dtheta=(theta*pi/180.0);
  double cost=cos(dtheta),sint=sin(dtheta);

  for(i=0;i<width*height*3;i++) outbuf[i]=255;

  rotateBinImage(theta);
  // copy binimage to outbuf
  for(i=0;i<rsize;i++){
    ix=(i+ofs)*width;
    rx=i*rsize;
    for(j=0;j<rsize;j++){
      if(j==(rho+rsize/2)){
	outbuf[(ix+j+ofs)*3+0]=255;
	outbuf[(ix+j+ofs)*3+1]=0;
	outbuf[(ix+j+ofs)*3+2]=0;
      }else{
	px=rotregion[rx+j]*255;

	// find symmetrical edge
	if(px==255){
	  bw=rsize/2+rho-j;;
	  exx=2*(rsize/2+rho)-j;
	  if(exx<1 || exx>rsize-1 || abs(bw)<minrange || abs(bw)>maxrange){
	    for(k=0;k<3;k++){
	      outbuf[(ix+j+ofs)*3+k]=px;
	    }
	  }else{
	    isfind=
	      (rotregion[rx+exx-1]|rotregion[rx+exx]|rotregion[rx+exx+1]);
	    if(isfind==1){
	      outbuf[(ix+j+ofs)*3+0]=255;
	      outbuf[(ix+j+ofs)*3+1]=0;
	      outbuf[(ix+j+ofs)*3+2]=0;

	      // transform to Image coordinate
	      inx=(int)(cost*(j-rsize/2)+sint*(i-rsize/2)+0.5)+cx;
	      iny=(int)(-sint*(j-rsize/2)+cost*(i-rsize/2)+0.5)+cy;
	      sedgearray[val*2+0]=inx;
	      sedgearray[val*2+1]=iny;
	      val++;
	    }else{
	      for(k=0;k<3;k++){
		outbuf[(ix+j+ofs)*3+k]=px;
	      }
	    }
	  }
	}else{
	  for(k=0;k<3;k++){
	    outbuf[(ix+j+ofs)*3+k]=px;
	  }
	}
      }
    }
  }
  sedgearray[val*2+0]=-1;
  sedgearray[val*2+1]=-1;
  valo=val;
}

int SymmetricHough::getValueOnce(){
  return valo;
}


IplImage *SymmetricHough::getSymmetricalEdgeImage(){
  return veimage;
}



void SymmetricHough::convert(){
  int rho,theta,val,i,j,ecnt,xx,eidx,exx,bw,rhocnt,thcnt;
  vector<int> edgeidx;

  edgeidx.resize(rsize*rsize);
  createVoteArray();

  // voting
  for(theta=thetastart;theta<thetaend;theta+=thetaskip){
    thcnt=(theta-thetastart)/thetaskip;
    // 摜obt@̉]
    rotateBinImage(theta);
    // GbW_̃CfbNX

    for(i=0;i<rsize;i++){
      ecnt=0;
      xx=i*rsize;
      for(j=0;j<rsize;j++){
	if(rotregion[xx+j]==1){
	  edgeidx[xx+ecnt]=j;
	  ecnt++;
	}
      }
      if(ecnt!=rsize)edgeidx[rsize*i+ecnt]=-1;
    }

    // CfbNX
    for(i=0;i<rsize;i++){
      xx=i*rsize;
      for(j=0;j<rsize;j++){
	eidx=edgeidx[xx+j];
	if(eidx<0)break;
	for(rho=rhostart;rho<rhoend;rho+=rhoskip){
	  rhocnt=(rho-rhostart)/rhoskip;
	  bw=(rsize/2+rho)-eidx;
	  if(abs(bw)<minrange || abs(bw)>maxrange)continue;

	  exx=2*(rsize/2+rho)-eidx;
	  if(exx<1)continue;
	  if(exx>rsize-1)break;

	  // Α+-1sNZȓɃGbW邩ǂ
	  votearray[hsrsize*thcnt+rhocnt]+=
	    //(rotregion[xx+exx-1]|rotregion[xx+exx]|rotregion[xx+exx+1]);
	    rotregion[xx+exx];

	}
      }
    }
  }
}

vector<int> SymmetricHough::getResult(){
  return votearray;
}

vector<int> SymmetricHough::getBest10(){
  int rho,theta,val,i,j,k,val10=0,maxval=0,rhocnt,thcnt;
  
  for(i=0;i<30;i++)btenarray[i]=0;

  for(rho=rhostart;rho<rhoend;rho+=rhoskip){
    rhocnt=(rho-rhostart)/rhoskip;
    for(theta=thetastart;theta<thetaend;theta+=thetaskip){
      thcnt=(theta-thetastart)/thetaskip;
      val=votearray[thcnt*hsrsize+rhocnt];

      // best 10
      if(val>maxval){
	for(i=9;i>0;i--){
	  for(j=0;j<3;j++){
	    btenarray[i*3+j]=btenarray[(i-1)*3+j];
	  }
	}
	btenarray[0]=val;
	btenarray[1]=rho;
	btenarray[2]=theta;
	
      }else if(val>val10){
	for(i=9;i>=0;i--){
	  if(val<btenarray[i*3]){
	    // drop down
	    for(j=9;j>i+1;j--){
	      for(k=0;k<3;k++){
		btenarray[j*3+k]=btenarray[(j-1)*3+k];
	      }
	    }

	    btenarray[(i+1)*3]=val;
	    btenarray[(i+1)*3+1]=rho;
	    btenarray[(i+1)*3+2]=theta;
	
	    break;
	  }
	}
      }

      maxval=btenarray[0];
      val10=btenarray[27];
    }
  }

  return btenarray;
}
