#ifndef __PFBUNDLEADJUST_H__
#define __PFBUNDLEADJUST_H__

#include "HYParticleFilter.h"

class BundleAdjustFilter : public HYParticleFilter{
 private:
  float txcenter,txrange,
    tycenter,tyrange,
    tzcenter,tzrange,
    rxcenter,rxrange,
    rycenter,ryrange,
    rzcenter,rzrange;
  float tx,ty,tz,rx,ry,rz;
  float sinrx,cosrx,sinry,cosry,sinrz,cosrz;
  int npoints,npoints_max;
    
  float *points3d,*points2d;
  float focal;
  float mnoise;

 public:
  BundleAdjustFilter(int np,float rr,float mn,
		     float txc,float txr,
		     float tyc,float tyr,
		     float tzc,float tzr,
		     float rxc,float rxr,
		     float ryc,float ryr,
		     float rzc,float rzr);
  ~BundleAdjustFilter();
  
  void predict();
  float likelihood(float *state);
  void stateToCoords(float *state);
  void setPoints(float *pts3d,float *pts2d,int num);
  void setCameraParams(float ff);
  
  void setTXCenter(float txc){txcenter=txc;}
  void setTXRange(float txr){txrange=txr;}
  void setTYCenter(float tyc){tycenter=tyc;}
  void setTYRange(float tyr){tyrange=tyr;}
  void setTZCenter(float tzc){tzcenter=tzc;}
  void setTZRange(float tzr){tzrange=tzr;}
  void setRXCenter(float rxc){rxcenter=rxc;}
  void setRXRange(float rxr){rxrange=rxr;}
  void setRYCenter(float ryc){rycenter=ryc;}
  void setRYRange(float ryr){ryrange=ryr;}
  void setRZCenter(float rzc){rzcenter=rzc;}
  void setRZRange(float rzr){rzrange=rzr;}

  void setMeasurementNoise(float mn){mnoise=mn;}

  void getCoords(float *vv);
};

// for known marker


class VectorBundleAdjustFilter : public HYParticleFilter{
 private:
  float tcenter,trange,
    rxcenter,rxrange,
    rycenter,ryrange,
    rzcenter,rzrange;

  float tx,ty,tz,rx,ry,rz;
  float sinrx,cosrx,sinry,cosry,sinrz,cosrz;
  int npoints,npoints_max;
  float *vec;
    
  float *points3d,*points2d;
  float focal;
  float mnoise;

 public:
  VectorBundleAdjustFilter(int np,float rr,float mn,
		     float tc,float tr,
		     float rxc,float rxr,
		     float ryc,float ryr,
		     float rzc,float rzr);
  ~VectorBundleAdjustFilter();

  void predict();
  float likelihood(float *state);
  void stateToCoords(float *state);
  void setPoints(float *pts3d,float *pts2d,int num);
  void setCameraParams(float ff);

  void setRayVector(float *rvec){memcpy(vec,rvec,sizeof(float)*3);}

  void setTXCenter(float tc){tcenter=tc;}
  void setTXRange(float tr){trange=tr;}
  void setRXCenter(float rxc){rxcenter=rxc;}
  void setRXRange(float rxr){rxrange=rxr;}
  void setRYCenter(float ryc){rycenter=ryc;}
  void setRYRange(float ryr){ryrange=ryr;}
  void setRZCenter(float rzc){rzcenter=rzc;}
  void setRZRange(float rzr){rzrange=rzr;}

  void setMeasurementNoise(float mn){mnoise=mn;}

  void getCoords(float *vv);
};



#endif
