#ifndef __MARKERGENERATION_H__
#define __MARKERGENERATION_H__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <iostream>
#include <vector>
#include <string>

#include <cv.h>
#include <cvaux.h>
#include <cxcore.h>

#include "HYParticleFilter.h"
#include "SymmetricHough.h"

using namespace std;


void generateRandomIndexList(int num,int *ilist);
float distanceLineVertices(float *verts);
bool crossPointLineVertices(float *verts,float *crossp);


class RectangleFilter : public HYParticleFilter{
 private:
  float *vertices;
  float *cxylist;
  float rangex,rangey;
  vector<float> lines;
  float mnoise;
    
 public:
  RectangleFilter(int np,float rr,float mn,float *cxy,float rx,float ry);
  ~RectangleFilter();

  void predict(){}
  float likelihood(float *state);
  void setCenters(float *cxy);

  void stateToVertices(float *state,float *verts);

  void getVertices(float *verts);
  void setLines(vector<float> lvs);
};


class MarkerGenerationHough{
 private:
  int width,height;
  IplImage *cvinimage,*cvoutimage,*cvcannyimage;
  unsigned char *inbuf,*outbuf;
  float cvcannyhigh,cvcannylow;
  int cvhoughthresh;
  float cvhoughlength,cvhoughcat;
  CvMemStorage *storage;
  CvSeq *lines;
  int nlines;
  vector<float> linevector;
  SymmetricHough *symhough;

 public:
  MarkerGenerationHough();
  ~MarkerGenerationHough();

  void setInImage(unsigned char *buf);
  void getOutImage(unsigned char *buf);
  void getCannyImage(unsigned char *buf);

  int getLinesNum(){return nlines;}
  void getLines(float *buf){memcpy(buf,&linevector[0],sizeof(float)*nlines*4);}

  void setCannyHigh(float val){cvcannyhigh=val;}
  void setCannyLow(float val){cvcannylow=val;}

  void setHoughThresh(int val){cvhoughthresh=val;}
  void setHoughLength(float val){cvhoughlength=val;}
  void setHoughCat(float val){cvhoughcat=val;}

  void procSymmetry();
  void proc();
  bool fitToRect();
};


enum markergen_draw_type{
  MG_CIRCLE,
  MG_LINE
};

struct markergen_draw_command{
  int points[4];
  markergen_draw_type type;
};

void mgComCircle(markergen_draw_command *com,int cx,int cy,int rr);
void mgComLine(markergen_draw_command *com,int x0,int y0,int x1,int y1);
void mgDraw(IplImage *img,markergen_draw_command *com,CvScalar color,int thickness);


class MarkerGenerationGraphCut{
 private:
  int width,height;
  IplImage *cvinimage,*cvlabelimage,*cvoutimage;
  unsigned char *inbuf,*outbuf;
  IplImage *cvedgeimage;
  CvMemStorage *storage;
  CvSeq *lines;
  int nlines;
  vector<float> linevector;
  float rect_verts[8];
  CvMat *persemat;

  vector<markergen_draw_command> fore_commands;
  vector<markergen_draw_command> back_commands;


 public:
  MarkerGenerationGraphCut();
  ~MarkerGenerationGraphCut();

  void setInImage(unsigned char *buf);
  void getInImage(unsigned char *buf);
  void getOutImage(unsigned char *buf);

  void setDefaultCommands();
  void setMinimumCommands();
  void addCommand(unsigned char ctype,markergen_draw_type type,int *pts);

  void drawLabel(IplImage *img,CvScalar color0,CvScalar color1,int thickness);

  void clearLabel();
  void initLabel();
  void proc();
  void graphCut();
  bool fitToRect();
  void getRectangle(float *buf){
    memcpy(buf,rect_verts,sizeof(float)*8);
  }

  IplImage *generateMarkerImage();
};



#endif
