#include <time.h>
#include <math.h>

#include "DSCapture.h"
#include "GtkView.h"
#include "ImageProcs.h"
#include "HYParticleFilter.h"
#include "PFBundleAdjust.h"
#include "HYPsf.h"
#include "GLObject.h"
#include "ObjectFileManager.h"
#include "PMDFileManager.h"
#include "MQOFileManager.h"
#include "ImageManager.h"
#include "TextureBoardManager.h"
#include "SURFConverter.h"
#include "SURFManager.h"
#include "MarkerGeneration.h"
#include "GtkCtrl.h"
#include "GtkCameraSelect.h"
#include "GtkMarkerView.h"
#include "GtkThumbView.h"

//#include <highgui.h>

#define PI (atan(1.0)*4.0)

using namespace std;

static DSCapture *dsc;
static GtkView *gview;

static MonoMarkerFinder *monomark;
static FeatureTracker *track;
static SFMManager *sfmm;

static float *corners1,*corners2;
static char *status;

static unsigned int timeout_id=0;
static bool isProcRunning=false;

static unsigned char *imgbuf;
static int *monocorners;

static GLObject *globj;
static GLObjObject *globjobj;
static GLPMDObject *glpmd;
static GLFeaturePoints *glfp;
static GLGrid *grid;
static GLCoordinate *coords;
static GLPolygon *glp0,*glp1,*glp2;
static GLObjObject *reimu,*marisa;

static vector<GLObject *> globjlist;

static HYPsf *psf;

static BundleAdjustFilter *badj;

static SURFConverter *surf;
static SURFManager *surfman;

static MarkerGenerationHough *mgh;
static MarkerGenerationGraphCut *mggc;

static GLObjObject *dummy;

static GtkCtrl *gctrl;

static bool isRunMGGC=false;

static bool isRunSFM=false;
static float old_trans[3];
static float old_rot[3];

static IplImage *genmarker=NULL;
static GtkMarkerView *gmv;

static GtkCameraSelect *gcamsel;

static GtkThumbView *gtv;

// yattuke
static float oldmx=0.0,oldmy=0.0;
static unsigned char omdcount;

//////////////////////////////////


static bool readObjIniFile(string fname,GLObjObject *globj){
  string buf,str0,str1;
  int i;
  float tvec[3],rvec[3];
  float objscale;

  string objfile="";
  string mtlfile="";


  objscale=1.0;
  tvec[0]=tvec[1]=tvec[2]=0.0;
  rvec[0]=rvec[1]=rvec[2]=0.0;

  ifstream ifs(fname.c_str());
  if(!ifs){
    cerr << "ini file not found: " << fname << endl;
    cerr << "loading default settings" << endl;
    return false;
  }

  while(getline(ifs,buf)){
    stringstream sin(buf);
    sin >> str0;
    
    if(str0=="objfile"){
      sin >> str1;
      objfile=str1;
    }else if(str0=="mtlfile"){
      sin >> str1;
      mtlfile=str1;
    }else if(str0=="objscale"){
      sin >> str1;
      objscale=atof(str1.c_str());
    }else if(str0=="objtrans"){
      for(i=0;i<3;i++){
	sin >> str1;
	tvec[i]=atof(str1.c_str());
      }
    }else if(str0=="objrot"){
      cout << "objrot: ";
      for(i=0;i<3;i++){
	sin >> str1;
	rvec[i]=atof(str1.c_str());
	cout << rvec[i] << " ";
      }
      cout << endl;
    }else{
      // comment? ignore?
      //cerr << " invalid key: " << str0 << endl;
    }
  }

  if((objfile=="") || (mtlfile=="")){
    cerr << " file names are empty." << endl;
    cerr << "loading default settings" << endl;
    return false;
  }

  bool ret= readObjFile(objfile,mtlfile,globj,objscale);
  if(!ret){
    cerr << "loading default settings" << endl;
    return false;
  }

  globj->setTranslate(tvec[0],tvec[1],tvec[2]);
  globj->setRotate(rvec[0],rvec[1],rvec[2]);

  return true;
}

static bool readObjIniFile2(string fname){
  string buf,str0,str1;
  int i;
  float tvec[3],rvec[3];
  float objscale;

  string objfile="";
  string mtlfile="";

  GLObject *cur_obj=NULL;

  bool ret;

  objscale=1.0;
  tvec[0]=tvec[1]=tvec[2]=0.0;
  rvec[0]=rvec[1]=rvec[2]=0.0;

  ifstream ifs(fname.c_str());
  if(!ifs){
    cerr << "ini file not found: " << fname << endl;
    cerr << "loading default settings" << endl;
    return false;
  }

  while(getline(ifs,buf)){
    if(buf=="") continue;

    stringstream sin(buf);
    sin >> str0;
    
    objscale=1.0;
    tvec[0]=tvec[1]=tvec[2]=0.0;
    rvec[0]=rvec[1]=rvec[2]=0.0;

    //cout << "read command: " << str0 <<endl;

    if(str0=="objfile"){
      GLObjObject *objobj=new GLObjObject();

      sin >> str1;
      objfile=str1;
      sin >> str1;
      mtlfile=str1;
      sin >> str1;
      objscale=atof(str1.c_str());

      ret = readObjFile(objfile,mtlfile,objobj,objscale);
      if(ret){
	globjlist.push_back((GLObject *)objobj);
	cur_obj=(GLObject *)objobj;
      }
    }else if(str0=="pmdfile"){
      GLPMDObject *pmdobj=new GLPMDObject();

      sin >> str1;
      objfile=str1;
      sin >> str1;
      objscale=atof(str1.c_str());

      ret = readPMDFile(objfile,pmdobj,objscale);
      if(ret){
	globjlist.push_back((GLObject *)pmdobj);
	cur_obj=(GLObject *)pmdobj;
      }
    }else if(str0=="vpdfile"){
      if(cur_obj->getType()=="GLPMDObject"){
	sin >> str1;
	objfile=str1;
	ret = readVPDFile(objfile,(GLPMDObject *)cur_obj);
      }
    }else if(str0=="vmdfile"){
      if(cur_obj->getType()=="GLPMDObject"){
	sin >> str1;
	objfile=str1;
	sin >> str1;
	bool ik=false;
	if(str1=="t" || str1=="true") ik=true;
	sin >> str1;
	unsigned int rf=(unsigned int)atoi(str1.c_str());
	ret = readVMDFile(objfile,(GLPMDObject *)cur_obj,ik,rf);
      }
    }else if(str0=="imagefile"){
      GLPolygon *poly=new GLPolygon();

      sin >> str1;
      objfile=str1;
      sin >> str1;
      objscale=atof(str1.c_str());

      ret = convertImageToGLPolygon(objfile,poly,objscale,objscale);
      if(ret){
	globjlist.push_back((GLObject *)poly);
	cur_obj=(GLObject *)poly;
      }
    }else if(str0=="mqofile"){
      GLMQOObject *mqoobj=new GLMQOObject();

      sin >> str1;
      objfile=str1;
      sin >> str1;
      objscale=atof(str1.c_str());

      ret = readMQOFile(objfile,mqoobj,objscale);
      if(ret){
	globjlist.push_back((GLObject *)mqoobj);
	cur_obj=(GLObject *)mqoobj;
      }
    }else if(str0=="objtrans"){
      for(i=0;i<3;i++){
	sin >> str1;
	tvec[i]=atof(str1.c_str());
      }
      if(cur_obj!=NULL) cur_obj->setTranslate(tvec[0],tvec[1],tvec[2]);
    }else if(str0=="objrot"){
      //cout << "objrot: ";
      for(i=0;i<3;i++){
	sin >> str1;
	rvec[i]=atof(str1.c_str());
	//cout << rvec[i] << " ";
      }
      if(cur_obj!=NULL) cur_obj->setRotate(rvec[0],rvec[1],rvec[2]);
      cout << endl;
    }else{
      // comment? ignore?
      //cerr << " invalid key: " << str0 << endl;
    }
  }
  return true;
}

static HYImage *readMarkerIniFile(string fname){
  HYImage *hyimg;
  string buf,str0,str1;
  string markerfile;

  ifstream ifs(fname.c_str());
  if(!ifs){
    cerr << "ini file not found: " << fname << endl;
    cerr << "loading default settings" << endl;
    return NULL;
  }

  while(getline(ifs,buf)){
    stringstream sin(buf);
    sin >> str0;
    
    if(str0=="markerfile"){
      sin >> str1;
      markerfile=str1;
    }else{
      // comment? ignore?
      //cerr << " invalid key: " << str0 << endl;
    }
  }

  if(markerfile==""){
    cerr << " file names are empty." << endl;
    cerr << "loading default settings" << endl;
    return NULL;
  }
  hyimg=createImageFromFile(markerfile);
  if(hyimg==NULL){
    cerr << " file not found." << endl;
    cerr << "loading default settings" << endl;
  }
  return hyimg;

}


static IplImage *readMarkerIniFile2(string fname){
  IplImage *img;
  string buf,str0,str1;
  string markerfile;

  ifstream ifs(fname.c_str());
  if(!ifs){
    cerr << "ini file not found: " << fname << endl;
    cerr << "loading default settings" << endl;
    return NULL;
  }

  while(getline(ifs,buf)){
    stringstream sin(buf);
    sin >> str0;
    
    if(str0=="markerfile"){
      sin >> str1;
      markerfile=str1;
      break;
    }else{
      // comment? ignore?
      //cerr << " invalid key: " << str0 << endl;
    }
  }

  if(markerfile==""){
    cerr << " file name is empty." << endl;
    cerr << "loading default settings" << endl;
    return NULL;
  }

  cout << "(2) loading " << markerfile << endl;
  img=cvLoadImage(markerfile.c_str(),CV_LOAD_IMAGE_COLOR);

  if(img==NULL){
    cerr << " file not found." << endl;
    cerr << "loading default settings" << endl;
  }
  return img;

}


static bool readMarkerIniFile3(string fname){
  IplImage *img;
  string buf,str0,str1;
  string markerfile;
  int cnt=0;

  ifstream ifs(fname.c_str());
  if(!ifs){
    cerr << "ini file not found: " << fname << endl;
    cerr << "loading default settings" << endl;
    return NULL;
  }

  while(getline(ifs,buf)){
    stringstream sin(buf);
    sin >> str0;
    
    if(str0=="markerfile"){
      sin >> str1;
      markerfile=str1;
      cout << "(3) loading " << markerfile << endl;
      img=cvLoadImage(markerfile.c_str(),CV_LOAD_IMAGE_COLOR);
      if(img==NULL){
	cerr << markerfile << ": file not found." << endl;
      }else{
	surf->pushRefImageList(img);
	gtv->pushImageList(img);
      }
      cvReleaseImage(&img);
      cnt++;
    }else{
      // comment? ignore?
      //cerr << " invalid key: " << str0 << endl;
    }
  }

  if(cnt==0){
    cerr << " file names are empty." << endl;
    cerr << "loading default settings" << endl;
    return false;
  }

  return true;

}



/////////////////////////////////////////

static gboolean view_timer_event(gpointer p){
  int cnt;
  dsc->getBuffer(&cnt,gview->getImageBuffer());
  memcpy(gview->getGLImageBuffer(),gview->getImageBuffer(),640*480*3);
  gview->setImageBuffer();
  gview->redraw();
  return TRUE;
}

static gboolean sfm_timer_event(gpointer p){
  int cnt;
  GdkGC *gc;
  GdkPixmap *pixmap;
  int xx0,xx1,yy0,yy1;
  GdkColor gcolor;
  int tracked;

  float param[6];
  float tmat[16];

  float points3d[600];

  int num3d;
  float xmean,ymean,zmean;

  float psfstate[3];
  float psfparam[3];

  unsigned char ostat,nstat;

  float degrx,degry;

  ostat=sfmm->getStat();

  printf("in sfm_timer_event:\n");

  dsc->getBuffer(&cnt,gview->getImageBuffer());
  memcpy(gview->getGLImageBuffer(),gview->getImageBuffer(),640*480*3);
  gview->setImageBuffer();
  
  track->setImage(gview->getImageBuffer());
  if(!(sfmm->proc())) return false;

  gview->resetMarkPose();
  switch(nstat=sfmm->getStat()){
  case 0:
  case 1:
    sfmm->getFeatures0(corners1);
    sfmm->getFeatures2(corners2);
    sfmm->getTrackStatus(status);

    gc=gview->getGC();
    pixmap=gview->getPixmap();
  
    gdk_gc_set_line_attributes(gc,3,GDK_LINE_SOLID,GDK_CAP_NOT_LAST,GDK_JOIN_MITER);
    gdk_colormap_alloc_color (gdk_colormap_get_system () , &gcolor, TRUE, TRUE);
    gcolor.red=0x0000;
    gcolor.green=0xffff;
    gcolor.blue=0x0000;
    gdk_color_alloc (gdk_colormap_get_system () , &gcolor);
    gdk_gc_set_foreground (gc , &gcolor);
    for(int i=0;i<track->getCornerCountMax();i++){
      if(status[i]==1){
	xx0=(int)(0.5*corners1[2*i]);
	yy0=(int)(0.5*corners1[2*i+1]);
	xx1=(int)(0.5*corners2[2*i]);
	yy1=(int)(0.5*corners2[2*i+1]);
	gdk_draw_line(pixmap,gc,xx0,yy0,xx1,yy1);
      }
    }
    break;
  case 2:
    // v debug
    // when sfm processed
    /*
    printf("hoge\n");
    gview->setParamType(3);
    sfmm->getTransformation(tmat);
    //SetIdentity(tmat);
    
    printf("     |%5.3lf %5.3lf %5.3lf %8.3lf|\n",tmat[0],tmat[1],tmat[2],tmat[3]);
    printf(" T = |%5.3lf %5.3lf %5.3lf %8.3lf|\n",tmat[4],tmat[5],tmat[6],tmat[7]);
    printf("     |%5.3lf %5.3lf %5.3lf %8.3lf|\n",tmat[8],tmat[9],tmat[10],tmat[11]);
    printf("     |%5.3lf %5.3lf %5.3lf %8.3lf|\n",tmat[12],tmat[13],tmat[14],tmat[15]);
    
    num3d=sfmm->getPointsNum();
    sfmm->get3DPoints(points3d);
    glfp->setPoints(num3d,points3d);

    gview->setMarkTransformation(tmat);
    */
    // ^ debug

    if(ostat==1){
      num3d=sfmm->getPointsNum();
      sfmm->get3DPoints(points3d);

      xmean=ymean=zmean=0;
      for(int i=0;i<num3d;i++){
	xmean+=points3d[i*3];
	ymean+=points3d[i*3+1];
	zmean+=points3d[i*3+2];
      }
      xmean/=num3d;
      ymean/=num3d;
      zmean/=num3d;

      psf->initParticles();
      psf->setPoints(points3d,num3d);
      psf->setZCenter(zmean);
      for(int j=0;j<5;j++){
	psf->resample();
	psf->predict();
	psf->weight();
	//psf->update(UPDATE_MAX);
	psf->update(UPDATE_MEAN);
      }
      psf->getState(psfstate);
      psf->stateToParam(psfstate,psfparam);
      printf("likelihood = %f\n",psf->likelihood(psfstate));

      glfp->setPoints(num3d,points3d);
      //globjobj->setTranslate(xmean,ymean,zmean);
      degrx=psfparam[1]/PI*180.0;
      degry=psfparam[2]/PI*180.0;
      //globjobj->setTranslate(0.0,0.0,psfparam[0]);
      globjobj->setTranslate(0.0,200.0,psfparam[0]);
      globjobj->setRotate(degrx-90.0,degry,0.0);
      grid->setTranslate(0.0,0.0,psfparam[0]);
      grid->setRotate(degrx,degry,0.0);

      sfmm->getTransformation(tmat);
      gview->setMarkTransformation(tmat);
    }

    sfmm->getFeatures0(corners1);
    sfmm->getFeatures2(corners2);
    sfmm->getTrackStatus(status);

    gc=gview->getGC();
    pixmap=gview->getPixmap();
  
    gdk_gc_set_line_attributes(gc,3,GDK_LINE_SOLID,GDK_CAP_NOT_LAST,GDK_JOIN_MITER);
    gdk_colormap_alloc_color (gdk_colormap_get_system () , &gcolor, TRUE, TRUE);
    gcolor.red=0x0000;
    gcolor.green=0xffff;
    gcolor.blue=0x0000;
    gdk_color_alloc (gdk_colormap_get_system () , &gcolor);
    gdk_gc_set_foreground (gc , &gcolor);
    for(int i=0;i<track->getCornerCountMax();i++){
      if(status[i]==1){
	xx0=(int)(0.5*corners1[2*i]);
	yy0=(int)(0.5*corners1[2*i+1]);
	xx1=(int)(0.5*corners2[2*i]);
	yy1=(int)(0.5*corners2[2*i+1]);
	gdk_draw_line(pixmap,gc,xx0,yy0,xx1,yy1);
      }
    }

    sfmm->getTRParams(param);
    gview->setMarkPose(param);
    gview->setParamType(0);

    break;
  default:
    fprintf(stderr,"Unknown Error.\n");
  }

  /*
  if(sfmm->getStat()==2){
    gview->redraw();
    return FALSE;
    //return TRUE;
  }else{
    gview->redraw();
    return TRUE;
  }
  */
  gview->redraw();
  return TRUE;
}

static gboolean mono_timer_event(gpointer p){
  int cnt;
  GdkGC *gc;
  GdkPixmap *pixmap;
  int xx,yy;
  GdkColor gcolor;
  int corner_count;

  dsc->getBuffer(&cnt,imgbuf);
  memcpy(gview->getGLImageBuffer(),imgbuf,640*480*3);
  monomark->convertToMono(imgbuf,60);
  monomark->findCorner();
  monomark->getMonoImage(gview->getImageBuffer());
  gview->setImageBuffer();

  corner_count=monomark->getCornerCount();
  monomark->getCorners(monocorners);
  // draw features
  gc=gview->getGC();
  pixmap=gview->getPixmap();

  gdk_gc_set_line_attributes(gc,3,GDK_LINE_SOLID,GDK_CAP_NOT_LAST,GDK_JOIN_MITER);
  gdk_colormap_alloc_color (gdk_colormap_get_system () , &gcolor, TRUE, TRUE);
  gcolor.red=0x0000;
  gcolor.green=0xffff;
  gcolor.blue=0x0000;
  gdk_color_alloc (gdk_colormap_get_system () , &gcolor);
  gdk_gc_set_foreground (gc , &gcolor);
  for(int i=0;i<(4<corner_count?4:corner_count);i++){
    xx=monocorners[i*2]/2;
    yy=monocorners[i*2+1]/2;
    gcolor.red=(i==0)?0xffff:0x0000;
    gcolor.green=(i==1)?0xffff:0x0000;
    gcolor.blue=(i==2)?0xffff:0x0000;
    gdk_colormap_alloc_color (gdk_colormap_get_system () , &gcolor, TRUE, TRUE);
    gdk_gc_set_foreground (gc , &gcolor);
    gdk_draw_rectangle(pixmap,gc,FALSE,xx-4,yy-4,8,8);
  }
  gview->resetMarkPose();
  if(corner_count==4){
    float param[6];
    float state[6];
    float markcornersmm[10];
    float markcorners3d[15];
    float xmin,xmax;
    float xmean,ymean;
    float t0,xc,yc,zc;
    float fxx,fyy;
    float a1,a2,b1,b2,c1,c2;
    float rvec[3];

    for(int i=0;i<4;i++){
      fxx=((float)monocorners[i*2]-320.0)*0.006;
      fyy=((float)monocorners[i*2+1]-240.0)*0.006;
      markcornersmm[i*2]=fxx;
      markcornersmm[i*2+1]=fyy;
    }

    a1=markcornersmm[5]-markcornersmm[1];
    a2=markcornersmm[7]-markcornersmm[3];
    b1=markcornersmm[0]-markcornersmm[4];
    b2=markcornersmm[2]-markcornersmm[6];
    c1=-(b1*markcornersmm[1]+a1*markcornersmm[0]);
    c2=-(b2*markcornersmm[3]+a2*markcornersmm[2]);
    xc=(b1*c2-b2*c1)/(a1*b2-a2*b1);
    yc=(a2*c1-a1*c2)/(a1*b2-a2*b1);
    markcornersmm[8]=xc;
    markcornersmm[9]=yc;

    markcorners3d[0]=-100.0;
    markcorners3d[1]=-100.0;
    markcorners3d[2]=0.0;
    markcorners3d[3]=100.0;
    markcorners3d[4]=-100.0;
    markcorners3d[5]=0.0;
    markcorners3d[6]=100.0;
    markcorners3d[7]=100.0;
    markcorners3d[8]=0.0;
    markcorners3d[9]=-100.0;
    markcorners3d[10]=100.0;
    markcorners3d[11]=0.0;
    markcorners3d[12]=0.0;
    markcorners3d[13]=0.0;
    markcorners3d[14]=0.0;

    FindExtrinsicCameraParams(markcorners3d,markcornersmm,5,2.8,param);

    gview->setMarkPose(param);

    printf("param=(%f %f %f) (%f %f %f)\n",
	   param[0],param[1],param[2],
	   param[3],param[4],param[5]);
  }else{
    printf("marker not found: %d corners found\n",corner_count);
  }

  gview->redraw();
  return TRUE;
}


static gboolean surf_timer_event(gpointer p){
  int cnt;
  GdkGC *gc;
  GdkPixmap *pixmap;
  int xx,yy;
  GdkColor gcolor;

  float *param;
  float *corners;

  dsc->getBuffer(&cnt,imgbuf);
  memcpy(gview->getGLImageBuffer(),imgbuf,640*480*3);
  memcpy(gview->getImageBuffer(),imgbuf,640*480*3);
  gview->setImageBuffer();

  gview->resetMarkPose();
  if(surfman->proc(imgbuf)==1){
    param=surfman->getMarkParam();
    gview->setMarkPose(param);

    printf("param=(%f %f %f) (%f %f %f)\n",
	   param[0],param[1],param[2],
	   param[3],param[4],param[5]);

    // draw features
    gc=gview->getGC();
    pixmap=gview->getPixmap();

    gdk_gc_set_line_attributes(gc,3,GDK_LINE_SOLID,GDK_CAP_NOT_LAST,GDK_JOIN_MITER);
    gdk_colormap_alloc_color (gdk_colormap_get_system () , &gcolor, TRUE, TRUE);
    gcolor.red=0x0000;
    gcolor.green=0xffff;
    gcolor.blue=0x0000;
    gdk_color_alloc (gdk_colormap_get_system () , &gcolor);
    gdk_gc_set_foreground (gc , &gcolor);
    corners=surfman->getCorners();
    int idx1;
    for(int i=0;i<4;i++){
      idx1=(i+1)%4;
      gdk_draw_line(pixmap,gc,
		    0.5*corners[i*2],0.5*corners[i*2+1],
		    0.5*corners[idx1*2],0.5*corners[idx1*2+1]);
    }

  }else{
    printf("marker not found\n");
  }

  gview->redraw();

  return TRUE;
}

static gboolean surf_list_timer_event(gpointer p){
  int cnt;
  GdkGC *gc;
  GdkPixmap *pixmap;
  int xx,yy;
  GdkColor gcolor;

  float *param;
  float *corners;

  int midx;

  dsc->getBuffer(&cnt,imgbuf);
  memcpy(gview->getGLImageBuffer(),imgbuf,640*480*3);
  memcpy(gview->getImageBuffer(),imgbuf,640*480*3);
  gview->setImageBuffer();

  gview->resetMarkPose();
  if((midx=surfman->procList(imgbuf))>=0){
    gtv->selectImage(midx);

    gview->setGLObject(globjlist[midx%globjlist.size()]);
    // RSJ2009
    //gview->setGLObject(coords);

    param=surfman->getMarkParam();
    gview->setMarkPose(param);

    printf("param=(%f %f %f) (%f %f %f)\n",
	   param[0],param[1],param[2],
	   param[3],param[4],param[5]);

    // draw features
    gc=gview->getGC();
    pixmap=gview->getPixmap();

    gdk_gc_set_line_attributes(gc,3,GDK_LINE_SOLID,GDK_CAP_NOT_LAST,GDK_JOIN_MITER);
    gdk_colormap_alloc_color (gdk_colormap_get_system () , &gcolor, TRUE, TRUE);
    gcolor.red=0x0000;
    gcolor.green=0xffff;
    gcolor.blue=0x0000;

    gdk_color_alloc (gdk_colormap_get_system () , &gcolor);
    gdk_gc_set_foreground (gc , &gcolor);
    corners=surfman->getCorners();
    int idx1;
    for(int i=0;i<4;i++){
      idx1=(i+1)%4;
      gdk_draw_line(pixmap,gc,
		    0.5*corners[i*2],0.5*corners[i*2+1],
		    0.5*corners[idx1*2],0.5*corners[idx1*2+1]);
    }

  }else{
    printf("marker not found\n");
    gtv->selectImage(-1);
  }

  gtv->redraw();
  gview->redraw();

  return TRUE;
}

//////////////////////////////////////////

static gboolean hough_timer_event(gpointer p){
  int cnt;
  dsc->getBuffer(&cnt,gview->getImageBuffer());
  mgh->setInImage(gview->getImageBuffer());
  mgh->proc();
  mgh->fitToRect();

  //mgh->procSymmetry();

  //mgh->getOutImage(gview->getImageBuffer());
  //memcpy(gview->getGLImageBuffer(),gview->getImageBuffer(),640*480*3);
  mgh->getCannyImage(gview->getImageBuffer());
  mgh->getOutImage(gview->getGLImageBuffer());
  gview->setImageBuffer();
  gview->redraw();
  return TRUE;
}

static gboolean graphcut_timer_event(gpointer p){
  int cnt;
  dsc->getBuffer(&cnt,gview->getImageBuffer());
  mggc->setInImage(gview->getImageBuffer());
  mggc->initLabel();
  mggc->proc();
  mggc->graphCut();
  isRunMGGC=mggc->fitToRect();
  mggc->getOutImage(gview->getGLImageBuffer());
  mggc->getOutImage(gview->getImageBuffer());
  gview->setImageBuffer();
  gview->redraw();
  return TRUE;
}

static gboolean graphcut_manual_timer_event(gpointer p){
  int cnt;
  float mx,my,dmx,dmy;
  int pts[4];
  dsc->getBuffer(&cnt,gview->getImageBuffer());
  mggc->setInImage(gview->getImageBuffer());
  // add command when clicked
  if(gview->isMouseDown()){
    mx=gview->getMouseX();
    my=gview->getMouseY();
    dmx=mx-oldmx;
    dmy=my-oldmy;
    if((dmx*dmx+dmy*dmy)>=16.0){
      pts[0]=(int)mx;
      pts[1]=(int)my;
      pts[2]=4;
      pts[3]=0;
      mggc->addCommand(((gview->getCountMouseDown()-omdcount)+1)%2,MG_CIRCLE,pts);
      oldmx=mx;
      oldmy=my;
    }
  }else{
    oldmx=oldmy=0.0;
  }
  //
  mggc->initLabel();
  mggc->proc();
  mggc->graphCut();
  isRunMGGC=mggc->fitToRect();
  mggc->getOutImage(gview->getGLImageBuffer());
  mggc->getOutImage(gview->getImageBuffer());
  gview->setImageBuffer();
  gview->redraw();
  return TRUE;
}

//////////////////////////////////////////

static void on_button_clicked(GtkButton *button,gpointer data){
  int cnt;
  char *combostring;

  //if(timeout_id==0){
  if(!isProcRunning){
    combostring=gview->getComboString();
    gtk_timeout_remove(timeout_id);
    if(timeout_id!=0) gtk_timeout_remove(timeout_id);
    isProcRunning=true;

    if(strcmp(combostring,"MonoMarker")==0){
      dsc->getBuffer(&cnt,gview->getImageBuffer());
      gtk_button_set_label(button,"stop");

      // monomark
      monomark->reset();
      gview->setParamType(1);

      //gview->setGLObject(reimu);
      //gview->addGLObject(marisa);

      gview->setGLObject(globj);
      //gview->addGLObject(grid);

      /*
      globjobj->setTranslate(0,0,0);
      globjobj->setRotate(0.0,0.0,0.0);
      grid->setTranslate(0.0,0.0,0.0);
      grid->setRotate(0.0,0.0,0.0);
      */
      /*
      gview->setGLObject(glp0);
      gview->addGLObject(glp2);
      gview->addGLObject(glp1);
      */

      timeout_id=gtk_timeout_add(33, (GtkFunction)mono_timer_event, NULL);
    }else if(strcmp(combostring,"Markerless")==0){
      dsc->getBuffer(&cnt,gview->getImageBuffer());
      gtk_button_set_label(button,"stop");

      // track
      sfmm->reset();
      gview->setParamType(3);

      gview->setGLObject(globj);
      //gview->addGLObject(glfp);
      //gview->addGLObject(grid);
      globj->getTranslate(old_trans);
      globj->getRotate(old_rot);
      globj->setTranslate(0,0,1000);
      globj->setRotate(-90.0,0.0,0.0);

      //gview->setGLObject(glfp);
      badj->initParticles();

      isRunSFM=true;

      timeout_id=gtk_timeout_add(33, (GtkFunction)sfm_timer_event, NULL);
    }else if(strcmp(combostring,"GeneratedMarker")==0){
      dsc->getBuffer(&cnt,gview->getImageBuffer());
      gtk_button_set_label(button,"stop");

      // surf
      surfman->reset();
      surfman->useLSH(false);
      surf->convertRef();
      surf->convertPCARef();
      gview->setParamType(1);

      gview->setGLObject(globj);
      
      timeout_id=gtk_timeout_add(33, (GtkFunction)surf_timer_event, NULL);

    }else if(strcmp(combostring,"GeneratedMarkerLSH")==0){
      dsc->getBuffer(&cnt,gview->getImageBuffer());
      gtk_button_set_label(button,"stop");

      // surf
      surfman->reset();
      surfman->useLSH(true);
      surf->convertRef();
      surf->convertPCARef();
      gview->setParamType(1);

      gview->setGLObject(globj);
      
      timeout_id=gtk_timeout_add(33, (GtkFunction)surf_timer_event, NULL);
    }else if(strcmp(combostring,"GeneratedMarkerList")==0){
      gtv->selectImage(-1);
      dsc->getBuffer(&cnt,gview->getImageBuffer());
      gtk_button_set_label(button,"stop");

      // surf
      surfman->reset();
      surfman->useLSH(true);
      surf->convertRefList();
      gview->setParamType(1);
      gview->setGLObject(globj);
      
      // RSJ2009
      //gview->setGLObject(coords);
      
      timeout_id=gtk_timeout_add(33, (GtkFunction)surf_list_timer_event, NULL);
    }else if(strcmp(combostring,"MarkerGeneration")==0){
      gview->resetMarkPose();

      //isRunMGGC=true;
      dsc->getBuffer(&cnt,gview->getImageBuffer());
      gtk_button_set_label(button,"stop");

      // MarkerGenerationGraphCut
      mggc->setDefaultCommands();
      mggc->initLabel();
      timeout_id=gtk_timeout_add(33, (GtkFunction)graphcut_timer_event, NULL);

    }else if(strcmp(combostring,"MarkerGenerationManual")==0){
      gview->resetMarkPose();

      //isRunMGGC=true;
      dsc->getBuffer(&cnt,gview->getImageBuffer());
      gtk_button_set_label(button,"stop");
      
      omdcount=gview->getCountMouseDown();

      // MarkerGenerationGraphCut
      mggc->setMinimumCommands();
      mggc->initLabel();
      timeout_id=gtk_timeout_add(33, (GtkFunction)graphcut_manual_timer_event, NULL);

    }else if(strcmp(combostring,"PerfCheck")==0){
      // performance checker

      cout << "performance check. please wait..." << endl;
      IplImage *perf_img=cvLoadImage("scene.png",CV_LOAD_IMAGE_COLOR);
      for(int i=0;i<640*480*3;i+=3)
	for(int j=0;j<3;j++)
	  imgbuf[i+j]=((unsigned char *)perf_img->imageData)[i+3-j];
      
      
      for(int i=3;i<24;i++){
	for(int j=3;j<16;j++){
	  {
	    ofstream ofs("perfcheck.txt",ios::app);
	    ofs << "# image num= " << i << " , usedim= " << j <<endl;
	  }

	  surfman->reset();
	  surf->convertRefListEX(string("perfcheck.txt"),i,j);
	  surfman->procListEX(string("perfcheck.txt"),i,imgbuf);
	}
      }
      isProcRunning=false;
      timeout_id=gtk_timeout_add(33, (GtkFunction)view_timer_event, NULL);
      cout << "complete." << endl;

    }else{
      fprintf(stderr,"UNKNOWN LABEL in on_button_clicked\n");
      isProcRunning=false;
      timeout_id=gtk_timeout_add(33, (GtkFunction)view_timer_event, NULL);
    }
  }else{
    gtk_timeout_remove(timeout_id);
    //timeout_id=0;

    if(isRunMGGC){
      // post-process of MarkerGenerationGraphCut
      if(genmarker!=NULL) cvReleaseImage(&genmarker);
      genmarker=mggc->generateMarkerImage();
      //cvShowImage("Marker",genmarker);
      gmv->setImage(genmarker);
      isRunMGGC=false;
    }else if(isRunSFM){
      globj->setTranslate(old_trans[0],old_trans[1],old_trans[2]);
      globj->setRotate(old_rot[0],old_rot[1],old_rot[2]);
      isRunSFM=false;
    }

    gview->resetMarkPose();
    timeout_id=gtk_timeout_add(33, (GtkFunction)view_timer_event, NULL);
    //timeout_id=0;
    gtk_button_set_label(button,"start");
    isProcRunning=false;

  }
}

//////////////////////////////////////////

/*
static bool setTexturePolygon(GLPolygon *glp,string fname){
  HYImage *dtex,*dtex2;
  dtex=createImageFromFile(fname);
  if(dtex==NULL) return false;
  dtex2=convertImageAlphaByColor(dtex,2.5,0.0,0.0);
  glp->setTexture(dtex2->getWidth(),dtex2->getHeight(),dtex2->getDepth(),dtex2->getBuffer());
  delete dtex2;
  delete dtex;
  return true;
}
*/

int main (int argc, char *argv[]){
  corners1=new float[200*2];
  corners2=new float[200*2];
  status=new char[200];

  imgbuf=new unsigned char[640*480*3];

  monocorners=new int[64];

  gtk_set_locale();
  gtk_init(&argc,&argv);
  gdk_rgb_init();
  gtk_gl_init(&argc,&argv);

  dsc=new DSCapture();

  int devid=0;
  int devnum=dsc->getDeviceNum();
      char devname[1024];
  if(devnum>1){
    gcamsel=new GtkCameraSelect();
    for(int i=0;i<devnum;i++){
      dsc->getDeviceName(i,devname);
      gcamsel->addComboString(devname);
    }
    gcamsel->show();
    gtk_main();
    devid=gcamsel->getDeviceID();
    delete gcamsel;
  }
  dsc->open(devid);

  dsc->start();

  gview=new GtkView();

  monomark=new MonoMarkerFinder();

  track=new FeatureTracker(200);
  sfmm=new SFMManager(track);

  psf=new HYPsf(300,0.01,
		1000.0,1000.0,
		0.0,PI,
		0.0,PI,
		-0.01);

  badj=new BundleAdjustFilter(300,0.01,-0.01,
			      0.0,1000.0,
			      0.0,1000.0,
			      0.0,1000.0,
			      0.0,PI/2.0,
			      0.0,PI/2.0,
			      0.0,PI/2.0);
  sfmm->setBundleAdjustFilter(badj);


  surf=new SURFConverter();
  //HYImage *hyimg=createImageFromFile("decade00.png");
  //HYImage *hyimg=createImageFromFile("Yukkuri.png");
  //HYImage *hyimg=readMarkerIniFile("marmark.ini");
  IplImage *hyimg=readMarkerIniFile2("marmark.ini");
  if(hyimg==NULL){
    //hyimg=createImageFromFile("Yukkuri.png");
    hyimg=cvLoadImage("miku00.jpg",CV_LOAD_IMAGE_COLOR);
    if(hyimg==NULL){
      getchar();
      return 0;
    }
  }
  //surf->setRefImage(hyimg->getWidth(),hyimg->getHeight(),hyimg->getBuffer());
  //surf->convertRef();
  //surf->convertPCARef();
  surfman=new SURFManager(surf,track);
  surfman->usePCA(true);
  //surfman->usePCA(false);
  surfman->useLSH(true);
  //surfman->useLSH(false);
  surfman->setRefImage(hyimg);

  // marker list
  gtv=new GtkThumbView();
  if(!readMarkerIniFile3("marmark.ini")){
    hyimg=cvLoadImage("miku00.jpg",CV_LOAD_IMAGE_COLOR);
    if(hyimg==NULL){
      getchar();
      return 0;
    }
    surf->pushRefImageList(hyimg);
    gtv->pushImageList(hyimg);
  }
  surf->convertRefList();

  mgh=new MarkerGenerationHough();
  mggc=new MarkerGenerationGraphCut();

  gview->addComboString("MonoMarker");
  gview->addComboString("Markerless");
  //gview->addComboString("GenerateHough");
  //gview->addComboString("GenerateGraphCut");
  gview->addComboString("MarkerGeneration");
  gview->addComboString("MarkerGenerationManual");
  gview->addComboString("GeneratedMarker");
  //gview->addComboString("GeneratedMarkerLSH");
  gview->addComboString("GeneratedMarkerList");

  // performance check
  //gview->addComboString("PerfCheck");

  gview->setButtonCallback(on_button_clicked);

  gview->show();

  //gctrl=new GtkCtrl();
  //gctrl->show();


  //globj=new GLDummyObject();

  /*
  globjobj=new GLObjObject();

  bool ret=readObjIniFile("marobj.ini",globjobj);
  if(!ret){
    ret=
      readObjFile("miku_blend_Scene.obj","miku_blend_Scene.mtl",globjobj,100.0);
      //readObjFile("takoruka_Scene.obj","takoruka_Scene.mtl",globjobj,50.0);
  
    if(!ret){
      getchar();
      return 0;
    }
    globjobj->setRotate(-90.0,0.0,0.0);
    //globjobj->setRotate(0.0,0.0,0.0);
  }
  globjobj->setNormalType(1);
  globjobj->setGLList();
  globj=globjobj;
  gview->setGLObject(globj);
  */

  /*
  glpmd=new GLPMDObject();
  bool ret=
    readPMDFile("miku781052.pmd",glpmd,10.0);
  
  if(!ret){
    getchar();
    return 0;
  }
  glpmd->setRotate(-90.0,0.0,180.0);
  glpmd->setGLList();
  globj=glpmd;
  gview->setGLObject(globj);
  */

  bool ret=readObjIniFile2("marobj.ini");
  if(globjlist.size()==0){
    ret=
      readPMDFile("miku781052.pmd",glpmd,10.0);
    if(!ret){
      getchar();
      return 0;
    }
    glpmd->setRotate(-90.0,0.0,0.0);
    globjlist.push_back(glpmd);
  }

  globj=globjlist[0];

  glfp=new GLFeaturePoints();
  grid=new GLGrid();
  coords=new GLCoordinate();

  // dededecade
  /*
  glp0=new GLPolygon();
  glp1=new GLPolygon();
  glp2=new GLPolygon();
  setRectanglePolygon(glp0,640.0*2.0,120.0*2.0);
  setRectanglePolygon(glp1,690.0*2.0,690.0*2.0);
  setRectanglePolygon(glp2,420.0*2.0,420.0*2.0);
  glp0->setTranslate(0.0,0.0,-100.0);
  glp1->setTranslate(0.0,0.0,-80.0);
  glp2->setTranslate(0.0,0.0,-50.0);
  glp1->setOmega(5.0);
  glp2->setOmega(-3.0);
  if(!setTexturePolygon(glp0,"kamenride0_2n.png")){
    getchar();
    return 0;
  }
  if(!setTexturePolygon(glp1,"kamenride1_2n.png")){
    getchar();
    return 0;
  }
  if(!setTexturePolygon(glp2,"kamenride2_2n.png")){
    getchar();
    return 0;
  }
  glp0->setGLList();
  glp1->setGLList();
  glp2->setGLList();
  */


  dummy=new GLObjObject();

  gmv=new GtkMarkerView();
  gmv->setSURFManager(surfman);
  gmv->show();

  gtv->show();
  gtv->createThumb();

  timeout_id=gtk_timeout_add(33, (GtkFunction)view_timer_event, NULL);

  gtk_main();

  if(timeout_id!=0){
    gtk_timeout_remove(timeout_id);
    timeout_id=0;
  }

  dsc->stop();

  delete gmv;
  delete gtv;

  if(genmarker!=NULL) cvReleaseImage(&genmarker);

  delete dsc;
  delete track;
  delete sfmm;
  delete monomark;
  delete globjobj;
  delete glfp;
  delete coords;
  //delete globj;
  delete psf;
  delete badj;

  delete surf;
  delete surfman;
  delete mgh;
  delete mggc;

  //delete hyimg;
  cvReleaseImage(&hyimg);
  /*
  delete glp0;
  delete glp1;
  delete glp2;
  */

  delete dummy;
  /*
  delete reimu;
  delete marisa;
  */

  delete[] corners1;
  delete[] corners2;
  delete[] status;
  delete[] imgbuf;
  delete[] monocorners;

  delete gview;
  //delete gctrl;

  return 0;
}
