#ifndef __IMAGEMANAGER_H__
#define __IMAGEMANAGER_H__

#include <stdio.h>
#include <string.h>

#include <iostream>
#include <string>

#include <cv.h>
#include <cvaux.h>
#include <cxcore.h>
#include <highgui.h>

#include <windows.h>

using namespace std;


class HYImage{
 private:
  int width,height;
  unsigned char *buf;
  unsigned char depth;

 public:
  HYImage();
  HYImage(int ww,int hh);
  HYImage(int ww,int hh,unsigned char dd);
  ~HYImage();

  void createBuffer(int ww,int hh,unsigned char dd);
  
  unsigned char *getBuffer(){return buf;}
  void setBuffer(unsigned char *src){memcpy(buf,src,width*height*depth);}
  void copyBuffer(unsigned char *dst){memcpy(dst,buf,width*height*depth);}
  void setBufferBGR(unsigned char *src);
  void copyBufferBGR(unsigned char *dst);
  int getWidth(){return width;}
  int getHeight(){return height;}
  unsigned char getDepth(){return depth;}
};


HYImage *createImageFromFile(string fname);
HYImage *createImageFromIplImage(IplImage *iplimg);
IplImage *createIplImageFromImage(HYImage *hyimg);

HYImage *createImageFromFileWithAlpha(string fname);
HYImage *convertImageAlphaByColor(HYImage *src,float rr,float gg,float bb);

#endif
