#include "IKFilter.h"

using namespace std;

IKFilter::IKFilter(GLPMDObject *pmd,int nchildren,int np,int rr,
		   int bone,int target,float weight,vector<int> &children,
		   ostream &os)
  : HYParticleFilter(nchildren*3,np,rr){
  glpmd=pmd;
  ik_bone=bone;
  ik_target_bone=target;
  ik_weight=weight;
  ref_quats.resize(nchildren*4);
  cur_quats.resize(nchildren*4);
  ik_children.assign(children.begin(),children.end());

  os << " nchildren = " << nchildren << endl;
  nc=nchildren;

  initQuaternion();
  initStep();

  cur_angles=new float[nchildren*3];
  jacobian=new float[nchildren*3*6];
  inverse_jacobian=new float[nchildren*3*6];

  diff_vector=new float[6];
  step_vector=new float[6];

  dangles=new float[nchildren*3];

  cv_jacobian=cvCreateMatHeader(6,nchildren*3,CV_32F);
  cvSetData(cv_jacobian,(void *)jacobian,sizeof(float)*nchildren*3);
  cv_inverse_jacobian=cvCreateMatHeader(nchildren*3,6,CV_32F);
  cvSetData(cv_inverse_jacobian,(void *)inverse_jacobian,sizeof(float)*6);
  cv_step_vector=cvCreateMatHeader(6,1,CV_32F);
  cvSetData(cv_step_vector,(void *)step_vector,sizeof(float));
  cv_dangles=cvCreateMatHeader(nchildren*3,1,CV_32F);
  cvSetData(cv_dangles,(void *)dangles,sizeof(float));
  
  mnoise=-0.05;
}

IKFilter::~IKFilter(){
  cvReleaseMatHeader(&cv_jacobian);
  cvReleaseMatHeader(&cv_inverse_jacobian);
  cvReleaseMatHeader(&cv_dangles);
  delete[] cur_angles;
  delete[] diff_vector;
  delete[] step_vector;
  delete[] jacobian;
  delete[] inverse_jacobian;
  delete[] dangles;
}

void IKFilter::initQuaternion(){
  for(int i=0;i<nc;i++){
    memcpy(&ref_quats[i*4],
	   glpmd->getBone(ik_children[i])->getCurrentQuaternion(),
	   sizeof(float)*4);
  }
}

void IKFilter::initStep(){
  float *ik_wt,*target_wt;
  float ik_quat[4],target_quat[4];
  float ik_aa[3],target_aa[3];
  float dd,dsumt=0.0,dsumr=0.0,val;

  ik_wt=glpmd->getBone(ik_bone)->getWorldTransformation();
  target_wt=glpmd->getBone(ik_target_bone)->getWorldTransformation();

  ExtractQuaternion(ik_wt,ik_quat);
  ExtractQuaternion(target_wt,target_quat);
  QuaternionToAxisAngle(ik_quat,ik_aa);
  QuaternionToAxisAngle(target_quat,target_aa);
  
  for(int i=0;i<3;i++){
    dd=ik_aa[i]-target_aa[i];
    dsumr+=(500.0*dd*dd);
  }

  for(int i=0;i<3;i++){
    dd=ik_wt[i*4+3]-target_wt[i*4+3];
    dsumt+=(dd*dd);
  }

  stepr=1.0/(1.0+sqrt(dsumr));
  stept=1.0/(1.0+sqrt(dsumt));

}

float IKFilter::likelihood(float *state){
  stateToPose(state);
  float ik_quat[4],target_quat[4];
  float ik_aa[3],target_aa[3];
  float *ik_wt,*target_wt;
  ik_wt=glpmd->getBone(ik_bone)->getWorldTransformation();
  target_wt=glpmd->getBone(ik_target_bone)->getWorldTransformation();

  float dd,dsumt=0.0,dsumr=0.0,val;
  /*
  for(int i=0;i<3;i++){
    for(int j=0;j<3;j++){
      dd=ik_wt[i*4+j]-target_wt[i*4+j];
      dsumr+=(200.0*dd*dd);
    }
    dd=ik_wt[i*4+3]-target_wt[i*4+3];
    dsumt+=(dd*dd);
  }
  */

  ExtractQuaternion(ik_wt,ik_quat);
  ExtractQuaternion(target_wt,target_quat);
  QuaternionToAxisAngle(ik_quat,ik_aa);
  QuaternionToAxisAngle(target_quat,target_aa);

  // using quaternion
  /*
  for(int i=0;i<4;i++){
    dd=ik_quat[i]-target_quat[i];
    dsumr+=(20.0*dd*dd);
  }
  */

  // using axis-angle
  for(int i=0;i<3;i++){
    dd=ik_aa[i]-target_aa[i];
    dsumr+=(stepr*dd*dd);
  }


  // using rotational matrix
  /*
  int xidx;
  for(int i=0;i<3;i++){
    xidx=i*4;
    for(int j=0;j<3;j++){
      dd=ik_wt[xidx+j]-target_wt[xidx+j];
      dsumr+=(100.0*dd*dd);
    }
  }
  */

  for(int i=0;i<3;i++){
    dd=ik_wt[i*4+3]-target_wt[i*4+3];
    dsumt+=(stept*dd*dd);
  }

  val=exp(mnoise*(dsumt+dsumr));
  //val=1.0/(1.0+(dsumt+dsumr));
  return val;
}
void IKFilter::stateToPose(float *state){
  float aa[3],quat[4];
  float ww=0.8;
  for(int i=0;i<ik_children.size();i++){
    aa[0]=ww*state[i*3];
    aa[1]=ww*state[i*3+1];
    aa[2]=ww*state[i*3+2];
    //EulerToQuaternion(ww*state[i*3],ww*state[i*3+1],ww*state[i*3+2],quat);
    AxisAngleToQuaternion(aa,quat);
    //RotateQuaternion(&ref_quats[i*4],quat,&cur_quats[i*4]);
    QuaternionCross(&ref_quats[i*4],quat,&cur_quats[i*4]);
    glpmd->getBone(ik_children[i])->setCurrentQuaternion(&cur_quats[i*4]);
    //ww*=0.8;
  }
  for(int i=0;i<ik_children.size();i++)
    glpmd->getBone(ik_children[i])->calcWorldTransformation();
  glpmd->getBone(ik_target_bone)->calcWorldTransformation();
}

void IKFilter::calcWorldTransformation(float *angles,float *result){
  float quat[4],ik_quat[4],ik_aa[3];
  float *ik_wt;

  for(int i=0;i<ik_children.size();i++){
    //EulerToQuaternion(angles[i*3],angles[i*3+1],angles[i*3+2],quat);
    AxisAngleToQuaternion(&angles[i*3],quat);
    //RotateQuaternion(&ref_quats[i*4],quat,&cur_quats[i*4]);
    QuaternionCross(&ref_quats[i*4],quat,&cur_quats[i*4]);
    glpmd->getBone(ik_children[i])->setCurrentQuaternion(&cur_quats[i*4]);
  }
  for(int i=0;i<ik_children.size();i++)
    glpmd->getBone(ik_children[i])->calcWorldTransformation();
  glpmd->getBone(ik_target_bone)->calcWorldTransformation();

  ik_wt=glpmd->getBone(ik_target_bone)->getWorldTransformation();
  ExtractQuaternion(ik_wt,ik_quat);
  QuaternionToAxisAngle(ik_quat,ik_aa);

  for(int i=0;i<3;i++)
    result[i+3]=ik_aa[i];
  for(int i=0;i<3;i++)
    result[i]=ik_wt[i*4+3];
}

void IKFilter::calcJacobian(){
  vector<float> tmp_angles;
  tmp_angles.resize(nc*3);
  float result0[6];
  float result1[6],result2[6];

  calcWorldTransformation(cur_angles,result0);

  for(int j=0;j<nc*3;j++){
    memcpy(&tmp_angles[0],cur_angles,sizeof(float)*nc*3);
    tmp_angles[j]+=0.0001;
    calcWorldTransformation(&tmp_angles[0],result1);

    memcpy(&tmp_angles[0],cur_angles,sizeof(float)*nc*3);
    tmp_angles[j]-=0.0001;
    calcWorldTransformation(&tmp_angles[0],result2);

    for(int i=0;i<6;i++){
      jacobian[i*nc*3+j]=(result1[i]-result2[i])/0.0002;
    }
  }

  /*
  cout << "  jacobian:" << endl;
  for(int i=0;i<7;i++){
    cout << "   ";
    for(int j=0;j<nc*3;j++){
      cout << jacobian[i*nc*3+j] << " ";
    }
    cout << endl;
  }
  */

}
void IKFilter::stepIter(){
  calcJacobian();
  cvInvert(cv_jacobian,cv_inverse_jacobian,CV_SVD);
  cvMatMul(cv_inverse_jacobian,cv_step_vector,cv_dangles);

  for(int i=0;i<nc*3;i++){
    cur_angles[i]+=dangles[i];
  }

}
void IKFilter::iterativeIK(){
  float ik_param[6],target_param[6];
  float ik_quat[4],target_quat[4];
  float ik_aa[3],target_aa[3];
  float *ik_wt,*target_wt;
  float step_norm;

  glpmd->getBone(ik_bone)->calcWorldTransformation();

  for(int i=0;i<nc*3;i++)
    cur_angles[i]=0.0;
  calcWorldTransformation(cur_angles,target_param);
  
  ik_wt=glpmd->getBone(ik_bone)->getWorldTransformation();
  ExtractQuaternion(ik_wt,ik_quat);
  QuaternionToAxisAngle(ik_quat,ik_aa);

  for(int i=0;i<3;i++)
    ik_param[i+3]=ik_aa[i];
  for(int i=0;i<3;i++)
    ik_param[i]=ik_wt[i*4+3];

  step_norm=0.0;
  for(int i=0;i<6;i++){
    step_vector[i]=(ik_param[i]-target_param[i]);
    step_norm+=(step_vector[i]*step_vector[i]);
  }
  for(int i=0;i<6;i++)
    step_vector[i]*=(0.05/(sqrt(step_norm)));
  cout << "init: " << sqrt(step_norm) << endl;

  cout << "ik_param  : ";
  for(int i=0;i<6;i++)
    cout << ik_param[i] << " ";
  cout << endl;
  cout << "targ_param: ";
  for(int i=0;i<6;i++)
    cout << target_param[i] << " ";
  cout << endl;


  float dd,ddd;
  for(int i=0;i<1;i++){
    step_norm=0.0;
    for(int j=0;j<6;i++){
      step_vector[j]=(ik_param[j]-target_param[j]);
      step_norm+=(step_vector[j]*step_vector[j]);
    }
    for(int j=0;j<6;i++)
      step_vector[i]*=(0.05/(sqrt(step_norm)));

    stepIter();
    calcWorldTransformation(cur_angles,target_param);
    ddd=0.0;
    for(int j=0;j<6;j++){
      dd=(target_param[j]-ik_param[j]);
      ddd+=(dd*dd);
    }
    cout << "  " << i << ": " << sqrt(ddd) << endl;
    /*
    cout << "  cur_angles: ";
    for(int j=0;j<nc*3;j++){
      cout << cur_angles[j] << " ";
    }
    cout << endl;
    cout << "  dangles: ";
    for(int j=0;j<nc*3;j++){
      cout << dangles[j] << " ";
    }
    cout << endl;
    */
    if(ddd<10.0) break;
  }

  calcWorldTransformation(cur_angles,target_param);

}

///////

IKManager::IKManager(GLPMDObject *pmd,ostream &os){
  init(pmd,400,300,os);
}
IKManager::IKManager(GLPMDObject *pmd,int ik_np,int ik_iter,ostream &os){
  init(pmd,ik_np,ik_iter,os);
}
IKManager::~IKManager(){
  for(int i=0;i<nik;i++)
    delete ikfilters[i];
}

void IKManager::init(GLPMDObject *pmd,int ik_np,int ik_iter,ostream &os){
  glpmd=pmd;
  np=ik_np;
  iter=ik_iter;
  nik=glpmd->getIKBones().size();
  ikfilters=new IKFilter*[nik];
  //ikvalid.resize(nik);
  os << "create IKManager..." << endl;
  for(int i=0;i<nik;i++){
    cout << i << endl;
    ikfilters[i]=new IKFilter(glpmd,
			      glpmd->getIKChildrens()[i].size(),
			      np,0.05,
			      glpmd->getIKBones()[i],
			      glpmd->getIKTargetBones()[i],
			      glpmd->getIKWeights()[i],
			      glpmd->getIKChildrens()[i]);
    //ikvalid[i]=0;
  }
  ikbones.assign(glpmd->getIKBones().begin(),glpmd->getIKBones().end());
}

void IKManager::reset(){
  for(int i=0;i<nik;i++){
    ikfilters[i]->initQuaternion();
    ikfilters[i]->initStep();
    ikfilters[i]->initParticles();
  }
}

void IKManager::calcIK(GLPMDObject *pmd){
  float state[128];
  for(int i=0;i<nik;i++){
    //if(ikvalid[i]==1){
    //if(pmd->getUpdated()[ikbones[i]]==1){
      cout << "calc IK: " << i <<endl;
      ikfilters[i]->initParticles();
      for(int j=0;j<iter;j++){
	ikfilters[i]->setResampleRange(0.05*(float)(iter+iter-j)/(float)(iter+iter));
	//cout << "  resample" <<endl;
	ikfilters[i]->resample();
	//cout << "  predict" <<endl;
	ikfilters[i]->predict();
	//cout << "  weight" <<endl;
	ikfilters[i]->weight();
	//cout << "  update" <<endl;
	ikfilters[i]->update(UPDATE_MEAN);
	//ikfilters[i]->update(UPDATE_MAX);
      }
      cout << "done." <<endl;
      ikfilters[i]->getState(state);
      ikfilters[i]->stateToPose(state);
      cout << "likelihood = " << ikfilters[i]->likelihood(state) <<endl;
      //}
  }
  cout << "update vertices" <<endl;
  glpmd->calcCurrentVertices();
}

void IKManager::calcIterativeIK(GLPMDObject *pmd){
  //for(int i=0;i<nik;i++){
  for(int i=1;i<3;i++){
    cout << "calc IterativeIK: " << i <<endl;
    ikfilters[i]->iterativeIK();
    cout << "done." <<endl;
  }
  cout << "update vertices" <<endl;
  glpmd->calcCurrentVertices();
}
