#ifndef __HOMOGENEOUSTRANSFORMATION_H__
#define __HOMOGENEOUSTRANSFORMATION_H__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <cv.h>
#include <cvaux.h>
#include <cxcore.h>

#include <math.h>

#include <iostream>
#include <vector>
#include <string>

using namespace std;


#define PI (atan(1.0)*4.0)

void CalcTransformationByTR(float *tvec,float *rmat,float *result);
void CalcInverseTransformationByTR(float *tvec,float *rmat,float *result);
void CalcInverseTransformationByTransformation(float *tmat,float *result);

void TransformMatrix(float *tmat0,float *tmat1,float *result);
void SetIdentity(float *mat);
void SetEulerRotation(float* mat,float rx,float ry,float rz);
void SetRPYRotation(float* mat,float rx,float ry,float rz);
void SetTranslation(float *mat,float x,float y,float z);
void SetRotationVector(float *mat,float *rvec);

void SetQuaternionRotation(float *mat,float *quat);
void EulerToQuaternion(float rx,float ry,float rz,float *quat);
void RPYToQuaternion(float rx,float ry,float rz,float *quat);
void QuaternionCross(float *quat1,float *quat2,float *result);
void RotateQuaternion(float *quat1,float *quat2,float *result);
void ExtractQuaternion(float *tmat,float *quat);
void SlerpQuaternion(float *quat1,float *quat2,float tt,float *result);

void QuaternionToAxisAngle(float *quat,float *aa);
void AxisAngleToQuaternion(float *aa,float *quat);

void TransformVector(float *vec,float *tmat,float *result);
void RotateVector(float *vec,float *tmat,float *result);

#endif
