#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "HYParticleFilter.h"

HYParticleFilter::HYParticleFilter(int ds,int np,float rr){
  dstate=ds;
  nparticles=np;
  resampleRange=rr;
  hresampleRange=resampleRange*0.5;

  state=new float[dstate];
  stateTable=new float[dstate*nparticles];
  ostateTable=new float[dstate*nparticles];
  weightTable=new float[nparticles];

  srand((unsigned int)time(0));

  initParticles();
}

HYParticleFilter::~HYParticleFilter(){
  delete[] state;
  delete[] stateTable;
  delete[] ostateTable;
  delete[] weightTable;
}

void HYParticleFilter::initParticles(){
  int i,j,pidx;
  float nweight=1.0/nparticles;
  float frand;
  
  for(i=0;i<nparticles;i++){
    pidx=i*dstate;
    for(j=0;j<dstate;j++){
      frand=(rand()/((float)RAND_MAX+1.0f))-0.5;
      stateTable[pidx+j]=frand;
    }
    weightTable[i]=nweight;
  }
}

void HYParticleFilter::resample(){
  int i,j,k,pidx,pcnt,pnum;
  float frand;
  float *stti;

  memcpy(ostateTable,stateTable,sizeof(float)*nparticles*dstate);
  stti=ostateTable;
  pcnt=0;
  for(i=0;i<nparticles;i++){
    memcpy(state,stti,sizeof(float)*dstate);
    pnum=(int)(nparticles*weightTable[i]);
    for(j=pcnt;j<(pcnt+pnum);j++){
      pidx=j*dstate;
      for(k=0;k<dstate;k++){
	frand=((rand()/(((float)RAND_MAX+1.0f)))*resampleRange)-hresampleRange;
	stateTable[pidx+k]=state[k]+frand;
      }
    }
    pcnt+=pnum;
    stti+=dstate;
  }
  for(i=pcnt;i<nparticles;i++){
    for(k=0;k<dstate;k++){
      //frand=((rand()/(((float)RAND_MAX+1.0f)))*resampleRange)-hresampleRange;
      frand=(rand()/((float)RAND_MAX+1.0f))-0.5;
      //stateTable[i+k]=state[k]+frand;
      stateTable[i+k]=frand;
    }
  }
  
}

void HYParticleFilter::weight(){
  int i;
  float *stti;

  stti=stateTable;

  for(i=0;i<nparticles;i++){
    memcpy(state,stti,sizeof(float)*dstate);
    weightTable[i]=likelihood(state);
    stti+=dstate;
  }
  normalizeWeight();
}

void HYParticleFilter::update(int method){
  switch(method){
  case UPDATE_MEAN:
  default:
    update_mean();
    break;
  case UPDATE_MAX:
    update_max();
    break;
  }
}

void HYParticleFilter::update_mean(){
  int i,j,pidx;

  for(i=0;i<dstate;i++){
    state[i]=0.0;
  }

  for(i=0;i<nparticles;i++){
    pidx=i*dstate;
    for(j=0;j<dstate;j++){
      state[j]+=(stateTable[pidx+j]*weightTable[i]);
    }
  }
}


void HYParticleFilter::update_max(){
  int i,j,pidx,maxwidx;
  float maxw=0.0;

  for(i=0;i<nparticles;i++){
    if(maxw<weightTable[i]){
      maxw=weightTable[i];
      maxwidx=i;
    }
  }

  pidx=maxwidx*dstate;
  for(j=0;j<dstate;j++){
    state[j]=stateTable[pidx+j];
  }
}


void HYParticleFilter::normalizeWeight(){
  float weightSum;
  int i;

  weightSum=0.0;
  for(i=0;i<nparticles;i++){
    weightSum+=weightTable[i];
  }
  if(weightSum<=1e-5){
    initParticles();
  }else{
    for(i=0;i<nparticles;i++){
      weightTable[i]=weightTable[i]/weightSum;
    }
  }
}



