#ifndef __GTKVIEW_H__
#define __GTKVIEW_H__

#ifdef _MSC_VER
#include <windows.h>
#include <tchar.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include <gtk/gtkgl.h>

#include <GL/gl.h>
#include <GL/glu.h>

#include <stdlib.h>
#include <string.h>

#include <math.h>

#include "GLObject.h"

#include <iostream>
#include <string>

using namespace std;


// callbacks
static gboolean on_window_delete_event (GtkWidget       *widget,
				 GdkEvent        *event,
				 gpointer         user_data);
static void on_realize (GtkWidget *widget, gpointer   data);
static gboolean on_configure_event (GtkWidget         *widget,
				 GdkEventConfigure *event,
				 gpointer           data);
static gboolean on_expose_event_gl (GtkWidget      *widget,
				    GdkEventExpose *event,
				    gpointer        data);
static gboolean on_expose_event (GtkWidget      *widget,
				 GdkEventExpose *event,
				 gpointer        data);

static gboolean button_press_event (GtkWidget      *widget,
				    GdkEventButton *event,
				    gpointer       data);
static gboolean button_release_event (GtkWidget      *widget,
				      GdkEventButton *event,
				      gpointer       data);
static gboolean motion_notify_event (GtkWidget      *widget,
				     GdkEventMotion *event,
				     gpointer        data);



class GtkView{
 private:
  GtkWidget *window;
  GtkWidget *drawingarea;
  GtkWidget *gldrawingarea;
  GdkGLConfig *glconfig;
  GdkGC *gc;

  GtkWidget *vbox1,*hbox1,*vbox2;
  GtkWidget *combo0;
  GtkWidget *button0;

  GtkWidget *check0;

  GError *gerr;

  GLObject *globj;
  GLObject **globjs;
  int globjnum;

  unsigned char *image,*qimage,*glimage;
  GdkPixmap *pixmap;
  
  float *param;
  unsigned char paramtype;
  bool isfoundmark;
  int resetcount,setcount;

  // moving average
  float *paramhistory;

  float *rmat,*tmat;

  float *lightPos;

  bool ispick;
  bool ismdown;
  unsigned char mdcount;
  float mouse_x,mouse_y;
  float pickrotx,pickroty;
  float picktargz;


  
 public:
  GtkView();
  ~GtkView();

  void show();
  void setCameraInternalParams(float width,float height,
			       float cx,float cy,float focal);

  void setImageBuffer();
  unsigned char *getImageBuffer(){return image;}
  unsigned char *getGLImageBuffer(){return glimage;}
  GdkPixmap *getPixmap(){return pixmap;}

  GtkWidget* getGLDrawingArea(){return gldrawingarea;}
  GtkWidget* getDrawingArea(){return drawingarea;}
  GdkGC* getGC(){return gc;}

  void redraw();

  void setButtonCallback(void *func);
  void addComboString(string str);
  char *getComboString(){
    return gtk_combo_box_get_active_text (GTK_COMBO_BOX (combo0));
  }

  bool isFoundMark(){return isfoundmark;}
  bool isFoundFirst(){
    bool ret=(resetcount!=setcount);
    resetcount=setcount=0;
    return ret;
  }
  float *getParam(){return param;}
  float *getRotation(){return rmat;}
  float *getTransformation(){return tmat;}

  float *getParamHistory(){return paramhistory;}

  void resetMarkPose();
  void setMarkPose(float *fv);
  void setMarkTR(float *tv,float *rm);
  void setMarkTransformation(float *tf);

  unsigned char getParamType(){return paramtype;}
  void setParamType(unsigned char type){paramtype=type;}

  //void setGLObject(GLObject *glo){globj=glo;}
  void setGLObject(GLObject *glo);
  void addGLObject(GLObject *glo);
  GLObject *getGLObject(){return globj;}
  GLObject **getGLObjectList(){return globjs;}
  int getGLObjectNum(){return globjnum;}
  void clearGLObject(){globjnum=0;}

  void activatePickView();
  void deactivatePickView();
  void setMouseX(float x){mouse_x=x;}
  void setMouseY(float y){mouse_y=y;}
  float getMouseX(){return mouse_x;}
  float getMouseY(){return mouse_y;}
  bool isMouseDown(){return ismdown;}
  void setMouseDown(bool ismd){ismdown=ismd;}
  unsigned char getCountMouseDown(){return mdcount;}
  void incrementCountMouseDown(){
    (mdcount>=127)?mdcount=0:mdcount++;
  }
  bool isPick(){return ispick;}
  void incrementPickRot(float incx,float incy){
    pickrotx+=incx;
    pickroty+=incy;
  }
  float getPickRotX(){return pickrotx;}
  float getPickRotY(){return pickroty;}
  float getPickTargetZ(){return picktargz;}
  void setPickTargetZ(float tz){picktargz=tz;}

  float *getLightPos(){return lightPos;}
  void setLightPos(int idx,float x,float y, float z, float w){
    lightPos[idx*4+0]=x;
    lightPos[idx*4+1]=y;
    lightPos[idx*4+2]=z;
    lightPos[idx*4+3]=w;
    switch(idx){
    case 0:
      glLightfv(GL_LIGHT0 , GL_POSITION , lightPos);
      break;
    case 1:
      glLightfv(GL_LIGHT1 , GL_POSITION , lightPos+4);
      break;
    case 2:
      glLightfv(GL_LIGHT2 , GL_POSITION , lightPos+8);
      break;
    default:
      break;
    }
  }
};



#endif
