#include "GtkView.h"


#define PI (atan(1.0)*4.0)
#define MAX_OBJ 16

static gboolean
on_window_delete_event               (GtkWidget       *widget,
				       GdkEvent        *event,
				       gpointer         user_data)
{
  gtk_main_quit();
  //return TRUE;
  return FALSE;
}

static void
on_realize (GtkWidget *widget,
	 gpointer   data)
{
  GdkGLContext *glcontext = gtk_widget_get_gl_context (widget);
  GdkGLDrawable *gldrawable = gtk_widget_get_gl_drawable (widget);

  /*** OpenGL BEGIN ***/
  if (!gdk_gl_drawable_gl_begin (gldrawable, glcontext))
    return;

  //glClearColor (0.6, 0.6, 0.6, 1.0);
  glClearColor (0.0, 0.0, 0.0, 0.0);
  glClearDepth (1.0);
  glEnable(GL_DEPTH_TEST); 
  //glEnable(GL_BLEND);
  //glBlendFunc(GL_SRC_ALPHA , GL_ONE);
  //glEnable(GL_ALPHA_TEST);

  glPixelStorei (GL_UNPACK_ALIGNMENT, 1);

  gdk_gl_drawable_gl_end (gldrawable);
  /*** OpenGL END ***/
}

static gboolean
on_configure_event (GtkWidget         *widget,
		 GdkEventConfigure *event,
		 gpointer           data)
{
  //float lightPos[4];
  //float *lightPos=((GtkView *)data)->getLightPos();
  float lightCol[4];

  GdkGLContext *glcontext = gtk_widget_get_gl_context (widget);
  GdkGLDrawable *gldrawable = gtk_widget_get_gl_drawable (widget);

  glcontext = gtk_widget_get_gl_context (widget);
  gldrawable = gtk_widget_get_gl_drawable (widget);

  GLfloat w = widget->allocation.width;
  GLfloat h = widget->allocation.height;

  /*** OpenGL BEGIN ***/
  if (!gdk_gl_drawable_gl_begin (gldrawable, glcontext))
    return FALSE;

  glViewport (0, 0, w, h);

  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();
  glFrustum (-0.003*w, 0.003*w, -0.003*h, 0.003*h, 2.8, 10000.0);
  glMatrixMode (GL_MODELVIEW);

  lightCol[0]=1.0;
  lightCol[1]=1.0;
  lightCol[2]=1.0;
  lightCol[3]=1.0;

  glLightfv(GL_LIGHT0 , GL_DIFFUSE , lightCol);
  glLightfv(GL_LIGHT1 , GL_DIFFUSE , lightCol);
  glLightfv(GL_LIGHT2 , GL_DIFFUSE , lightCol);
  ((GtkView *)data)->setLightPos(0,200.0,-600.0,-300.0,1.0);
  ((GtkView *)data)->setLightPos(1,500.0,200.0,-500.0,1.0);
  ((GtkView *)data)->setLightPos(2,-600.0,300.0,-300.0,1.0);
  glEnable(GL_LIGHTING);
  glEnable(GL_LIGHT0);
  glEnable(GL_LIGHT1);
  glEnable(GL_LIGHT2);

  gdk_gl_drawable_gl_end (gldrawable);
  /*** OpenGL END ***/
  return TRUE;
}


static gboolean on_expose_event_gl (GtkWidget      *widget,
				    GdkEventExpose *event,
				    gpointer        data){
  GdkGLContext *glcontext = gtk_widget_get_gl_context (widget);
  GdkGLDrawable *gldrawable = gtk_widget_get_gl_drawable (widget);
  GtkView *gview=((GtkView *)data);
  unsigned char *buf=gview->getGLImageBuffer();
  float *param=gview->getParam();
  float *paramhistory=gview->getParamHistory();
  float *tmat=gview->getTransformation();
  float *rmat=gview->getRotation();
  float *lightPos=gview->getLightPos();
  //GLObject *glo=gview->getGLObject();
  GLObject **globjs=gview->getGLObjectList();
  int globjnum=gview->getGLObjectNum();

  float currentparam[6];

  /*** OpenGL BEGIN ***/
  if (!gdk_gl_drawable_gl_begin (gldrawable, glcontext))
    return FALSE;

  glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  if(buf!=NULL && !gview->isPick()){
    glPushMatrix();
    glLoadIdentity();
    glRotatef(180 , 1.0 , 0 , 0); 
    glRasterPos3f(((-0.003*640)+0.006)*1000.0,
		  ((-0.003*480)+0.006)*1000.0,
		  2.8*1000.0);
    glPixelZoom(1, -1);
    glDrawPixels(640 , 480 , GL_RGB , GL_UNSIGNED_BYTE , buf);

    glPopMatrix();
  }

  //if(((GtkView *)data)->isFoundMark() && glo!=NULL){
  if(gview->isFoundMark() && globjnum>0){
    if(gview->isFoundFirst()){
      //glo->reset();
      for(int i=0;i<globjnum;i++){
	globjs[i]->reset();
      }
      for(int i=0;i<5;i++){
	memcpy(&paramhistory[i*6],param,sizeof(float)*6);
      }
    }else{
      // push param to paramhistory
      for(int i=1;i<5;i++){
	memcpy(&paramhistory[i*6],&paramhistory[(i-1)*6],sizeof(float)*6);
      }
      memcpy(paramhistory,param,sizeof(float)*6);
    }
    glPushMatrix();
    glLoadIdentity();
    glRotatef(180 , 1.0 , 0 , 0);

    if(gview->isPick()){
      glTranslatef(0,0,gview->getPickTargetZ());
      glRotatef(gview->getPickRotY(),0,1.0,0);
      glRotatef(gview->getPickRotX(),1.0,0,0);
      glTranslatef(0,0,-(gview->getPickTargetZ()));
    }

    // moving average filter
    for(int i=0;i<6;i++){
      currentparam[i]=paramhistory[i]*0.5;
      currentparam[i]+=paramhistory[i+6]*0.2;
      currentparam[i]+=paramhistory[i+12]*0.15;
      currentparam[i]+=paramhistory[i+18]*0.1;
      currentparam[i]+=paramhistory[i+24]*0.05;
    }
    
    // transformation by estimated pose
    switch(gview->getParamType()){
    case 0:// Z-Y-X euler
      /*
      glTranslatef(param[0],param[1],param[2]);
      glRotatef(param[5]*180.0/PI , 0 , 0 , 1.0);
      glRotatef(param[4]*180.0/PI , 0 , 1.0 , 0);
      glRotatef(param[3]*180.0/PI , 1.0 , 0 , 0);
      */
      glTranslatef(currentparam[0],currentparam[1],currentparam[2]);
      glRotatef(currentparam[5]*180.0/PI , 0 , 0 , 1.0);
      glRotatef(currentparam[4]*180.0/PI , 0 , 1.0 , 0);
      glRotatef(currentparam[3]*180.0/PI , 1.0 , 0 , 0);
      break;
    case 1:// rodrigues rotate vector
      float rx,ry,rz;
      float norm;
      /*
      glTranslatef(param[0],param[1],param[2]);
      rx=param[3];
      ry=param[4];
      rz=param[5];
      */
      glTranslatef(currentparam[0],currentparam[1],currentparam[2]);
      rx=currentparam[3];
      ry=currentparam[4];
      rz=currentparam[5];
      norm=sqrt(rx*rx+ry*ry+rz*rz);
      glRotatef(norm*180.0/PI,rx/norm,ry/norm,rz/norm);
      break;
    case 2:// rotation matrix
      tmat[15]=1.0;
      tmat[3]=tmat[7]=tmat[8]=0.0;
      for(int i=0;i<3;i++){
	tmat[12+i]=param[i];
	for(int j=0;j<3;j++){
	  tmat[j*4+i]=rmat[i*3+j];
	}
      }
      glMultMatrixf(tmat);
      break;
    case 3:// transformation matrix
      glMultMatrixf(tmat);
      break;
    }

    glLightfv(GL_LIGHT0 , GL_POSITION , lightPos);
    glLightfv(GL_LIGHT1 , GL_POSITION , lightPos+4);
    glLightfv(GL_LIGHT2 , GL_POSITION , lightPos+8);

    //glo->glDraw();
    for(int i=0;i<globjnum;i++){
      globjs[i]->glDraw();
    }

    glPopMatrix();
  }


  /* Swap buffers. */
  if (gdk_gl_drawable_is_double_buffered (gldrawable))
    gdk_gl_drawable_swap_buffers (gldrawable);
  else
    glFlush ();

  gdk_gl_drawable_gl_end (gldrawable);
  /*** OpenGL END ***/

  return TRUE;
}
static gboolean on_expose_event (GtkWidget      *widget,
				 GdkEventExpose *event,
				 gpointer        data){
  GdkPixmap *pixmap=((GtkView *) data)->getPixmap();
  gdk_draw_pixmap (widget->window,
		   widget->style->black_gc,
		   pixmap,
		   0,0,0,0,320,240);
  return TRUE;
}

// for pickview
void on_check0_toggled (GtkWidget *widget, gpointer data)
{
  GtkView *gview=(GtkView *)data;
  if (GTK_TOGGLE_BUTTON (widget)->active) {
    /* $B$3$3$KE~C#$7$?$J$i!"%H%0%k%\%?%s$O9_$j$F$$$k(B */
    gview->activatePickView();
  } else {
    /* $B$3$3$KE~C#$7$?$J$i!"%H%0%k%\%?%s$O>e$,$C$F$$$k(B */
    gview->deactivatePickView();
  }
  gview->redraw();
}


static gboolean
button_press_event (GtkWidget      *widget,
		    GdkEventButton *event,
		    gpointer       data)
{
  GtkView *gview=(GtkView *)data;
  gview->setMouseX(event->x);
  gview->setMouseY(event->y);
  gview->setMouseDown(true);
  gview->incrementCountMouseDown();
  if(gview->isPick()){
    gtk_widget_queue_draw(widget);
  }
  return FALSE;
}
static gboolean
button_release_event (GtkWidget      *widget,
		      GdkEventButton *event,
		      gpointer       data)
{
  GtkView *gview=(GtkView *)data;
  gview->setMouseDown(false);
  if(gview->isPick()){
    gtk_widget_queue_draw(widget);
  }
  return FALSE;
}

static gboolean
motion_notify_event (GtkWidget      *widget,
		     GdkEventMotion *event,
		     gpointer        data)
{
  GtkView *gview=(GtkView *)data;
  float oldx,oldy,newx,newy;

  if (event->state & GDK_BUTTON1_MASK){

    oldx=gview->getMouseX();
    oldy=gview->getMouseY();
    
    newx=event->x;
    newy=event->y;

    gview->setMouseX(newx);
    gview->setMouseY(newy);

    if(gview->isPick()){
      gview->incrementPickRot((newy-oldy)*0.5,(newx-oldx)*0.5);
      gtk_widget_queue_draw(widget);
    }
  }
  return TRUE;
}

//



GtkView::GtkView(){
  // initialize gl from gtkglext sample
  glconfig=gdk_gl_config_new_by_mode((GdkGLConfigMode)(GDK_GL_MODE_RGBA |
				     GDK_GL_MODE_DEPTH |
				     GDK_GL_MODE_DOUBLE));
  if(glconfig==NULL){
    g_print ("*** Cannot find the double-buffered visual.\n");
    g_print ("*** Trying single-buffered visual.\n");

    /* Try single-buffered visual */
    glconfig = gdk_gl_config_new_by_mode((GdkGLConfigMode)(GDK_GL_MODE_RGBA |
					 GDK_GL_MODE_DEPTH));
    if (glconfig == NULL){
      g_print ("*** No appropriate OpenGL-capable visual found.\n");
      exit (1);
    }
  }

  //
  window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window),"mARiciten");
  gtk_window_set_default_size (GTK_WINDOW (window), 640, 720);
  gtk_window_set_resizable (GTK_WINDOW (window), FALSE);

  /* Get automatically redrawn if any of their children changed allocation. */
  gtk_container_set_reallocate_redraws (GTK_CONTAINER (window), TRUE);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), vbox1);

  gldrawingarea = gtk_drawing_area_new ();
  gtk_widget_set_size_request (gldrawingarea,640,480);

  /* Set OpenGL-capability to the widget. */
  gtk_widget_set_gl_capability (gldrawingarea,
				glconfig,
				NULL,
				TRUE,
				GDK_GL_RGBA_TYPE);

  //gtk_container_add (GTK_CONTAINER (window), gldrawingarea);
  gtk_box_pack_start (GTK_BOX (vbox1), gldrawingarea, TRUE, TRUE, 0);

  hbox1 = gtk_hbox_new (FALSE, 0);

  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 0);

  drawingarea = gtk_drawing_area_new ();
  gtk_widget_set_size_request (drawingarea, 320, 240);
  gtk_box_pack_start (GTK_BOX (hbox1), drawingarea, TRUE, TRUE, 0);

  image=new unsigned char[640*480*3];
  memset(image,0,640*480*3);
  qimage=new unsigned char[320*240*3];
  memset(qimage,0,320*240*3);
  glimage=new unsigned char[640*480*3];
  memset(glimage,0,640*480*3);
  pixmap=gdk_pixmap_new(NULL,320,240,24);
  gc=gdk_gc_new(pixmap);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox1), vbox2, TRUE, TRUE, 0);

  combo0 =  gtk_combo_box_new_text ();
  //gtk_combo_box_append_text (GTK_COMBO_BOX (combo0), "MonoMarker");
  //gtk_combo_box_append_text (GTK_COMBO_BOX (combo0), "Markerless");
  //gtk_combo_box_set_active(GTK_COMBO_BOX (combo0),0);
  gtk_box_pack_start (GTK_BOX (vbox2), combo0, TRUE, TRUE, 0);

  /*
  check0=gtk_check_button_new_with_label("pickview");
  gtk_box_pack_start (GTK_BOX (vbox2), check0, TRUE, TRUE, 0);
  */

  button0=gtk_button_new_with_mnemonic("start");
  gtk_box_pack_start (GTK_BOX (vbox2), button0, TRUE, TRUE, 0);
  

  g_signal_connect_after (G_OBJECT (gldrawingarea), "realize",
                          G_CALLBACK (on_realize), this);
  g_signal_connect (G_OBJECT (gldrawingarea), "configure_event",
		    G_CALLBACK (on_configure_event), this);
  g_signal_connect (G_OBJECT (gldrawingarea), "expose_event",
		    G_CALLBACK (on_expose_event_gl), this);
  g_signal_connect (G_OBJECT (drawingarea), "expose_event",
		    G_CALLBACK (on_expose_event), this);



  g_signal_connect ((gpointer) window, "delete_event",
                    G_CALLBACK (on_window_delete_event),
                    NULL);

  /*
  g_signal_connect (G_OBJECT (check0), "toggled",
		    G_CALLBACK (on_check0_toggled), this);
  */

  gtk_widget_add_events (gldrawingarea,
			 GDK_BUTTON1_MOTION_MASK |
			 GDK_BUTTON_PRESS_MASK |
			 GDK_BUTTON_RELEASE_MASK);
  g_signal_connect (G_OBJECT (gldrawingarea), "button_press_event",
		    G_CALLBACK (button_press_event), this);
  g_signal_connect (G_OBJECT (gldrawingarea), "button_release_event",
		    G_CALLBACK (button_release_event), this);
  g_signal_connect (G_OBJECT (gldrawingarea), "motion_notify_event",
		    G_CALLBACK (motion_notify_event), this);

  param=new float[6];
  isfoundmark=false;
  resetcount=setcount=0;
  lightPos=new float[12];
  globj=NULL;
  globjs=new GLObject*[MAX_OBJ];
  globjnum=0;

  paramhistory=new float[30]; // 6*5

  paramtype=0;
  rmat=new float[9];
  tmat=new float[16];

  picktargz=1000.0;
  ismdown=false;
  mdcount=0;
  ispick=false;
}

void GtkView::show(){
  /*gtk_widget_show (combo0);
  gtk_widget_show (check0);
  gtk_widget_show (button0);
  gtk_widget_show (vbox2);
  gtk_widget_show (drawingarea);
  gtk_widget_show (hbox1);
  gtk_widget_show (vbox1);
  gtk_widget_show (gldrawingarea);*/
  //gtk_widget_show (window);
  gtk_widget_show_all (window);
}

void GtkView::setImageBuffer(){
  int i,j,xidx0,xidx1,idx0,idx1;
  for(i=0;i<240;i++){
    xidx0=i*320;
    //xidx1=(i*2)*640;
    xidx1=i*1280;
    for(j=0;j<320;j++){
      idx0=(xidx0+j)*3;
      idx1=(xidx1+(j*2))*3;
      qimage[idx0]=image[idx1];
      qimage[idx0+1]=image[idx1+1];
      qimage[idx0+2]=image[idx1+2];
    }
  }
  gdk_draw_rgb_image(pixmap,drawingarea->style->black_gc,0,0,320,240,GDK_RGB_DITHER_NONE,qimage,320*3);
}

void GtkView::redraw(){
  //gtk_widget_queue_draw(gldrawingarea);

  /* Invalidate the whole window. */
  gdk_window_invalidate_rect (gldrawingarea->window, &gldrawingarea->allocation, FALSE);
  gdk_window_invalidate_rect (drawingarea->window, &gldrawingarea->allocation, FALSE);
  /* Update synchronously. */
  gdk_window_process_updates (gldrawingarea->window, FALSE);
  gdk_window_process_updates (drawingarea->window, FALSE);

  //gtk_widget_queue_draw(drawingarea);
}

void GtkView::setButtonCallback(void *func){
  g_signal_connect (G_OBJECT (button0),"clicked",
		    G_CALLBACK (func), this);
}

void GtkView::addComboString(string str){
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo0), str.c_str());
  gtk_combo_box_set_active(GTK_COMBO_BOX (combo0),0);
}


void GtkView::resetMarkPose(){
  isfoundmark=false;
  resetcount++;
}
void GtkView::setMarkPose(float *fv){
  isfoundmark=true;
  setcount++;
  memcpy(param,fv,sizeof(float)*6);  
}
void GtkView::setMarkTR(float *tv,float *rm){
  isfoundmark=true;
  setcount++;
  memcpy(param,tv,sizeof(float)*3);
  memcpy(rmat,rm,sizeof(float)*9);
}
void GtkView::setMarkTransformation(float *tf){
  isfoundmark=true;
  setcount++;
  //memcpy(tmat,tf,sizeof(float)*16);
  for(int i=0;i<4;i++)
    for(int j=0;j<4;j++)
      tmat[i*4+j]=tf[j*4+i];
}


// pickview mode
void GtkView::activatePickView(){
  pickrotx=0.0;
  pickroty=0.0;
  ispick=true;
}

void GtkView::deactivatePickView(){
  ispick=false;
}


GtkView::~GtkView(){
  delete[] image;
  delete[] qimage;
  delete[] param;
  delete[] lightPos;
  delete[] rmat;
  delete[] tmat;
  delete[] globjs;
  delete[] paramhistory;
}

void GtkView::setGLObject(GLObject *glo){
  globjnum=1;
  globjs[0]=glo;
}

void GtkView::addGLObject(GLObject *glo){
  if(globjnum<MAX_OBJ){
    globjs[globjnum]=glo;
    globjnum++;
  }
}
