#ifndef __GTKMARKERVIEW_H__
#define __GTKMARKERVIEW_H__

#include "GtkCtrl.h"

#include <cv.h>
#include <cvaux.h>
#include <cxcore.h>
#include <highgui.h>

#include "SURFConverter.h"
#include "SURFManager.h"

static void gmv_on_save_button_clicked(GtkButton *button,gpointer data);
static void gmv_on_right_button_clicked(GtkButton *button,gpointer data);
static void gmv_on_left_button_clicked(GtkButton *button,gpointer data);
static void gmv_on_send_button_clicked(GtkButton *button,gpointer data);
static gboolean gmv_on_expose_event(GtkWidget      *widget,
				    GdkEventExpose *event,
				    gpointer        data);

class GtkMarkerView{
 private:
  GtkWidget *window;
  GtkWidget *vbox1,*hbox1;
  GtkWidget *drawingarea,*button_right,*button_left,*button_save;
  GtkWidget *text_name;
  GtkWidget *button_send;
  IplImage *image,*nimage;
  SURFManager *surf;

 public:
  GtkMarkerView();
  ~GtkMarkerView();

  void show();
  void setImage(IplImage *img);
  IplImage *getImage();
  void rotateRightImage();
  void rotateLeftImage();
  void saveImage();

  void setSURFManager(SURFManager *ss){surf=ss;}
  void sendImage();
};



#endif
