#include "GtkMarkerView.h"

static void gmv_on_save_button_clicked(GtkButton *button,gpointer data){
  ((GtkMarkerView *)data)->saveImage();
}

static void gmv_on_right_button_clicked(GtkButton *button,gpointer data){
  ((GtkMarkerView *)data)->rotateRightImage();
}

static void gmv_on_left_button_clicked(GtkButton *button,gpointer data){
  ((GtkMarkerView *)data)->rotateLeftImage();
}

static void gmv_on_send_button_clicked(GtkButton *button,gpointer data){
  ((GtkMarkerView *)data)->sendImage();
}

static gboolean gmv_on_expose_event(GtkWidget      *widget,
				    GdkEventExpose *event,
				    gpointer        data){
  GtkMarkerView *gmv=((GtkMarkerView *)data);
  IplImage *img=gmv->getImage();
  int width=img->width;
  int height=img->height;
  int ws=img->widthStep;
  unsigned char *buf=(unsigned char *)img->imageData;
  vector<unsigned char> nbuf;
  nbuf.resize(width*height*3);

  int idx=0,xidx0,xidx1,tidx;
  int i,j;
  for(i=0;i<height;i++){
    xidx0=i*ws;
    xidx1=i*width;
    for(j=0;j<width;j++){
      idx=xidx0+j*3;
      tidx=(xidx1+j)*3;
      nbuf[tidx]=buf[idx+2];
      nbuf[tidx+1]=buf[idx+1];
      nbuf[tidx+2]=buf[idx];
    }
  }

  gdk_draw_rgb_image(widget->window,
		     widget->style->black_gc,
		     0,0,
		     width,height,
		     GDK_RGB_DITHER_NONE,
		     &nbuf[0],
		     width*3);
  return TRUE;
}

GtkMarkerView::GtkMarkerView(){
  window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window),"Generated Marker");

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), vbox1);

  drawingarea = gtk_drawing_area_new ();
  gtk_widget_set_size_request (drawingarea,480,480);
  gtk_box_pack_start (GTK_BOX (vbox1), drawingarea, TRUE, TRUE, 0);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 0);

  button_left=gtk_button_new_with_mnemonic("<--");
  gtk_box_pack_start (GTK_BOX (hbox1), button_left, TRUE, TRUE, 0);
  button_right=gtk_button_new_with_mnemonic("-->");
  gtk_box_pack_start (GTK_BOX (hbox1), button_right, TRUE, TRUE, 0);

  text_name=gtk_entry_new();
  gtk_box_pack_start (GTK_BOX (vbox1), text_name, TRUE, TRUE, 0);

  button_save=gtk_button_new_with_mnemonic("save marker");
  gtk_box_pack_start (GTK_BOX (vbox1), button_save, TRUE, TRUE, 0);

  button_send=gtk_button_new_with_mnemonic("set marker");
  gtk_box_pack_start (GTK_BOX (vbox1), button_send, TRUE, TRUE, 0);

  g_signal_connect (G_OBJECT (button_left), "clicked",
		    G_CALLBACK (gmv_on_left_button_clicked), this);
  g_signal_connect (G_OBJECT (button_right), "clicked",
		    G_CALLBACK (gmv_on_right_button_clicked), this);
  g_signal_connect (G_OBJECT (button_save), "clicked",
		    G_CALLBACK (gmv_on_save_button_clicked), this);
  g_signal_connect (G_OBJECT (button_send), "clicked",
		    G_CALLBACK (gmv_on_send_button_clicked), this);

  g_signal_connect (G_OBJECT (drawingarea), "expose_event",
		    G_CALLBACK (gmv_on_expose_event), this);

  g_signal_connect ((gpointer) window, "delete_event",
                    G_CALLBACK (do_not_destroy_window),
                    NULL);

  image=cvCreateImage(cvSize(480,480),IPL_DEPTH_8U,3);
  cvZero(image);

  //cvNamedWindow("Marker",CV_WINDOW_AUTOSIZE);

  surf=NULL;
}

GtkMarkerView::~GtkMarkerView(){
  //cvDestroyWindow("Marker");
  cvReleaseImage(&image);
}

void GtkMarkerView::show(){
  gtk_widget_show (button_send);
  gtk_widget_show (text_name);
  gtk_widget_show (button_save);
  gtk_widget_show (button_left);
  gtk_widget_show (button_right);
  gtk_widget_show (hbox1);
  gtk_widget_show (drawingarea);
  gtk_widget_show (vbox1);
  gtk_widget_show (window);
}

void GtkMarkerView::setImage(IplImage *img){
  if(img->depth!=IPL_DEPTH_8U || img->nChannels!=3) return;

  cvReleaseImage(&image);
  image=cvCloneImage(img);
  //image=img;

  //cvShowImage("Marker",image);

  cout << "width: " << image->width << ", height: " << image->height << endl;

  gtk_widget_set_size_request (drawingarea,image->width,image->height);
  gtk_widget_queue_draw(drawingarea);

}

IplImage *GtkMarkerView::getImage(){
  return image;
}

void GtkMarkerView::rotateRightImage(){
  int width=image->width;
  int height=image->height;
  nimage=cvCreateImage(cvSize(height,width),IPL_DEPTH_8U,3);
  unsigned char *nbuf=(unsigned char *)nimage->imageData;
  unsigned char *buf=(unsigned char *)image->imageData;
  int ws=image->widthStep;
  int hs=nimage->widthStep;
  
  int i,j,k,xidx,idx0,idx1;
  for(i=0;i<height;i++){
    //xidx=i*width;
    xidx=i*ws;
    for(j=0;j<width;j++){
      //idx0=(xidx+j)*3;
      idx0=xidx+j*3;
      //idx1=(j*height+(height-1-i))*3;
      idx1=j*hs+(height-1-i)*3;
      for(k=0;k<3;k++){
	nbuf[idx1+k]=buf[idx0+k];
      }
    }
  }

  cvReleaseImage(&image);
  image=nimage;
  gtk_widget_set_size_request (drawingarea,image->width,image->height);
  //gtk_widget_queue_draw(drawingarea);
  gtk_widget_queue_draw(window);
  //cvShowImage("Marker",image);

  cout << "width: " << image->width << "(" << image->widthStep << ")" << ", height: " << image->height << endl;
}

void GtkMarkerView::rotateLeftImage(){
  int width=image->width;
  int height=image->height;
  nimage=cvCreateImage(cvSize(height,width),IPL_DEPTH_8U,3);
  
  unsigned char *nbuf=(unsigned char *)nimage->imageData;
  unsigned char *buf=(unsigned char *)image->imageData;
  int ws=image->widthStep;
  int hs=nimage->widthStep;
  
  int i,j,k,xidx,idx0,idx1;
  for(i=0;i<height;i++){
    //xidx=i*width;
    xidx=i*ws;
    for(j=0;j<width;j++){
      //idx0=(xidx+j)*3;
      idx0=xidx+j*3;
      //idx1=((width-1-j)*height+i)*3;
      idx1=(width-1-j)*hs+i*3;
      for(k=0;k<3;k++){
	nbuf[idx1+k]=buf[idx0+k];
      }
    }
  }
  
  cvReleaseImage(&image);
  image=nimage;
  gtk_widget_set_size_request (drawingarea,image->width,image->height);
  //gtk_widget_queue_draw(drawingarea);
  gtk_widget_queue_draw(window);
  //cvShowImage("Marker",image);

  cout << "width: " << image->width << "(" << image->widthStep << ")" << ", height: " << image->height << endl;

}

void GtkMarkerView::saveImage(){
  string fname=(char *)gtk_entry_get_text((GtkEntry *)text_name);
  if(fname==""){
    cout << "filename is empty." << endl;
    return;
  }
  if(fname.length()<5) fname+=".jpg";
  else if(fname.substr(fname.length()-4)!=".jpg") fname+=".jpg";
  cvSaveImage(fname.c_str(),image);
  cout << "save image as: " << fname << endl;
}

void GtkMarkerView::sendImage(){
  if(surf!=NULL){
    surf->setRefImage(image);
  }
}
