#include "GtkView.h"
#include "GLObject.h"
#include "ObjectFileManager.h"
#include "PMDFileManager.h"
#include "MQOFileManager.h"
#include "TextureBoardManager.h"
#include "IKFilter.h"
#include "VVDFileManager.h"
#include "GtkTextView.h"

#define PI (atan(1.0)*4.0)

using namespace std;

static GtkView *gview;
static GLObjObject *globjobj=NULL;
static GLPMDObject *glpmd=NULL;
static GLPolygon *glpoly;
static IKManager *ikm;
static GtkTextViewer *gtext;

static string vpdfilename="";
static string vmdfilename="";
static bool vmdik=false;
static int returnframe=0;

static VVDObject *vvd=NULL;
static GLPolygon *vvdpoly;
static string vvdfilename="";

static GLMQOObject *glmqo=NULL;

static bool readObjIniFile3(string fname){
  string buf,str0,str1;
  int i;
  float tvec[3],rvec[3];
  float objscale;

  string objfile="";
  string mtlfile="";

  bool ret;

  objscale=1.0;
  tvec[0]=tvec[1]=tvec[2]=0.0;
  rvec[0]=rvec[1]=rvec[2]=0.0;

  ifstream ifs(fname.c_str());
  if(!ifs){
    cerr << "ini file not found: " << fname << endl;
    cerr << "loading default settings" << endl;
    return false;
  }

  GTout gto(gtext);

  while(getline(ifs,buf)){
    if(buf=="") continue;
    stringstream sin(buf);
    sin >> str0;
    
    objscale=1.0;
    tvec[0]=tvec[1]=tvec[2]=0.0;
    rvec[0]=rvec[1]=rvec[2]=0.0;

    if(str0=="mqofile"){
      sin >> str1;
      objfile=str1;
      sin >> str1;
      objscale=atof(str1.c_str());
      glmqo=new GLMQOObject();
      //readMQOFile(objfile,glmqo,objscale,cerr);
      readMQOFile(objfile,glmqo,objscale,gto);
    }else if(str0=="pmdfile"){
      if(glpmd==NULL){
	glpmd=new GLPMDObject();
	sin >> str1;
	objfile=str1;
	sin >> str1;
	objscale=atof(str1.c_str());

	//ret = readPMDFile(objfile,glpmd,objscale,GTout(gtext));
	ret = readPMDFile(objfile,glpmd,objscale,gto);
	if(!ret){
	  delete glpmd;
	  glpmd=NULL;
	}
      }
    }else if(str0=="vpdfile"){
      if(glpmd!=NULL){
	sin >> str1;
	//objfile=str1;
	//ret = readVPDFile(objfile,glpmd);
	vpdfilename=str1;
      }
    }else if(str0=="vmdfile"){
      if(glpmd!=NULL){
	sin >> str1;
	vmdfilename=str1;
	sin >> str1;
	if(str1 == "true" || str1 == "t") vmdik=true;
	sin >> str1;
	returnframe=atoi(str1.c_str());
      }
    }else if(str0=="vvdfile"){
      if(glpmd!=NULL){
	sin >> str1;
	//objfile=str1;
	//ret = readVPDFile(objfile,glpmd);
	vvdfilename=str1;
      }
    }else if(str0=="objfile"){
      cout << "reading obj file..." <<endl;
      if(globjobj==NULL){
	globjobj=new GLObjObject();
	
	sin >> str1;
	objfile=str1;
	sin >> str1;
	mtlfile=str1;
	sin >> str1;
	objscale=atof(str1.c_str());
	
	ret = readObjFile(objfile,mtlfile,globjobj,objscale);
	if(!ret){
	  cout << objfile << ": cannot read." <<endl;
	}
	globjobj->setRotate(-90.0,0.0,0.0);
      }
    }else if(str0=="objtrans"){
      for(i=0;i<3;i++){
	sin >> str1;
	tvec[i]=atof(str1.c_str());
      }
      if(glpmd!=NULL) glpmd->setTranslate(tvec[0],tvec[1],tvec[2]);
    }else if(str0=="objrot"){
      for(i=0;i<3;i++){
	sin >> str1;
	rvec[i]=atof(str1.c_str());
      }
      if(glpmd!=NULL) glpmd->setRotate(rvec[0],rvec[1],rvec[2]);
    }else{
      // comment? ignore?
      //cerr << " invalid key: " << str0 << endl;
    }
  }
    
  return true;
}

static void on_button_clicked(GtkButton *button,gpointer data){
  int cnt;
  char *combostring;

  combostring=gview->getComboString();

  GTout gto(gtext);

  if(strcmp(combostring,"IK")==0){
    ikm->calcIK(glpmd);
    gview->redraw();
  }else if(strcmp(combostring,"IterativeIK")==0){
    ikm->calcIterativeIK(glpmd);
    gview->redraw();
  }else if(strcmp(combostring,"reload")==0){
    if(vpdfilename=="") vpdfilename="sample_r.vpd";
    //readVPDFile("sample.vpd",glpmd);
    //readVPDFile("sample_r.vpd",glpmd);
    gtext->clearString();
    //readVPDFile(vpdfilename,glpmd,GTout(gtext));
    readVPDFile(vpdfilename,glpmd,gto);
    ikm->reset();
    gview->redraw();
  }else if(strcmp(combostring,"resetpose")==0){
    glpmd->resetPose();
    gview->redraw();
  }else if(strcmp(combostring,"vpddump")==0){
    writeIKVPDFile("ik.vpd",glpmd);
    gview->redraw();
  }else if(strcmp(combostring,"vmdreadtest")==0){
    if(vmdfilename=="") vmdfilename="yurayura3.vmd";
    //readVMDFile("yurayura3.vmd",glpmd,true,0);
    gtext->clearString();
    //readVMDFile(vmdfilename,glpmd,vmdik,returnframe,GTout(gtext));
    readVMDFile(vmdfilename,glpmd,vmdik,returnframe,gto);
    //readVMDFile("toro_kyukyu.vmd",glpmd,true,10);
    //readVMDFile("toro_kyukyu1.vmd",glpmd,false,10);
    //readVMDFile("test0.vmd",glpmd);
    gview->redraw();
  }else if(strcmp(combostring,"vvd")==0){
    if(vvdfilename=="") vvdfilename="bunny_haruhi2_marged.vvd";
    if(vvd==NULL){
      vvd=new VVDObject();
      ReadVVD(vvdfilename.c_str(),vvd);
      vvdpoly=vvd->createGLPolygon();
      vvdpoly->setGLList();
      //CheckVVD(vvdfilename.c_str());
    }
    gview->setGLObject((GLObject *)vvdpoly);
    gview->redraw();
  }else if(strcmp(combostring,"objtest")==0){
    if(globjobj!=NULL){
      gview->setGLObject((GLObject *)globjobj);
      gview->redraw();
    }
  }else if(strcmp(combostring,"mqo")==0){
    if(glmqo!=NULL){
      gview->setGLObject((GLObject *)glmqo);
      gview->redraw();
    }
  }
}


int main(int argc, char *argv[]){
  gtk_set_locale();
  gtk_init(&argc,&argv);
  gdk_rgb_init();
  gtk_gl_init(&argc,&argv);

  gview=new GtkView();
  gview->addComboString("resetpose");
  gview->addComboString("IK");
  gview->addComboString("IterativeIK");
  gview->addComboString("reload");
  gview->addComboString("vpddump");
  gview->addComboString("vmdreadtest");
  gview->addComboString("objtest");
  //gview->addComboString("vvd");
  gview->addComboString("mqo");
  gview->activatePickView();
  gview->setButtonCallback((void *)on_button_clicked); 
  gview->show();

  gtext=new GtkTextViewer();
  gtext->show();
  
  //globjobj=new GLObjObject();
  //glpmd=new GLPMDObject();
  glpoly=new GLPolygon();

  float fv[]={0,300,800,-PI/2.0,0,0};

  /*
  bool ret=
    readObjFile("miku_blend_Scene.obj","miku_blend_Scene.mtl",globjobj,200.0);
  
  if(!ret){
    getchar();
    return 0;
  }
  globjobj->setRotate(-90.0,0.0,0.0);
  globjobj->setNormalType(1);
  globjobj->setGLList();
  */

  readObjIniFile3("pickobj.ini");
  if(glpmd==NULL){
    glpmd=new GLPMDObject();
    bool ret=
      readPMDFile("miku781052.pmd",glpmd,20.0);
    //readPMDFile("nonowaM_ver2.1.pmd",glpmd,20.0);
    if(!ret){
      getchar();
      return 0;
    }
    cout << "created PMD object." << endl;
    glpmd->setRotate(-90.0,0.0,0.0);
    //glpmd->setGLList();
    //cout << "set GLList." << endl;
  }
  

  /*
  ret=
    readVPDFile("sample.vpd",glpmd);
  if(!ret){
    getchar();
    return 0;
  }
  ret=
    readVPDFile("sample_miku_ik.vpd",glpmd);
  if(!ret){
    getchar();
    return 0;
  }
  */

  ikm=new IKManager(glpmd);

  /*
  bool ret=
    convertImageToGLPolygon("kamenride0_2n.png",glpoly,1.0,1.0);
  
  if(!ret){
    getchar();
    return 0;
  }
  */
  //glpoly->setRotate(0.0,0.0,0.0);


  cout << "setGLObject();" << endl;

  //gview->setGLObject((GLObject *)globjobj);
  gview->setGLObject((GLObject *)glpmd);
  //gview->setGLObject((GLObject *)glpoly);
  gview->setMarkPose(fv);

  cout << "gtk_main();" << endl;

  gtk_main();

  cout << "gtk_main_quit();" << endl;

  delete gview;
  //delete glpmd;
  delete gtext;

  return 0;
}
