#ifndef _PHYSICS_EDITOR_ONE_WX_
#define _PHYSICS_EDITOR_ONE_WX_

#include "Common.h"
#include "PhysicsDefaultValues.h"
#include "PhysicsEditorCommonSrc/PhysicsEditorCommon.h"

static char* TITLE = "Physics Editor One wxWidgets version";

class MainFrame;

class PhysicsEditorOneWX: public wxApp{
public:
	//t[
	MainFrame* frame;

	//ftHgݒ
	PhysicsDefaultValues defaultValues;

	// general
	//	Collections <jp>RNV
	hpl::aleph::Information collectionInfo[NUMBER_OF_COLLECTIONS];
	//	Sounds <jp>
	hpl::aleph::Information soundInfo[NUMBER_OF_SOUND_DEFINITIONS];
	//	damage
	hpl::aleph::Information damageInfo[NUMBER_OF_DAMAGE_TYPES];
    //	Items <jp>ACe
    hpl::aleph::Information itemInfo[NUMBER_OF_DEFINED_ITEMS];
	//	speed (preset)
	hpl::aleph::InformationBinded speedBind[NUMBER_OF_SPEED_INFORMATIONS];

    //X^[
	//	 <en> types
    hpl::aleph::Information monsterInfo[NUMBER_OF_MONSTER_TYPES];
	//	ANeBuvf
    hpl::aleph::Information monsterActivateInfo[NUMBER_OF_MONSTER_ACTIVATE_INFORMATIONS];
	//	classes
	hpl::aleph::InformationBinded monsterClassBind[NUMBER_OF_CLASS_INFORMATIONS];
	//	intelligence
	hpl::aleph::InformationBinded monsterIntelligenceBind[NUMBER_OF_MONSTER_INTELLIGENCE_INFORMATIONS];
	//	door retry mask
	hpl::aleph::InformationBinded monsterDoorRetryMaskBind[NUMBER_OF_MONSTER_DOOR_RETRY_MASK_INFORMATIONS];
	//	flags
	hpl::aleph::InformationBinded monsterFlagsBind[NUMBER_OF_MONSTER_FLAG_INFORMATIONS];

	//projectiles
	//	types
	hpl::aleph::Information projectileInfo[NUMBER_OF_PROJECTILE_TYPES];
	//	flags
	hpl::aleph::InformationBinded projectileFlagsBind[NUMBER_OF_PROJECTILE_FLAG_INFORMATIONS];

	//effect
	//	types
	hpl::aleph::Information effectInfo[NUMBER_OF_EFFECT_TYPES];
	//	flags
	hpl::aleph::InformationBinded effectFlagsBind[NUMBER_OF_EFFECT_FLAG_INFORMATIONS];

	//physics
	hpl::aleph::Information physicsInfo[NUMBER_OF_PHYSICS_MODELS];

	//weapon
	//	types
	hpl::aleph::Information weaponInfo[MAXIMUM_NUMBER_OF_WEAPONS];
	//	classs
	hpl::aleph::Information weaponClassInfo[NUMBER_OF_WEAPON_CLASS_INFORMATIONS];
	//	flags
	hpl::aleph::InformationBinded weaponFlagsBind[NUMBER_OF_WEAPON_FLAG_INFORMATIONS];
	//	shell casing
	hpl::aleph::Information weaponShellCasingInfo[NUMBER_OF_SHELL_CASING_TYPES];
private:
	/**Physicsf[^͕ҏWĂ邩H*/
	bool isChanged_;

	/**Physicsf[^̓t@Cǂݍ܂ꂽ̂ł͂Ȃ̂H*/
	bool isNew_;

	/**ǂݍ񂾏ꍇۑ̃pX*/
	std::string saveFilePath;

	/**ҏW̃X^[CfbNX*/
	int editingMonsterIndex;
	int editingEffectIndex;
	int editingProjectileIndex;
	int editingPhysicsIndex;
	int editingWeaponIndex;
public:
private:
	bool OnInit();

	/**
		wxWidgetsɈˑȂݒ
	*/
	void init();
public:
	/**
		XVǂ
	*/
	void setNewAndChanged(bool new_, bool changed);
	void setChanged(bool changed);
	bool isChanged();
	/**
		VKf[^
	*/
	bool isNew();

	/**
		ǂݍ񂾂邢͕ۑ̃t@CpXݒ
		݂ȂꍇɂĂԂƂ̂͏ƂɂȂB
		̃`FbN˂
	*/
	void setSaveFilePath(const char* filePath);
	std::string getSaveFilePath();

	/**
		ftHgݒ̎o
	*/
	PhysicsDefaultValues* getDefaultValues();

	/**
		PhysicsFileǂݍ݂܂
	*/
	void loadPhysicsFile(const char* filePath);
	void loadDefaultPhysicsFile();

	/**
		Save and/or create PhysicsFile
	*/
	void savePhysicsFile(const char* filePath);

	/**
		ݕҏW̃X^[CfbNX擾
	*/
	int getEditingMonsterIndex();
	int getEditingEffectIndex();
	int getEditingProjectileIndex();
	int getEditingPhysicsIndex();
	int getEditingWeaponIndex();
	void setEditingMonsterIndex(int index);
	void setEditingEffectIndex(int index);
	void setEditingProjectileIndex(int index);
	void setEditingPhysicsIndex(int index);
	void setEditingWeaponIndex(int index);
};

DECLARE_APP(PhysicsEditorOneWX)

#endif
