package jp.hpl.gui.preferences;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

import src.backend.GetFile;

public class Preferences {
	public Map dataMap;
	private static Preferences instance = new Preferences();
	
	public static final String MAP_DEFAULT_PATH = "MapDefaultPath";
	public static final String ENDPOINT_COLOR = "EndpointColor";
	public static final String WALL_LINE_COLOR = "WallLineColor";
	public static final String STAIR_LINE_COLOR = "StairLineColor";
	
	/** lines that do not have stair */
	public static final String FLOOR_LINE_COLOR = "FloorColor";
	
	private static final String PREFERENCE_FILE_NAME = "Preferences.ini";
	
	private static final String SEPARATOR = "=";
	
	private Preferences(){
		dataMap = new HashMap();
		
		setDefault();
	}
	
	public static Preferences getInstance(){
		return instance;
	}
	
	public void loadFromFile(){
		GetFile file = new GetFile(PREFERENCE_FILE_NAME);
		StringTokenizer tokenizer;
		String currentToken = "";
		
		while(!file.havehitEOF()){
			tokenizer = new StringTokenizer(file.getLine());
			try{
				currentToken = tokenizer.nextToken();
			}catch (Exception e) {
				continue;
			}
			try{
				if(currentToken.equals(MAP_DEFAULT_PATH)){
					dataMap.put(MAP_DEFAULT_PATH, tokenizer.nextToken());
				}
			}catch (Exception e) {
				dataMap.put(MAP_DEFAULT_PATH, "");
			}
		}
		file.close();
	}
	
	public void setDefault(){
		//////
		dataMap.put(MAP_DEFAULT_PATH, "");
	}
	
	public String get(String key){
		return (String)dataMap.get(key);
	}
	public void set(String key, String value){
		dataMap.put(key, value);
	}
	public void storeToFile(){
		GetFile file = new GetFile(PREFERENCE_FILE_NAME);
		file.clearFile();
		
		Iterator it = dataMap.keySet().iterator();
		while(it.hasNext()){
			String key = (String)it.next();
			String line = key + SEPARATOR + (String)dataMap.get(key);
			file.setLine(line + "\n");
		}
		file.close();
	}
}
