package jp.hpl.gui;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;

import jp.hpl.data.StaticData;

public class ToolbarDialog extends JDialog implements ActionListener{
	
	public static final int TOOL_ARROW = 0;
	public static final int TOOL_HAND = 1;
	public static final int TOOL_ZOOM = 2;
	
	private int toolType = TOOL_HAND;
	
	private static final String ARROW_IMAGE_FILE_PATH = StaticData.TOOLBAR_DIR_PATH +
		"arrow.png";
	private static final String HAND_IMAGE_FILE_PATH = StaticData.TOOLBAR_DIR_PATH +
	"hand.png";
	private static final String ZOOM_IMAGE_FILE_PATH = StaticData.TOOLBAR_DIR_PATH +
	"magnify.png";
	
	private static String CMD_ARROW = "arrow";
	private static String CMD_HAND = "hand";
	private static String CMD_ZOOM = "zoom";
	
//	/** images */
//	private Image arrowImage;
//	private Image handImage;
//	private Image zoomImage;
	
	/**
	 * 
	 * @param parent
	 */
	public ToolbarDialog(JFrame parent){
		super(parent, "Toolbar", false);
		
//		this.setAlwaysOnTop(true);
//		setUndecorated(false);
		setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
		
		Image img = Toolkit.getDefaultToolkit().getImage(ARROW_IMAGE_FILE_PATH);
		Image handImage = Toolkit.getDefaultToolkit().getImage(HAND_IMAGE_FILE_PATH);
		Image zoomImage = Toolkit.getDefaultToolkit().getImage(ZOOM_IMAGE_FILE_PATH);
		ImageIcon arrowImageIcon = new ImageIcon(img);
		ImageIcon handImageIcon = new ImageIcon(handImage);
		ImageIcon zoomImageIcon = new ImageIcon(zoomImage);
		int width = img.getWidth(this);
		int height = img.getHeight(this);
		this.setSize(new Dimension(width, height * 3 + 100));

		JButton arrowButton = new JButton();
		JButton handButton = new JButton();
		JButton zoomButton = new JButton();
		
		arrowButton.setIcon(arrowImageIcon);
		arrowButton.setSize(new Dimension(width, height));
		handButton.setIcon(handImageIcon);
		handButton.setSize(new Dimension(width, height));
		zoomButton.setIcon(zoomImageIcon);
		zoomButton.setSize(new Dimension(width, height));
		
		this.setLayout(new GridLayout(3,2));
		this.getContentPane().add(arrowButton);
		this.getContentPane().add(handButton);
		this.getContentPane().add(zoomButton);
		
		arrowButton.setActionCommand(CMD_ARROW);
		arrowButton.addActionListener(this);
		handButton.setActionCommand(CMD_HAND);
		handButton.addActionListener(this);
		zoomButton.setActionCommand(CMD_ZOOM);
		zoomButton.addActionListener(this);
		
		((MainViewFrame)parent).getCanvas().setCursor(new Cursor(Cursor.HAND_CURSOR));

//		handButton.setIcon(defaultIcon)
	}

	public void actionPerformed(ActionEvent arg0) {
		String cmd = arg0.getActionCommand();
		if(cmd.equals(CMD_ARROW)){
			setToolType(TOOL_ARROW);
			((MainViewFrame)getParent()).getCanvas().setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
		}else if(cmd.equals(CMD_HAND)){
			setToolType(TOOL_HAND);
			((MainViewFrame)getParent()).getCanvas().setCursor(new Cursor(Cursor.HAND_CURSOR));
		}else if(cmd.equals(CMD_ZOOM)){
			setToolType(TOOL_ZOOM);
			((MainViewFrame)getParent()).getCanvas().setCursor(new Cursor(Cursor.SE_RESIZE_CURSOR));
		}
	}

	public int getToolType() {
		return toolType;
	}

	public void setToolType(int toolType) {
		this.toolType = toolType;
	}
}
