package jp.hpl.data;

import jp.hpl.exception.NoPlayerException;
import src.backend.Level;
import src.backend.ObjsEntry;

public class StaticData {
	
	/** resouces dir path */
	public static final String RESOURCES_DIR_PATH = "resources/";
	
	/** tool bar icon dir path */
	public static final String TOOLBAR_DIR_PATH = RESOURCES_DIR_PATH + "Toolbar/";
	
	/** world one's bit */
	public static final int WORLD_FRACTIONAL_BITS = 10;
	
	/** world one length */
	public static final int WORLD_ONE = 1 << WORLD_FRACTIONAL_BITS;
	
	/** minimum location of world */
	public static final int WORLD_MIN = Short.MIN_VALUE;
	
	/** maximum location of world */
	public static final int WORLD_MAX = Short.MAX_VALUE;
	
	//** object subtypes
	//@see StaticFunctions
	public static final int OBJS_SUBTYPE_MONSTER = 0;
	public static final int OBJS_SUBTYPE_SCENERY = 1;
	public static final int OBJS_SUBTYPE_ITEMS = 2;
	public static final int OBJS_SUBTYPE_PLAYER = 3;
	public static final int OBJS_SUBTYPE_GOALS = 4;
	public static final int OBJS_SUBTYPE_SOUNDS = 5;
	public static final int OBJS_MAP_ICON_GOALS_IMAGE_INDEX = 37;
	public static final int OBJS_MAP_ICON_SCENERY_IMAGE_INDEX = 38;
	public static final int OBJS_MAP_ICON_SOUND_IMAGE_INDEX = 39;

	public static final int ENDPOINT_RECT_SIZE = 2;

	public static final short NONE = -1;
	
	/**
	 * log it to show or store file
	 * @param line
	 */
	public static void logln(String line) {
		System.out.println(line);
	}
	
	public static ObjsEntry getPlayer(Level level) throws NoPlayerException {
		
		for(int i = 0; i < level.getObjsChunk().getNumEntries(); i ++){
			ObjsEntry obj = level.getObjsChunk().getEntry(i);
			if(obj.getType() == StaticData.OBJS_SUBTYPE_PLAYER){
				
//				double[] point3D = {
//					obj.getX() * StaticData.WORLD_ONE,
//					obj.getZ() * StaticData.WORLD_ONE,
//					obj.getY() * StaticData.WORLD_ONE,
//				};
				return obj;
			}
		}
		throw new NoPlayerException();
	}

}
