/*
 * Decompiled with CFR 0.152.
 */
package src.gui;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import src.backend.ObjsEntry;
import src.backend.StaticFunctions;
import src.gui.Model;

public class ObjsTableModel
extends AbstractTableModel {
    public static final int OBJS_TYPE = 0;
    public static final int OBJS_SUBTYPE = 1;
    public static final int OBJS_FACING = 2;
    public static final int OBJS_POLYGON = 3;
    public static final int OBJS_X = 4;
    public static final int OBJS_Y = 5;
    public static final int OBJS_Z = 6;
    public static final int INF_AMOUNT = 65535;
    public static final double MAX_COORD_NUM = 31.999;
    public static final double MIN_COORD_NUM = -32.0;
    private String[] colNames;
    private ArrayList data;
    private Model model;
    private int levelIndex;
    private boolean lastReverse;
    private int lastSortColumn;

    public ObjsTableModel(String[] colNames, Model model, int levelIndex) {
        this.colNames = colNames;
        this.model = model;
        this.levelIndex = levelIndex;
        this.lastReverse = false;
        this.lastSortColumn = 0;
        this.loadTable();
    }

    public void loadTable() {
        this.data = new ArrayList();
        int i = 0;
        while (i < this.model.getNumObjs(this.levelIndex)) {
            this.data.add(i, this.model.getObjsItem(this.levelIndex, i));
            ++i;
        }
        this.sort(this.lastSortColumn, this.lastReverse);
    }

    public String getColumnName(int col) {
        return this.colNames[col];
    }

    public boolean isCellEditable(int row, int column) {
        try {
            return column != 0 || !((String)this.getValueAt(row, column)).equals("Sound");
        }
        catch (Exception e) {
            return false;
        }
    }

    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                try {
                    return StaticFunctions.OBJS_TYPES[((ObjsEntry)this.data.get(row)).getType()];
                }
                catch (Exception e) {
                    return "0";
                }
            }
            case 1: {
                try {
                    return StaticFunctions.OBJS_SUBTYPES[((ObjsEntry)this.data.get(row)).getType()][((ObjsEntry)this.data.get(row)).getSubtype()];
                }
                catch (Exception e) {
                    return "0";
                }
            }
            case 2: {
                try {
                    return new Integer(((ObjsEntry)this.data.get(row)).getFacing());
                }
                catch (Exception e) {
                    return "0";
                }
            }
            case 3: {
                try {
                    return new Integer(((ObjsEntry)this.data.get(row)).getPolygon());
                }
                catch (Exception e) {
                    return "0";
                }
            }
            case 4: {
                try {
                    return new Double(((ObjsEntry)this.data.get(row)).getX());
                }
                catch (Exception e) {
                    return "0";
                }
            }
            case 5: {
                try {
                    return new Double(((ObjsEntry)this.data.get(row)).getY());
                }
                catch (Exception e) {
                    return "0";
                }
            }
            case 6: {
                try {
                    return new Double(((ObjsEntry)this.data.get(row)).getZ());
                }
                catch (Exception e) {
                    return "0";
                }
            }
        }
        return new Object();
    }

    private int getTypeNum(String str) {
        int i = 0;
        while (i < StaticFunctions.OBJS_TYPES.length) {
            if (str.equals(StaticFunctions.OBJS_TYPES[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getSubTypeNum(int row, String str) {
        int i = 0;
        while (i < StaticFunctions.OBJS_SUBTYPES[row].length) {
            if (str.equals(StaticFunctions.OBJS_SUBTYPES[row][i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setValueAt(Object value, int row, int column) {
        int intValue = 0;
        double dblVal = 0.0;
        try {
            intValue = Integer.parseInt((String)value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            switch (column) {
                case 0: {
                    intValue = this.getTypeNum((String)value);
                    ((ObjsEntry)this.data.get(row)).setType((short)intValue);
                    break;
                }
                case 1: {
                    intValue = this.getSubTypeNum(((ObjsEntry)this.data.get(row)).getType(), (String)value);
                    ((ObjsEntry)this.data.get(row)).setSubtype((short)intValue);
                    break;
                }
                case 2: {
                    int highNum = 0;
                    int lowNum = 0;
                    String type = (String)this.getValueAt(row, 0);
                    if (type.equals("Sound")) {
                        highNum = 180;
                        lowNum = -1 * this.model.getPolyNumber(this.levelIndex);
                    } else {
                        highNum = 360;
                        lowNum = 0;
                    }
                    if (intValue > highNum) {
                        ((ObjsEntry)this.data.get(row)).setFacing((short)highNum);
                        break;
                    }
                    if (intValue < lowNum) {
                        ((ObjsEntry)this.data.get(row)).setFacing((short)lowNum);
                        break;
                    }
                    ((ObjsEntry)this.data.get(row)).setFacing((short)intValue);
                    break;
                }
                case 3: {
                    if (intValue > this.model.getPolyNumber(this.levelIndex) - 1) {
                        ((ObjsEntry)this.data.get(row)).setPolygon((short)(this.model.getPolyNumber(this.levelIndex) - 1));
                        break;
                    }
                    if (intValue < 0) {
                        ((ObjsEntry)this.data.get(row)).setPolygon((short)0);
                        break;
                    }
                    ((ObjsEntry)this.data.get(row)).setPolygon((short)intValue);
                    break;
                }
                case 4: {
                    dblVal = Double.parseDouble((String)value);
                    if (dblVal > 31.999) {
                        ((ObjsEntry)this.data.get(row)).setX(31.999);
                        break;
                    }
                    if (dblVal < -32.0) {
                        ((ObjsEntry)this.data.get(row)).setX(-32.0);
                        break;
                    }
                    ((ObjsEntry)this.data.get(row)).setX(dblVal);
                    break;
                }
                case 5: {
                    dblVal = Double.parseDouble((String)value);
                    if (dblVal > 31.999) {
                        ((ObjsEntry)this.data.get(row)).setY(31.999);
                        break;
                    }
                    if (dblVal < -32.0) {
                        ((ObjsEntry)this.data.get(row)).setY(-32.0);
                        break;
                    }
                    ((ObjsEntry)this.data.get(row)).setY(dblVal);
                    break;
                }
                case 6: {
                    dblVal = Double.parseDouble((String)value);
                    if (dblVal > 31.999) {
                        ((ObjsEntry)this.data.get(row)).setZ(31.999);
                        break;
                    }
                    if (dblVal < -32.0) {
                        ((ObjsEntry)this.data.get(row)).setZ(-32.0);
                        break;
                    }
                    ((ObjsEntry)this.data.get(row)).setZ(dblVal);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        this.fireTableCellUpdated(row, column);
    }

    public int getRowCount() {
        return this.data.size();
    }

    public int getColumnCount() {
        return this.colNames.length;
    }

    public void sort(int header, boolean reverse) {
        this.lastSortColumn = header;
        this.lastReverse = reverse;
        switch (header) {
            case 0: {
                this.sortBy(reverse, "type");
                break;
            }
            case 1: {
                this.sortBy(reverse, "subtype");
                break;
            }
            case 2: {
                this.sortBy(reverse, "facing");
                break;
            }
            case 3: {
                this.sortBy(reverse, "polygon");
                break;
            }
            case 4: {
                this.sortBy(reverse, "x");
                break;
            }
            case 5: {
                this.sortBy(reverse, "y");
                break;
            }
            case 6: {
                this.sortBy(reverse, "z");
            }
        }
        this.fireTableDataChanged();
    }

    private void sortBy(boolean reverse, String type) {
        this.mergeSort(0, this.data.size(), reverse, type);
    }

    private void mergeSort(int first, int n, boolean reverse, String type) {
        if (n > 1) {
            int n1 = n / 2;
            int n2 = n - n1;
            this.mergeSort(first, n1, reverse, type);
            this.mergeSort(first + n1, n2, reverse, type);
            this.merge(first, n1, n2, reverse, type);
        }
    }

    private void merge(int first, int n1, int n2, boolean reverse, String type) {
        ObjsEntry[] tempEntry = new ObjsEntry[n1 + n2];
        int copied = 0;
        int copied1 = 0;
        int copied2 = 0;
        while (copied1 < n1 && copied2 < n2) {
            tempEntry[copied++] = this.compare(reverse, type, first, copied1, copied2, n1) ? (ObjsEntry)this.data.get(first + copied1++) : (ObjsEntry)this.data.get(first + n1 + copied2++);
        }
        while (copied1 < n1) {
            tempEntry[copied++] = (ObjsEntry)this.data.get(first + copied1++);
        }
        while (copied2 < n2) {
            tempEntry[copied++] = (ObjsEntry)this.data.get(first + n1 + copied2++);
        }
        int i = 0;
        while (i < n1 + n2) {
            this.data.set(first + i, tempEntry[i]);
            ++i;
        }
    }

    private boolean compare(boolean reverse, String type, int first, int copied1, int copied2, int n1) {
        try {
            if (!reverse && type.equals("type")) {
                return ((ObjsEntry)this.data.get(first + copied1)).getType() < ((ObjsEntry)this.data.get(first + n1 + copied2)).getType();
            }
            if (reverse && type.equals("type")) {
                return ((ObjsEntry)this.data.get(first + copied1)).getType() > ((ObjsEntry)this.data.get(first + n1 + copied2)).getType();
            }
            if (!reverse && type.equals("subtype")) {
                return ((ObjsEntry)this.data.get(first + copied1)).getSubtype() < ((ObjsEntry)this.data.get(first + n1 + copied2)).getSubtype();
            }
            if (reverse && type.equals("subtype")) {
                return ((ObjsEntry)this.data.get(first + copied1)).getSubtype() > ((ObjsEntry)this.data.get(first + n1 + copied2)).getSubtype();
            }
            if (!reverse && type.equals("facing")) {
                return ((ObjsEntry)this.data.get(first + copied1)).getFacing() < ((ObjsEntry)this.data.get(first + n1 + copied2)).getFacing();
            }
            if (reverse && type.equals("facing")) {
                return ((ObjsEntry)this.data.get(first + copied1)).getFacing() > ((ObjsEntry)this.data.get(first + n1 + copied2)).getFacing();
            }
            if (!reverse && type.equals("polygon")) {
                return ((ObjsEntry)this.data.get(first + copied1)).getPolygon() < ((ObjsEntry)this.data.get(first + n1 + copied2)).getPolygon();
            }
            if (reverse && type.equals("polygon")) {
                return ((ObjsEntry)this.data.get(first + copied1)).getPolygon() > ((ObjsEntry)this.data.get(first + n1 + copied2)).getPolygon();
            }
            if (!reverse && type.equals("x")) {
                return ((ObjsEntry)this.data.get(first + copied1)).getX() < ((ObjsEntry)this.data.get(first + n1 + copied2)).getX();
            }
            if (reverse && type.equals("x")) {
                return ((ObjsEntry)this.data.get(first + copied1)).getX() > ((ObjsEntry)this.data.get(first + n1 + copied2)).getX();
            }
            if (!reverse && type.equals("y")) {
                return ((ObjsEntry)this.data.get(first + copied1)).getY() < ((ObjsEntry)this.data.get(first + n1 + copied2)).getY();
            }
            if (reverse && type.equals("y")) {
                return ((ObjsEntry)this.data.get(first + copied1)).getY() > ((ObjsEntry)this.data.get(first + n1 + copied2)).getY();
            }
            if (!reverse && type.equals("z")) {
                return ((ObjsEntry)this.data.get(first + copied1)).getZ() < ((ObjsEntry)this.data.get(first + n1 + copied2)).getZ();
            }
            if (reverse && type.equals("z")) {
                return ((ObjsEntry)this.data.get(first + copied1)).getZ() > ((ObjsEntry)this.data.get(first + n1 + copied2)).getZ();
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public ArrayList getData() {
        return this.data;
    }

    public void addEntry(ObjsEntry newEntry) {
        try {
            this.data.add(newEntry);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeEntry(int row) {
        try {
            ObjsEntry gone = (ObjsEntry)this.data.get(row);
            this.model.removeEntry(this.levelIndex, gone);
            this.loadTable();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

