/*
 * Decompiled with CFR 0.152.
 */
package src.gui;

import javax.swing.JFrame;
import src.backend.JuceChunk;
import src.backend.Level;
import src.backend.LinsChunk;
import src.backend.LinsEntry;
import src.backend.MapData;
import src.backend.NotShPaException;
import src.backend.ObjsChunk;
import src.backend.ObjsEntry;
import src.backend.PlacChunk;
import src.backend.PlacEntry;
import src.backend.PolyChunk;
import src.backend.PolyEntry;
import src.backend.ShPaChunk;
import src.backend.SidsChunk;
import src.backend.SidsEntry;
import src.backend.TooLongException;
import src.gui.FlagsFrame;
import src.gui.MessageBox;

public class Model {
    private FlagsFrame jf;
    private MapData md;
    private String currentFile;
    private String rdMapFileErr = "Problem reading map file";

    public Model() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Model(FlagsFrame jf) {
        this.jf = jf;
    }

    public boolean openMapFile(String openFile) {
        try {
            this.currentFile = openFile;
            this.md = null;
            this.md = new MapData(openFile);
            return this.md.getMapWriter().getFileLoaded();
        }
        catch (Exception e) {
            return false;
        }
    }

    public MapData getMapData() {
        try {
            return this.md;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public boolean[] loadGametypeCheckboxInfo(int levelIndex) {
        try {
            boolean[] flagValues = new boolean[7];
            if (!this.md.getMapWriter().getFileLoaded() || !this.md.getIsValidMap()) {
                int i = 0;
                while (i < 7) {
                    flagValues[i] = false;
                    ++i;
                }
                return flagValues;
            }
            short flags = this.md.getLevel(levelIndex).getFlags();
            int j = 0;
            while (j < 7) {
                flagValues[j] = (flags & 1 << j) != 0;
                ++j;
            }
            return flagValues;
        }
        catch (Exception e) {
            System.out.println("Couldn't load gametype info - Level " + levelIndex);
            return null;
        }
    }

    public boolean[] loadMissionCheckboxInfo(int levelIndex) {
        try {
            boolean[] flagValues = new boolean[5];
            if (!this.md.getMapWriter().getFileLoaded() || !this.md.getIsValidMap()) {
                int i = 0;
                while (i < 5) {
                    flagValues[i] = false;
                    ++i;
                }
                return flagValues;
            }
            short flags = ((Level)this.md.getLevels().get(levelIndex)).getMinfChunk().getMission();
            int i = 0;
            while (i < 5) {
                flagValues[i] = (flags & 1 << i) != 0;
                ++i;
            }
            return flagValues;
        }
        catch (Exception e) {
            System.out.println("Couldn't load mission info - Level " + levelIndex);
            return null;
        }
    }

    public boolean[] loadEnvCheckboxInfo(int levelIndex) {
        try {
            boolean[] flagValues = new boolean[4];
            if (!this.md.getMapWriter().getFileLoaded() || !this.md.getIsValidMap()) {
                int i = 0;
                while (i < 4) {
                    flagValues[i] = false;
                    ++i;
                }
                return flagValues;
            }
            short flags = ((Level)this.md.getLevels().get(levelIndex)).getMinfChunk().getEnvironmentFlags();
            int i = 0;
            while (i < 4) {
                flagValues[i] = (flags & 1 << i) != 0;
                ++i;
            }
            return flagValues;
        }
        catch (Exception e) {
            System.out.println("Couldn't load environment info - Level " + levelIndex);
            return null;
        }
    }

    public void saveGametypeCheckboxInfo(int levelIndex, boolean[] flagValues) {
        int[] flagTypes = new int[]{1, 2, 4, 8, 16, 32, 64};
        int flags = 0;
        int j = 0;
        while (j < 7) {
            if (flagValues[j]) {
                flags |= flagTypes[j];
            }
            ++j;
        }
        try {
            this.md.getLevel(levelIndex).setFlags((short)flags);
            this.md.getLevel(levelIndex).getMinfChunk().setEntry(flags);
        }
        catch (NullPointerException e) {
            System.out.println("Couldn't save gametype info - Level " + levelIndex);
            return;
        }
    }

    public void saveMissionCheckboxInfo(int levelIndex, boolean[] missionValues) {
        int[] flagTypes = new int[]{1, 2, 4, 8, 16};
        int flags = 0;
        int i = 0;
        while (i < 5) {
            if (missionValues[i]) {
                flags |= flagTypes[i];
            }
            ++i;
        }
        try {
            this.md.getLevel(levelIndex).getMinfChunk().setMission((short)flags);
        }
        catch (NullPointerException e) {
            System.out.println("Couldn't save mission info - Level " + levelIndex);
            return;
        }
    }

    public void saveEnvironmentCheckboxInfo(int levelIndex, boolean[] envValues) {
        int[] flagTypes = new int[]{1, 2, 4, 8};
        int flags = 0;
        int i = 0;
        while (i < 4) {
            if (envValues[i]) {
                flags |= flagTypes[i];
            }
            ++i;
        }
        try {
            this.md.getLevel(levelIndex).getMinfChunk().setEnvironmentFlags((short)flags);
        }
        catch (NullPointerException e) {
            System.out.println("Couldn't save environment info - Level " + levelIndex);
            return;
        }
    }

    public void writeData() {
        if (this.currentFile == null) {
            System.out.println("No file to write to");
            return;
        }
        try {
            this.md.write();
        }
        catch (Exception e) {
            System.out.println("Failed writing data");
            return;
        }
    }

    public void writeNew(String saveFile) {
        if (saveFile == null) {
            System.out.println("No file to write to");
            return;
        }
        try {
            this.md.writeNew(saveFile);
        }
        catch (Exception e) {
            System.out.println("Failed writing data");
            return;
        }
    }

    public PlacEntry getPlacItem(int levelIndex, int itemIndex) {
        try {
            return this.md.getLevel(levelIndex).getPlacChunk().getEntry(itemIndex);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public int getSelectedLevelIndex() {
        try {
            return this.jf.getLevelIndex();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setLevelSelectorNames() {
        try {
            this.jf.fillLevelSelector();
        }
        catch (Exception e) {
            return;
        }
    }

    public String getLevelSelectName() {
        try {
            return this.md.getLevel(this.getSelectedLevelIndex()).getlevelSelectName();
        }
        catch (NullPointerException e) {
            System.out.println(this.rdMapFileErr);
            return null;
        }
    }

    public String getLevelSelectName(int index) {
        try {
            if (this.md.getLevel(index).getlevelSelectName().equals("")) {
                return this.md.getLevel(index).getMinfChunk().getName();
            }
            return this.md.getLevel(index).getlevelSelectName();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public void setLevelSelectName(String name, int index) {
        try {
            this.md.getLevel(index).setLevelSelectName(name);
        }
        catch (NullPointerException e) {
            return;
        }
    }

    public String getLevelOverHeadName(int index) {
        try {
            return this.md.getLevel(index).getMinfChunk().getName();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public void setLevelOverHeadName(String name, int index) {
        try {
            this.md.getLevel(index).getMinfChunk().setName(name);
        }
        catch (NullPointerException e) {
            return;
        }
    }

    public short getLandscape(int levelIndex) {
        try {
            return this.md.getLevel(levelIndex).getMinfChunk().getLandscape();
        }
        catch (NullPointerException e) {
            return -1;
        }
    }

    public short getEnvironment(int levelIndex) {
        try {
            return this.md.getLevel(levelIndex).getMinfChunk().getEnvironmentCode();
        }
        catch (NullPointerException e) {
            return -1;
        }
    }

    public void setLandscape(int levelIndex, short newLandscape) {
        try {
            this.md.getLevel(levelIndex).getMinfChunk().setLandscape(newLandscape);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public short getNumLevels() {
        try {
            return this.md.getNumLevels();
        }
        catch (NullPointerException e) {
            return -1;
        }
    }

    public void addShapesPatch(int levelIndex, String path) throws NotShPaException, TooLongException {
        try {
            ShPaChunk c = new ShPaChunk(path);
            this.md.getLevel(levelIndex).addChunk(c);
        }
        catch (NotShPaException notShPa) {
            MessageBox m = new MessageBox("This is not a valid shapes patch");
            throw new NotShPaException();
        }
        catch (TooLongException tooLong) {
            MessageBox m = new MessageBox("The shapes file is too large to add");
            throw new TooLongException();
        }
        catch (Exception e) {
            return;
        }
    }

    public String getComment(int level) {
        try {
            return this.md.getLevel(level).getJuceChunk().getComment();
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    public void setComment(int level, String msg) {
        try {
            this.md.getLevel(level).getJuceChunk().setComment(msg);
        }
        catch (NullPointerException e) {
            try {
                Level mapLevel = this.md.getLevel(level);
                JuceChunk juceChunk = new JuceChunk(msg);
                mapLevel.addChunk(juceChunk);
            }
            catch (NullPointerException ex) {
                return;
            }
        }
    }

    public PlacChunk getPlacChunk(int level) {
        try {
            return this.md.getLevel(level).getPlacChunk();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public ObjsChunk getObjsChunk(int level) {
        try {
            return this.md.getLevel(level).getObjsChunk();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public PolyEntry getPoly(int level, int num) {
        try {
            return this.md.getLevel(level).getPolyChunk().getEntry(num);
        }
        catch (NullPointerException e) {
            return new PolyEntry(new PolyChunk());
        }
    }

    public int getPolyNumber(int level) {
        try {
            return this.md.getLevel(level).getPolyChunk().getNumEntries();
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    public double getPolygonCenterX(int level, int poly) {
        try {
            return this.md.getLevel(level).getPolyChunk().getEntry(poly).getX();
        }
        catch (NullPointerException e) {
            return 0.0;
        }
    }

    public double getPolygonCenterY(int level, int poly) {
        try {
            return this.md.getLevel(level).getPolyChunk().getEntry(poly).getY();
        }
        catch (NullPointerException e) {
            return 0.0;
        }
    }

    public int getNumObjs(int level) {
        try {
            return this.md.getLevel(level).getObjsChunk().getNumEntries();
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    public ObjsEntry getObjsItem(int level, int num) {
        try {
            return this.md.getLevel(level).getObjsChunk().getEntry(num);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public ObjsEntry addObject(int level) {
        try {
            return this.md.getLevel(level).getObjsChunk().addEntry();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public void addObject(int level, ObjsEntry entry) {
        try {
            this.md.getLevel(level).getObjsChunk().addEntry(entry);
        }
        catch (NullPointerException e) {
            return;
        }
    }

    public void removeEntry(int level, ObjsEntry gone) {
        try {
            this.md.getLevel(level).getObjsChunk().removeEntry(gone);
        }
        catch (NullPointerException e) {
            return;
        }
    }

    public int getLinsNumber(int level) {
        try {
            return this.md.getLevel(level).getLinsChunk().getNumEntries();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public LinsEntry getLin(int level, int index) {
        try {
            return this.md.getLevel(level).getLinsChunk().getEntry(index);
        }
        catch (NullPointerException e) {
            return new LinsEntry(new LinsChunk());
        }
    }

    public int getSidsNumber(int level) {
        try {
            return this.md.getLevel(level).getSidsChunk().getNumEntries();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public SidsEntry getSide(int level, int index) {
        try {
            return this.md.getLevel(level).getSidsChunk().getEntry(index);
        }
        catch (Exception e) {
            return new SidsEntry(new SidsChunk());
        }
    }

    public boolean isOptimized() {
        try {
            return this.md.isOptimized();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void convertTextures(int level, int col1, int bmp1, int xfer1, int cp1, int col2, int bmp2, int xfer2, int cp2) {
        try {
            this.md.getLevel(level).convertLevelTextures(col1, bmp1, xfer1, cp1, col2, bmp2, xfer2, cp2);
        }
        catch (Exception e) {
            return;
        }
    }

    public void convertTextures(int level, int col1, int bmp1, int xfer1, int col2, int bmp2, int xfer2) {
        try {
            this.md.getLevel(level).convertLevelTextures(col1, bmp1, xfer1, col2, bmp2, xfer2);
        }
        catch (Exception e) {
            return;
        }
    }

    public void convertTextures(int level, int col1, int bmp1, int col2, int bmp2) {
        try {
            this.md.getLevel(level).convertLevelTextures(col1, bmp1, col2, bmp2);
        }
        catch (Exception e) {
            return;
        }
    }

    public void convertTextures(int level) {
        try {
            this.md.getLevel(level).convertLevelTextures();
        }
        catch (Exception e) {
            return;
        }
    }

    public void removeChildFrame(JFrame window) {
        try {
            this.jf.removeChildFrame(window);
        }
        catch (Exception e) {
            return;
        }
    }

    public void addChildFrame(JFrame window) {
        try {
            this.jf.addChildFrame(window);
        }
        catch (Exception e) {
            return;
        }
    }

    public void turnProgOff() {
        try {
            this.jf.turnProgOff();
        }
        catch (Exception e) {
            return;
        }
    }

    public void initLoad() {
        try {
            this.jf.initLoad();
        }
        catch (Exception e) {
            return;
        }
    }

    public boolean getIsMerged() {
        try {
            return this.md.isMergedMapFile();
        }
        catch (Exception e) {
            return false;
        }
    }

    private void jbInit() throws Exception {
    }
}

