/*
 * Decompiled with CFR 0.152.
 */
package src.backend;

import src.backend.Chunk;
import src.backend.ChunkHeader;
import src.backend.Level;
import src.backend.MapWriter;

public class MinfChunk
extends Chunk {
    private static short MISSION_NONE = 0;
    private static short MISSION_EXTERMINATION = 1;
    private static short MISSION_EXPLORATION = (short)2;
    private static short MISSION_RETRIEVAL = (short)4;
    private static short MISSION_REPAIR = (short)8;
    private static short MISSION_RESCUE = (short)16;
    private static short ENVIRONMENT_NORMAL = 0;
    private static short ENVIRONMENT_VACUUM = 1;
    private static short ENVIRONMENT_MAGNETIC = (short)2;
    private static short ENVIRONMENT_REBELLION = (short)4;
    private static short ENVIRONMENT_LOW_GRAVITY = (short)8;
    private static short ENVIRONMENT_NETWORK = (short)16;
    private static short ENVIRONMENT_SINGLE_PLAYER = (short)32;
    private short environment_code;
    private short physics;
    private short landscape;
    private short mission;
    private short environment_flags;
    private String name;
    private int entry;

    public MinfChunk(Level level, ChunkHeader header) {
        super(level, header);
        MapWriter mw = this.level.getMapData().getMapWriter();
        mw.seek(this.header.getOffset() + 16);
        this.environment_code = mw.readShort();
        this.physics = mw.readShort();
        this.landscape = mw.readShort();
        this.mission = mw.readShort();
        this.environment_flags = mw.readShort();
        mw.skipBytes(8);
        String tmpName = "";
        byte present = mw.readByte();
        while (present != 0) {
            char newChar = (char)present;
            tmpName = String.valueOf(tmpName) + newChar;
            present = mw.readByte();
        }
        this.name = tmpName;
        mw.seek(this.header.getOffset() + 100);
        this.entry = mw.readInt();
    }

    public short getEnvironmentCode() {
        return this.environment_code;
    }

    public short getPhysics() {
        return this.physics;
    }

    public short getLandscape() {
        return this.landscape;
    }

    public short getMission() {
        return this.mission;
    }

    public short getEnvironmentFlags() {
        return this.environment_flags;
    }

    public String getName() {
        return this.name;
    }

    public int getEntry() {
        return this.entry;
    }

    public void setEnvironmentCode(short code) {
        this.environment_code = code;
        this.change();
    }

    public void setPhysics(short phys) {
        this.physics = phys;
        this.change();
    }

    public void setLandscape(short landscape) {
        this.change();
    }

    public void setMission(short mission) {
        this.mission = mission;
        this.change();
    }

    public void setEnvironmentFlags(short flags) {
        this.environment_flags = flags;
        this.change();
    }

    public void setName(String name) {
        this.name = name;
        this.change();
    }

    public void setEntry(int entry) {
        this.entry = entry;
        this.change();
    }

    public void write() {
        super.write();
        MapWriter mw = this.level.getMapData().getMapWriter();
        mw.seek(this.header.getOffset() + 16);
        mw.writeShort(this.environment_code);
        mw.writeShort(this.physics);
        mw.writeShort(this.landscape);
        mw.writeShort(this.mission);
        mw.writeShort(this.environment_flags);
        mw.skipBytes(8);
        int i = 0;
        while (i < 66) {
            if (i < this.name.length()) {
                mw.writeByte(this.name.charAt(i));
            } else {
                mw.writeByte(0);
            }
            ++i;
        }
        mw.writeInt(this.entry);
    }

    public int getNumEntries() {
        return 1;
    }

    public int getEntryLength() {
        return 1536;
    }
}

