/*
 * Decompiled with CFR 0.152.
 */
package jp.hpl.gui.render;

import jp.hpl.exception.IntegerOverFlowException;

public class ViewPort {
    double xmin;
    double xmax;
    double ymin;
    double ymax;
    int width;
    int height;
    double nXMin;
    double nYMin;
    double transX = 0.0;
    double transY = 0.0;

    public void setViewSize(int width, int height, double xmin, double xmax, double ymin, double ymax) {
        this.width = width;
        this.height = height;
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
        this.transformView(0, 0, true);
    }

    private void transformView(int noDrawTop, int noDrawBottom, boolean isSaveAspect) {
        double ap = (this.ymax - this.ymin) / (this.xmax - this.xmin);
        double aw = (double)(this.height - noDrawTop - noDrawBottom) / (double)this.width;
        this.transX = (double)this.width / (this.xmax - this.xmin);
        this.transY = (double)(this.height - noDrawTop - noDrawBottom) / (this.ymax - this.ymin);
        this.nXMin = 0.0;
        this.nYMin = noDrawBottom;
        if (isSaveAspect) {
            if (ap > aw) {
                this.nXMin = (int)(0.5 * (1.0 - this.transY / this.transX) * (double)this.width);
                this.transX = this.transY;
            } else {
                this.nYMin += (double)((int)(0.5 * (1.0 - this.transX / this.transY) * (double)this.height));
                this.transY = this.transX;
            }
        }
    }

    public int[] getViewPoint(double y, double z) throws IntegerOverFlowException {
        int[] point2D = new int[2];
        double X = this.transX * (y - this.xmin) + this.nXMin;
        double Y = (double)this.height - this.nYMin - this.transY * (z - this.ymin);
        if (Math.abs(X) >= 2.147483647E9 || Math.abs(Y) >= 2.147483647E9) {
            throw new IntegerOverFlowException();
        }
        point2D[0] = (int)X;
        point2D[1] = (int)Y;
        return point2D;
    }
}

