/*
 * Decompiled with CFR 0.152.
 */
package jp.hpl.gui.render;

import jp.hpl.exception.IntegerOverFlowException;
import jp.hpl.gui.render.Camera;
import jp.hpl.gui.render.ViewPort;

public class Transformer {
    private Camera camera = new Camera();
    ViewPort viewPort;
    private double[][] transform = new double[3][3];
    public static final double TRANSPARENT_FUNCTION_MAX = 100.0;

    public Transformer() {
        this.doCalcTransformArray();
        this.viewPort = new ViewPort();
    }

    public double[] getPers(double[] transformedPoint) {
        double[] points = new double[transformedPoint.length];
        double base = transformedPoint[2];
        double pers = 0.0;
        if (base == 0.0) {
            base = 0.001;
        }
        pers = 100.0 / base;
        int j = 0;
        while (j < transformedPoint.length) {
            points[j] = transformedPoint[j] * pers;
            ++j;
        }
        return points;
    }

    public double[] get3DView(double[] sourcePoints) {
        double[] destPoints = new double[sourcePoints.length];
        double[] center = this.camera.getCenter();
        double[] trans = new double[3];
        int j = 0;
        while (j < trans.length) {
            trans[j] = sourcePoints[j] - center[j];
            ++j;
        }
        int k = 0;
        while (k < trans.length) {
            destPoints[k] = 0.0;
            int j2 = 0;
            while (j2 < trans.length) {
                int n = k;
                destPoints[n] = destPoints[n] + trans[j2] * this.transform[j2][k];
                ++j2;
            }
            ++k;
        }
        return destPoints;
    }

    public void doCalcTransformArray() {
        double cosP;
        double theta = this.camera.getTheta();
        double phi = this.camera.getPhi();
        double sinT = Math.sin(theta);
        double cosT = Math.cos(theta);
        double sinP = Math.sin(phi);
        this.transform[0][0] = cosP = Math.cos(phi);
        this.transform[0][1] = 0.0;
        this.transform[0][2] = -sinP;
        this.transform[1][0] = -sinT * sinP;
        this.transform[1][1] = cosT;
        this.transform[1][2] = -sinT * cosP;
        this.transform[2][0] = cosT * sinP;
        this.transform[2][1] = sinT;
        this.transform[2][2] = cosT * cosP;
    }

    public void setViewSize(int width, int height, double xmin, double xmax, double ymin, double ymax) {
        this.viewPort.setViewSize(width, height, xmin, xmax, ymin, ymax);
    }

    public Camera getCamera() {
        return this.camera;
    }

    public int[] getViewPoint(double[] peredPoint) throws IntegerOverFlowException {
        int[] point2D = this.viewPort.getViewPoint(peredPoint[0], peredPoint[1]);
        return point2D;
    }
}

