/*
 * Decompiled with CFR 0.152.
 */
package jp.hpl.gui.render;

import java.awt.Graphics;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import jp.hpl.data.EpntEntry;
import jp.hpl.gui.render.AbstractRenderer;
import jp.hpl.gui.render.Transformer;
import src.backend.Level;
import src.backend.LinsEntry;

public class LineRenderer
extends AbstractRenderer {
    Map verticalHeightInformationMap;
    JComponent parent;

    public LineRenderer(Transformer tr, Level level, JComponent parent) {
        super(tr, level);
        this.parent = parent;
        this.verticalHeightInformationMap = new HashMap();
        int l = 0;
        while (l < this.levelForDraw.getLinsChunk().getNumEntries()) {
            LinsEntry line = this.levelForDraw.getLinsChunk().getEntry(l);
            short rightPolyIndex = line.getClockwisePolyOwner();
            short leftPolyIndex = line.getCounterClockwisePolyOwner();
            if (rightPolyIndex == -1 || leftPolyIndex == -1) {
                short[] endpointIndex = line.getEndpoints();
                int i = 0;
                while (i < endpointIndex.length) {
                    short entry = endpointIndex[i];
                    if (!this.verticalHeightInformationMap.containsKey(entry)) {
                        short ceiling = Short.MIN_VALUE;
                        short floor = Short.MAX_VALUE;
                        int j = 0;
                        while (j < this.levelForDraw.getLinsChunk().getNumEntries()) {
                            LinsEntry otherLine = this.levelForDraw.getLinsChunk().getEntry(j);
                            if (otherLine.getEndpoints()[0] == entry || otherLine.getEndpoints()[1] == entry) {
                                short lowestCeiling = otherLine.getLowestAdjacentCeiling();
                                short highestFloor = otherLine.getHighestAdjacentFloor();
                                if (floor > highestFloor) {
                                    floor = highestFloor;
                                }
                                if (ceiling < lowestCeiling) {
                                    ceiling = lowestCeiling;
                                }
                            }
                            ++j;
                        }
                        Integer[] minMaxHeight = new Integer[]{new Integer(floor), new Integer(ceiling)};
                        this.verticalHeightInformationMap.put(Integer.valueOf(entry), minMaxHeight);
                    }
                    ++i;
                }
            }
            ++l;
        }
    }

    public void draw(JComponent canvas, Graphics g) {
        this.drawVerticalLines(g);
        int i = 0;
        while (i < this.levelForDraw.getLinsChunk().getNumEntries()) {
            if (!this.drawHorizontalLine(g, i)) {
                // empty if block
            }
            ++i;
        }
    }

    private void drawVerticalLines(Graphics g) {
        Iterator it = this.verticalHeightInformationMap.keySet().iterator();
        while (it.hasNext()) {
            Integer epEntryIndex = (Integer)it.next();
            Integer[] minMax = (Integer[])this.verticalHeightInformationMap.get(epEntryIndex);
            EpntEntry epEntry = this.levelForDraw.getEpntChunk().getEntry(epEntryIndex);
            double[][] point3Ds = new double[2][3];
            int i = 0;
            while (i < minMax.length) {
                double[] temp = new double[]{(double)epEntry.getVertex()[0] * 0.061037018951994385, (double)minMax[i].intValue() * 0.061037018951994385, (double)epEntry.getVertex()[1] * 0.061037018951994385};
                point3Ds[i] = this.transformer.get3DView(temp);
                ++i;
            }
            if (this.drawLine(point3Ds, g)) continue;
        }
    }

    private boolean drawLine(double[][] point3Ds, Graphics g) {
        int[][] viewPoint2D;
        block8: {
            boolean[] isBackward = new boolean[2];
            int j = 0;
            while (j < isBackward.length) {
                isBackward[j] = point3Ds[j][2] < 0.0;
                ++j;
            }
            if (isBackward[0] && isBackward[1]) {
                return false;
            }
            j = 0;
            while (j < isBackward.length) {
                if (isBackward[j]) {
                    point3Ds[j][2] = 0.0;
                }
                ++j;
            }
            try {
                viewPoint2D = new int[2][2];
                int j2 = 0;
                while (j2 < point3Ds.length) {
                    double[] peredPoint = this.transformer.getPers(point3Ds[j2]);
                    viewPoint2D[j2] = this.transformer.getViewPoint(peredPoint);
                    ++j2;
                }
                if (this.parent.getBounds().contains(viewPoint2D[0][0], viewPoint2D[0][1]) || this.parent.getBounds().contains(viewPoint2D[1][0], viewPoint2D[1][1])) break block8;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        g.drawLine(viewPoint2D[0][0], viewPoint2D[0][1], viewPoint2D[1][0], viewPoint2D[1][1]);
        return true;
    }

    private boolean drawHorizontalLine(Graphics g, int entrty) {
        LinsEntry line = this.levelForDraw.getLinsChunk().getEntry(entrty);
        short[] endpointIndex = line.getEndpoints();
        double[] heights = new double[]{line.getHighestAdjacentFloor(), line.getLowestAdjacentCeiling()};
        int floorAndHeight = 0;
        while (floorAndHeight < heights.length) {
            double[][] point3Ds = new double[2][3];
            int e = 0;
            while (e < endpointIndex.length) {
                EpntEntry endpoint = this.levelForDraw.getEpntChunk().getEntry(endpointIndex[e]);
                short[] pointWorld2D = endpoint.getVertex();
                double[] pointWorld3DAdjust = new double[]{(double)pointWorld2D[0] * 0.061037018951994385, heights[floorAndHeight] * 0.061037018951994385, (double)pointWorld2D[1] * 0.061037018951994385};
                point3Ds[e] = this.transformer.get3DView(pointWorld3DAdjust);
                ++e;
            }
            if (!this.drawLine(point3Ds, g)) {
                // empty if block
            }
            ++floorAndHeight;
        }
        return true;
    }
}

