/*
 * Decompiled with CFR 0.152.
 */
package src.gui;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTextArea;
import src.backend.GetFile;
import src.backend.Preferences;
import src.backend.StaticFunctions;
import src.gui.CommentFrame_btnCancel_actionAdapter;
import src.gui.CommentFrame_btnOK_actionAdapter;
import src.gui.CommentFrame_jMenuItem1_actionAdapter;
import src.gui.FixedSizePlainDocument;
import src.gui.Model;

public class CommentFrame
extends JFrame {
    private Model model;
    private int levelIndex;
    JTextArea txtComment = new JTextArea();
    JButton btnOK = new JButton();
    JButton btnCancel = new JButton();
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenu1 = new JMenu();
    JMenuItem jMenuItem1 = new JMenuItem();

    public CommentFrame(Model model, int levelIndex) {
        try {
            this.model = model;
            this.levelIndex = levelIndex;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        FixedSizePlainDocument doc = new FixedSizePlainDocument(512);
        this.getContentPane().setLayout(null);
        this.txtComment.setBorder(BorderFactory.createLineBorder(Color.black));
        this.txtComment.setDocument(doc);
        this.txtComment.setText("");
        this.txtComment.setLineWrap(true);
        this.txtComment.setWrapStyleWord(true);
        this.txtComment.setBounds(new Rectangle(0, 0, 400, 255));
        this.btnOK.setBounds(new Rectangle(202, 261, 80, 31));
        this.btnOK.setText("OK");
        this.btnOK.addActionListener(new CommentFrame_btnOK_actionAdapter(this));
        this.btnCancel.setBounds(new Rectangle(113, 261, 80, 31));
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new CommentFrame_btnCancel_actionAdapter(this));
        this.setJMenuBar(this.jMenuBar1);
        this.jMenu1.setText("Commands");
        this.jMenuItem1.setText("Read from file");
        this.jMenuItem1.addActionListener(new CommentFrame_jMenuItem1_actionAdapter(this));
        this.getContentPane().add(this.txtComment);
        this.getContentPane().add(this.btnOK);
        this.getContentPane().add(this.btnCancel);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu1.add(this.jMenuItem1);
        this.txtComment.setText(this.model.getComment(this.levelIndex));
        this.setSize(410, 345);
        this.setTitle("Level Comment - " + this.model.getLevelSelectName());
        StaticFunctions.centerFrame(this);
        this.setResizable(false);
        this.setVisible(true);
    }

    public void btnCancel_actionPerformed(ActionEvent e) {
        this.model.removeChildFrame(this);
        this.dispose();
    }

    public void btnOK_actionPerformed(ActionEvent e) {
        this.model.setComment(this.levelIndex, this.txtComment.getText());
        this.model.removeChildFrame(this);
        this.dispose();
    }

    public void jMenuItem1_actionPerformed(ActionEvent e) {
        int retVal;
        String openFile = "";
        JFileChooser fc = new JFileChooser();
        String path = Preferences.MAPS_PATH;
        try {
            if (!path.equals("")) {
                fc.setCurrentDirectory(new File(path));
            }
        }
        catch (Exception ex) {
            fc.setCurrentDirectory(new File("user.dir"));
        }
        if ((retVal = fc.showOpenDialog(this)) == 0) {
            openFile = fc.getSelectedFile().getPath();
        } else if (retVal == 1) {
            return;
        }
        GetFile theFile = new GetFile(openFile);
        String text = theFile.getNumChars(512);
        this.txtComment.setText(text);
        theFile.close();
    }
}

