/*
 * Decompiled with CFR 0.152.
 */
package src.backend;

import src.backend.Chunk;
import src.backend.ChunkHeader;
import src.backend.IChunk;
import src.backend.Level;
import src.backend.MapWriter;

public class UnknownChunk
extends Chunk
implements IChunk {
    private byte[] data;

    public UnknownChunk(Level level, ChunkHeader header) {
        super(level, header);
        this.data = new byte[header.getLength()];
        MapWriter mw = this.level.getMapData().getMapWriter();
        mw.seek(this.header.getOffset() + 16);
        mw.read(this.data);
    }

    public void write() {
        super.write();
        MapWriter mw = this.level.getMapData().getMapWriter();
        mw.seek(this.header.getOffset() + 16 + this.getLevel().getOffset());
        mw.write(this.data);
    }

    public int getNumEntries() {
        return 1;
    }

    public int getEntryLength() {
        return this.data.length;
    }

    public int calc() {
        return super.calc();
    }
}

