/*
 * Decompiled with CFR 0.152.
 */
package src.backend;

import src.backend.Entry;
import src.backend.IEntry;
import src.backend.MapWriter;
import src.backend.ShapeDescriptor;
import src.backend.SideTexture;
import src.backend.SidsChunk;
import src.backend.WrkArrayReader;

public class SidsEntry
extends Entry
implements IEntry {
    public static final int ENTRY_LENGTH = 64;
    short type;
    short flags;
    SideTexture primary;
    SideTexture secondary;
    SideTexture transparent;
    int e0;
    int e1;
    int e2;
    int e3;
    short panel_type;
    short panel_permutation;
    short primary_transfer;
    short secondary_transfer;
    short transparent_transfer;
    short polygon_index;
    short line_index;
    short primary_light;
    short secondary_light;
    short transparent_light;
    int ambient_delta;
    short unused;

    public SidsEntry(SidsChunk chunk) {
        super(chunk);
    }

    public short getType() {
        return this.type;
    }

    public short getFlags() {
        return this.flags;
    }

    public SideTexture[] getSideTextures() {
        SideTexture[] s = new SideTexture[]{this.primary, this.secondary, this.transparent};
        return s;
    }

    public short getPanelType() {
        return this.panel_type;
    }

    public short getPanelPermutation() {
        return this.panel_permutation;
    }

    public short getPrimaryTransfer() {
        return this.primary_transfer;
    }

    public short getSecondaryTransfer() {
        return this.secondary_transfer;
    }

    public short getTransparentTransfer() {
        return this.transparent_transfer;
    }

    public short getPolygonIndex() {
        return this.polygon_index;
    }

    public short getLineIndex() {
        return this.line_index;
    }

    public short getPrimaryLight() {
        return this.primary_light;
    }

    public short getSecondaryLight() {
        return this.secondary_light;
    }

    public short getTransparentLight() {
        return this.transparent_light;
    }

    public void setType(short t) {
        this.type = t;
    }

    public void setFlags(short f) {
        this.flags = f;
    }

    public void setSideTextures(SideTexture s1, SideTexture s2, SideTexture s3) {
        this.primary = s1;
        this.secondary = s2;
        this.transparent = s3;
    }

    public void setPanelType(short t) {
        this.panel_type = t;
    }

    public void setPanelPermutation(short p) {
        this.panel_permutation = p;
    }

    public void setPrimaryTransfer(short t) {
        this.primary_transfer = t;
    }

    public void setSecondaryTransfer(short t) {
        this.secondary_transfer = t;
    }

    public void setTransparentTransfer(short t) {
        this.transparent_transfer = t;
    }

    public void setPolygonIndex(short i) {
        this.polygon_index = i;
    }

    public void setLineIndex(short i) {
        this.line_index = i;
    }

    public void setPrimaryLight(short l) {
        this.primary_light = l;
    }

    public void setSecondaryLight(short l) {
        this.secondary_light = l;
    }

    public void setTransparentLight(short l) {
        this.transparent_light = l;
    }

    public SidsEntry read() {
        MapWriter mapWriter = this.chunk.getLevel().getMapData().getMapWriter();
        byte[] data = new byte[64];
        mapWriter.read(data);
        WrkArrayReader wrk = new WrkArrayReader(data);
        this.type = wrk.readShort();
        this.flags = wrk.readShort();
        short x = wrk.readShort();
        short y = wrk.readShort();
        short d = wrk.readShort();
        ShapeDescriptor s1 = new ShapeDescriptor(d);
        this.primary = new SideTexture(x, y, s1);
        x = wrk.readShort();
        y = wrk.readShort();
        d = wrk.readShort();
        ShapeDescriptor s2 = new ShapeDescriptor(d);
        this.secondary = new SideTexture(x, y, s2);
        x = wrk.readShort();
        y = wrk.readShort();
        d = wrk.readShort();
        ShapeDescriptor s3 = new ShapeDescriptor(d);
        this.transparent = new SideTexture(x, y, s3);
        this.e0 = wrk.readInt();
        this.e1 = wrk.readInt();
        this.e2 = wrk.readInt();
        this.e3 = wrk.readInt();
        this.panel_type = wrk.readShort();
        this.panel_permutation = wrk.readShort();
        this.primary_transfer = wrk.readShort();
        this.secondary_transfer = wrk.readShort();
        this.transparent_transfer = wrk.readShort();
        this.polygon_index = wrk.readShort();
        this.line_index = wrk.readShort();
        this.primary_light = wrk.readShort();
        this.secondary_light = wrk.readShort();
        this.transparent_light = wrk.readShort();
        this.ambient_delta = wrk.readInt();
        return this;
    }

    public void write() {
        MapWriter mapWriter = this.chunk.getLevel().getMapData().getMapWriter();
        byte[] data = new byte[64];
        WrkArrayReader wrk = new WrkArrayReader(data);
        wrk.writeShort(this.type);
        wrk.writeShort(this.flags);
        short x = this.primary.getX();
        short y = this.primary.getY();
        ShapeDescriptor d = this.primary.getTexture();
        short desc = (short)d.getDesc();
        wrk.writeShort(x);
        wrk.writeShort(y);
        wrk.writeShort(desc);
        x = this.secondary.getX();
        y = this.secondary.getY();
        d = this.secondary.getTexture();
        desc = (short)d.getDesc();
        wrk.writeShort(x);
        wrk.writeShort(y);
        wrk.writeShort(desc);
        x = this.transparent.getX();
        y = this.transparent.getY();
        d = this.transparent.getTexture();
        desc = (short)d.getDesc();
        wrk.writeShort(x);
        wrk.writeShort(y);
        wrk.writeShort(desc);
        wrk.writeInt(this.e0);
        wrk.writeInt(this.e1);
        wrk.writeInt(this.e2);
        wrk.writeInt(this.e3);
        wrk.writeShort(this.panel_type);
        wrk.writeShort(this.panel_permutation);
        wrk.writeShort(this.primary_transfer);
        wrk.writeShort(this.secondary_transfer);
        wrk.writeShort(this.transparent_transfer);
        wrk.writeShort(this.polygon_index);
        wrk.writeShort(this.line_index);
        wrk.writeShort(this.primary_light);
        wrk.writeShort(this.secondary_light);
        wrk.writeShort(this.transparent_light);
        wrk.writeInt(this.ambient_delta);
        wrk.writeShort(this.unused);
        mapWriter.write(data);
    }
}

