/*
 * Decompiled with CFR 0.152.
 */
package src.backend;

import java.util.ArrayList;
import src.backend.Chunk;
import src.backend.ChunkHeader;
import src.backend.IChunk;
import src.backend.Level;
import src.backend.MapWriter;
import src.backend.PlacEntry;

public class PlacChunk
extends Chunk
implements IChunk {
    private ArrayList placEntries = this.getMonsterPlacement(this.placEntries);
    public static final byte ITEM_END = 36;
    public static final byte MONSTER_BEGIN = 64;
    public static final byte MONSTER_END = 111;
    private static int DIFFERENCE = 28;
    private static int PLAC_END = 128;

    public PlacChunk(Level level, ChunkHeader header) {
        super(level, header);
    }

    public PlacEntry getEntry(int i) {
        return (PlacEntry)this.placEntries.get(i);
    }

    public ArrayList getItemPlacement(ArrayList entries) {
        MapWriter mw = this.getLevel().getMapData().getMapWriter();
        long dataStart = this.header.getOffset() + 16;
        int i = 0;
        while (i < 36) {
            mw.seek(dataStart + (long)(i * 12));
            PlacEntry placEntry = new PlacEntry(this);
            placEntry.setFlags(mw.readShort());
            placEntry.setInitial(mw.readShort());
            placEntry.setMinimum(mw.readShort());
            placEntry.setMaximum(mw.readShort());
            placEntry.setRandomCount(mw.readUnsignedShort());
            placEntry.setRandomChance(mw.readUnsignedShort());
            this.placEntries.add(placEntry);
            ++i;
        }
        return entries;
    }

    public ArrayList getMonsterPlacement(ArrayList entries) {
        MapWriter mw = this.getLevel().getMapData().getMapWriter();
        long dataStart = this.header.getOffset() + 16;
        int i = 64;
        while (i < 111) {
            mw.seek(dataStart + (long)(i * 12));
            PlacEntry placEntry = new PlacEntry(this);
            placEntry.setFlags(mw.readShort());
            placEntry.setInitial(mw.readShort());
            placEntry.setMinimum(mw.readShort());
            placEntry.setMaximum(mw.readShort());
            placEntry.setRandomCount(mw.readUnsignedShort());
            placEntry.setRandomChance(mw.readUnsignedShort());
            this.placEntries.add(placEntry);
            ++i;
        }
        return entries;
    }

    public void writeItemPlacement() {
        long dataStart = this.header.getOffset() + 16 + this.getLevel().getOffset();
        MapWriter mw = this.getLevel().getMapData().getMapWriter();
        int i = 0;
        while (i < 36) {
            mw.seek(dataStart + (long)(i * 12));
            this.getEntry(i).write();
            ++i;
        }
    }

    public void writePadding() {
        int dataStart = this.header.getOffset() + 16 + this.getLevel().getOffset();
        byte[] blank_entry = new byte[12];
        MapWriter mw = this.level.getMapData().getMapWriter();
        int i = 36;
        while (i < 64) {
            mw.seek(dataStart + i * 12);
            mw.write(blank_entry);
            ++i;
        }
    }

    public void writeMonsterPlacement() {
        long dataStart = this.header.getOffset() + 16 + this.getLevel().getOffset();
        MapWriter mw = this.getLevel().getMapData().getMapWriter();
        int i = 64;
        while (i < 111) {
            mw.seek(dataStart + (long)(i * 12));
            this.getEntry(i - DIFFERENCE).write();
            ++i;
        }
    }

    public void writeCrapAtEnd() {
        int dataStart = this.header.getOffset() + 16 + this.getLevel().getOffset();
        MapWriter mw = this.getLevel().getMapData().getMapWriter();
        byte[] blank = new byte[12];
        int i = 111;
        while (i < PLAC_END) {
            mw.seek(dataStart + i * 12);
            mw.write(blank);
            ++i;
        }
    }

    public void write() {
        super.write();
        this.writeItemPlacement();
        this.writePadding();
        this.writeMonsterPlacement();
        this.writeCrapAtEnd();
    }

    public int getNumEntries() {
        return PLAC_END;
    }

    public int getEntryLength() {
        return 12;
    }

    public int calc() {
        return super.calc();
    }
}

