<?php

class BruteSearch extends SearchMySQL {

        /** 
         * Parse the user's query and transform it into an SQL fragment which will 
         * become part of a WHERE clause
         */
        function parseQuery( $filteredText, $fulltext ) {
                global $wgContLang;
                $lc = SearchEngine::legalSearchChars(); // Minus format chars
                $searchon = '';
                $this->searchTerms = array();

                $field = $this->getIndexField( $fulltext );

                # FIXME: This doesn't handle parenthetical expressions.
                $m = array();
                if( preg_match_all( '/([-+<>~]?)(([' . $lc . ']+)(\*?)|"[^"]*")/',
                          $filteredText, $m, PREG_SET_ORDER ) ) {
                        foreach( $m as $terms ) {
                                if( $searchon !== '' ) $searchon .= ' ';
                                if( $this->strictMatching && ($terms[1] == '') ) {
                                        $terms[1] = '+';
                                }
                                if( !empty( $terms[3] ) ) {
                                        // Match individual terms in result highlighting...
                                        $regexp = preg_quote( $terms[3], '/' );
                                        $terms[3] = str_replace( '\'', '\\\'', $terms[3] );
                                        if ( !empty( $searchon ) ) { $searchon .= ' AND '; }
                                        if ( $terms[1] == '-' ) { $searchon .= ' NOT '; }
                                        $searchon .= (" $field LIKE '%" . $terms[3] . "%' COLLATE utf8_general_ci ");
                                } else {
                                        // Match the quoted term in result highlighting...
                                        $terms[2] = str_replace( '"', '', $terms[2] );
                                        $regexp = preg_quote( $terms[2], '/' );
                                        $terms[2] = str_replace( '\'', '\\\'', $terms[2] );
                                        if ( !empty( $searchon ) ) { $searchon .= ' AND '; }
                                        if ( $terms[1] == '-' ) { $searchon .= ' NOT '; }
                                        $searchon .= (" $field LIKE '%" . $terms[2] . "%' COLLATE utf8_general_ci ");
                                }
                                $this->searchTerms[] = $regexp;
                        }
                        wfDebug( "Would search with '$searchon'\n" );
                        wfDebug( 'Match with /' . implode( '|', $this->searchTerms ) . "/\n" );
                } else {
                        wfDebug( "Can't understand search query '{$filteredText}'\n" );
                }

                if ( empty( $searchon ) ) { $searchon = ' FALSE '; } /* dummy */
                return $searchon;
        }

        /**
         * Picks which field to index on, depending on what type of query.
         * @param bool $fulltext
         * @return string
         */
        function getIndexField( $fulltext ) {
                return $fulltext ? 'old_text' : 'page_title';
        }

        /**
         * Get the base part of the search query.
         * The actual match syntax will depend on the server
         * version; MySQL 3 and MySQL 4 have different capabilities
         * in their fulltext search indexes.
         *
         * @param string $filteredTerm
         * @param bool $fulltext
         * @return string
         * @private
         */
        function queryMain( $filteredTerm, $fulltext ) {
                $match = $this->parseQuery( $filteredTerm, $fulltext );
                $page        = $this->db->tableName( 'page' );
                $text        = $this->db->tableName( 'text' );
                $revision    = $this->db->tableName( 'revision' );
                return 'SELECT page_id, page_namespace, page_title ' .
                        "FROM $page,$text,$revision " .
                        'WHERE old_id=rev_text_id AND rev_page=page_id AND page_latest=rev_id AND ' . $match;
        }

}
?>
