//
//  FJNContainableWindowController.h
//  FJNCoreData
//
//  Created by FUJIDANA on 06/08/17.
//  Copyright 2006-2008 FUJIDANA. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "FJNPersistentWindowController.h"
#import "FJNContentArrayController.h"
#import "FJNContainerArrayController.h"

extern NSString *FJNContainableToolbarNewIdentifier;
extern NSString *FJNContainableToolbarNewContentIdentifier;
extern NSString *FJNContainableToolbarNewContainerIdentifier;
extern NSString *FJNContainableToolbarDeleteIdentifier;
extern NSString *FJNContainableToolbarDeleteContentIdentifier;
extern NSString *FJNContainableToolbarDeleteContainerIdentifier;
extern NSString *FJNContainableToolbarPreviousIdentifier;
extern NSString *FJNContainableToolbarPreviousContentIdentifier;
extern NSString *FJNContainableToolbarPreviousContainerIdentifier;
extern NSString *FJNContainableToolbarNextIdentifier;
extern NSString *FJNContainableToolbarNextContentIdentifier;
extern NSString *FJNContainableToolbarNextContainerIdentifier;
extern NSString *FJNContainableToolbarDeselectSortIdentifier;
extern NSString *FJNContainableToolbarSearchContentIdentifier;

extern NSString *FJNIndexableToolbarReindexSelectionIdentifier;


@interface FJNContainableWindowController : FJNPersistentWindowController
{
@private
	IBOutlet NSSearchField *searchField;
	IBOutlet FJNContentArrayController *contentArrayController;
	IBOutlet FJNContainerArrayController *containerArrayController;
}

#pragma mark Accessor methods
- (FJNContentArrayController *)contentArrayController;
- (FJNContainerArrayController *)containerArrayController;

#pragma mark Other public methods
- (BOOL)setSelectedObject:(NSManagedObject *)object;

#pragma mark Methods to set up toolbar
- (void)setupToolbarWithIdentifier:(NSString *)identifier;

#pragma mark Methods delegated by NSToolbar
- (NSToolbarItem *)toolbar:(NSToolbar *)toolbar itemForItemIdentifier:(NSString *)itemIdentifier willBeInsertedIntoToolbar:(BOOL)flag;
- (NSArray *)toolbarDefaultItemIdentifiers:(NSToolbar *)toolbar;
- (NSArray *)toolbarAllowedItemIdentifiers:(NSToolbar *)toolbar;
- (void)toolbarDidRemoveItem:(NSNotification *)notification;

#pragma mark Methods implementing NSUserInterfaceValidations protocol
- (BOOL)validateUserInterfaceItem:(id <NSValidatedUserInterfaceItem>)theItem;

#pragma mark Action methods
- (IBAction)insert:(id)sender;
- (IBAction)remove:(id)sender;
- (IBAction)selectPrevious:(id)sender;
- (IBAction)selectNext:(id)sender;
- (IBAction)deselectSort:(id)sender;
- (IBAction)find:(id)sender;
- (IBAction)clearPredicate:(id)sender;

@end
