//
//  $Id: NSString_FJNMIME.m 84 2008-03-18 13:25:05Z fujidana $
//
//  Copyright (c) 2006-2008 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. Neither the name of the author nor the names of its contributors
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "NSString_FJNMIME.h"
#import "GSNSDataExtensions.h"


@implementation NSString (FJNMIME)

+ (NSString *)IANACharSetNameOfStringEncoding:(NSStringEncoding)encoding
{
	return (NSString *)CFStringConvertEncodingToIANACharSetName(CFStringConvertNSStringEncodingToEncoding(encoding));
}

+ (NSStringEncoding)stringEncodiingOfIANACharSetName:(NSString *)charSetName
{
	return CFStringConvertEncodingToNSStringEncoding(CFStringConvertIANACharSetNameToEncoding((CFStringRef)charSetName));
}

- (NSData *)dataUsingBase64Decoding
{
	return [NSData dataWithBase64EncodedString:self];
}

- (NSData *)dataUsingQuotedPrintableDecoding
{
	NSData *qData = [self dataUsingEncoding:NSASCIIStringEncoding];
	if (qData == nil) return nil;
	
	const char *originalBytes = [qData bytes];
	unsigned originalLength = [qData length];
	
	char convertedBytes[originalLength];
	unsigned convertedLength = 0;
	
	char hexBuffer[3];
	unsigned hexValue;
	hexBuffer[2] = '\0';
	
	int i;
	for (i = 0; i < originalLength; i++)
	{
		if (originalBytes[i] == '=')
		{
			if (i + 2 >= originalLength) return nil;
			
			hexBuffer[0] = originalBytes[i + 1];
			hexBuffer[1] = originalBytes[i + 2];
			sscanf(hexBuffer, "%x", &hexValue);
			convertedBytes[convertedLength++] = (char)hexValue;
			i += 2;
		}
		else
		{
			convertedBytes[convertedLength++] = originalBytes[i];
		}
	}
	return [NSData dataWithBytes:convertedBytes length:convertedLength];
}

- (NSString *)stringByDecodingRFC2047MessageHeader
{
	NSScanner *scanner = [NSScanner scannerWithString:self];
	[scanner setCaseSensitive:NO];
	
	NSMutableString *result = [NSMutableString string];
	
	NSString *tempString;
	BOOL isScannerInEncodedString = NO;
	
	while ([scanner isAtEnd] == NO)
	{
		if (isScannerInEncodedString == NO)
		{
			if ([scanner scanUpToString:@"=?" intoString:&tempString])
			{
				[result appendString:tempString];
			}
			if ([scanner scanString:@"=?" intoString:NULL])
			{
				isScannerInEncodedString = YES;
			}
		}
		else
		{
			if ([scanner scanUpToString:@"?=" intoString:&tempString] &&
				[scanner scanString:@"?=" intoString:NULL])
			{
				NSArray *tempArray = [tempString componentsSeparatedByString:@"?"];
				if ([tempArray count] != 3) return nil;
				
				NSStringEncoding encoding = [NSString stringEncodiingOfIANACharSetName:[tempArray objectAtIndex:0]];
				if (encoding == 0) return nil;
				
				NSString *decodedString;
				if ([[tempArray objectAtIndex:1] caseInsensitiveCompare:@"B"] == NSOrderedSame)
				{
					NSData *data = [[tempArray objectAtIndex:2] dataUsingBase64Decoding];
					if (data == nil) return nil;
					decodedString = [[[NSString alloc] initWithData:data encoding:encoding] autorelease];
					if (decodedString == nil) return nil;
				}
				else if ([[tempArray objectAtIndex:1] caseInsensitiveCompare:@"Q"] == NSOrderedSame)
				{
					NSData *data = [[tempArray objectAtIndex:2] dataUsingQuotedPrintableDecoding];
					if (data == nil) return nil;
					decodedString = [[[NSString alloc] initWithData:data encoding:encoding] autorelease];
					if (decodedString == nil) return nil;
				}
				else
				{
					return nil;
				}
				[result appendString:decodedString];
				isScannerInEncodedString = NO;
			}
			else
			{
				// NSLog(@"ERROR! Not closed by ?=.");
				return nil;
			}
		}
	}
	return [NSString stringWithString:result];
}

@end
