//
//  FJNCoreDataAppDelegate.m
//  FJNCoreData
//
//  Created by FUJIDANA on 06/08/17.
//  Copyright 2006-2008 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "FJNCoreDataAppDelegate.h"
#import "FJNPersistentWindowController.h"


@implementation FJNCoreDataAppDelegate

#pragma mark Methods delegated by NSApplication

- (NSApplicationTerminateReply)applicationShouldTerminate:(NSApplication *)sender
{
	NSEnumerator *enumerator = [[sender windows] objectEnumerator];
	NSWindow *window;
	NSMutableArray *failedToSaveControllers = [NSMutableArray array];
	
	// try to save all managed object context belong to FJNPersistentWindowControllers.
	// Controllers which failed to store their context are listed in "failedToSaveControllers" array.
	while (window = [enumerator nextObject])
	{
		NSWindowController *windowController = [window windowController];
		if (windowController && [windowController isKindOfClass:[FJNPersistentWindowController class]])
		{
			NSManagedObjectContext *context = [(FJNPersistentWindowController *)windowController managedObjectContext];
			if (context == nil) continue;
			if ([context commitEditing] == NO) return NSTerminateCancel;
			
			if ([context hasChanges] && [context save:NULL] == NO)
			{
				[failedToSaveControllers addObject:windowController];
			}
		}
	}
	
    NSApplicationTerminateReply reply;
	
	if ([failedToSaveControllers count] == 0)
	{
		reply = NSTerminateNow;
	}
	else if ([failedToSaveControllers count] == 1)
		reply = NSTerminateLater;
	else
	{
		NSAlert *alert =[[[NSAlert alloc] init] autorelease];
		NSString *message = [NSString stringWithFormat:NSLocalizedStringFromTable(@"You have %d windows with invalid properties found. Do you want to review these errors before quitting?", @"CoreDataLocalizable", @"applicationTerminateAlert.message"), [failedToSaveControllers count]];
		[alert setMessageText:message];
		[alert setAlertStyle:NSWarningAlertStyle];
		[alert setInformativeText:NSLocalizedStringFromTable(@"If you don’t review the errors in your windows, all your changes will be lost.", @"CoreDataLocalizable", @"applicationTerminateAlert.information")];
		[alert addButtonWithTitle:NSLocalizedStringFromTable(@"Review Errors...", @"CoreDataLocalizable", @"applicationTerminateAlert.reviewErrorsButton")];
		[alert addButtonWithTitle:NSLocalizedStringFromTable(@"Cancel", @"CoreDataLocalizable", @"alert.cancelButton")];
		[alert addButtonWithTitle:NSLocalizedStringFromTable(@"Discard Changes", @"CoreDataLocalizable", @"applicationTerminateAlert.discardChangesButton")];
		int result = [alert runModal];
		
		if (result == NSAlertFirstButtonReturn) reply = NSTerminateLater;
		else if (result == NSAlertSecondButtonReturn) reply = NSTerminateCancel;
		else reply = NSTerminateNow;
	}
	
	if (reply == NSTerminateLater)
	{
		[FJNPersistentWindowController reviewChangesAndQuitEnumeration:YES];
	}
	
	return reply;
}

@end
