//
//  IndexableWindowController.m
//  FJNCoreData
//
//  Created by FUJIDANA on 06/08/17.
//  Copyright 2006-2008 FUJIDANA. All rights reserved.
//

#import "IndexableWindowController.h"
#import "FJNContainerArrayController.h"
#import "FJNContentArrayController.h"


@implementation IndexableWindowController

- (id)init
{
	self = [super initWithWindowNibName:@"IndexableWindow"
						 storeDirectory:@"FJNCoreData"
							   filename:@"Indexable.xml"
								   type:NSXMLStoreType];
	if (self != nil)
	{
		[self window];
		[self setupToolbarWithIdentifier:@"FJNIndexableDemoToolbar"];
		[self showWindow:nil];
		[[self containerArrayController] setConditionallyHidesContainerColumnInContentTableView:YES];
		[[self containerArrayController] setSupportsDragAndDrop:YES];
		[[self contentArrayController] setSupportsDragAndDrop:YES];
//		[[[self window] toolbar] setShowsBaselineSeparator:NO];
	}
	return self;
}

- (void)windowDidLoad
{
	[super windowDidLoad];
	[[self contentArrayController] setLocalizedEntityName:NSLocalizedString(@"child item", nil)];
	[[self containerArrayController] setLocalizedEntityName:NSLocalizedString(@"parent item", nil)];
}

- (NSArray *)toolbarAllowedItemIdentifiers:(NSToolbar *)toolbar
{
	return [[super toolbarAllowedItemIdentifiers:toolbar] arrayByAddingObject:FJNIndexableToolbarReindexSelectionIdentifier];
}

- (NSArray *)toolbarDefaultItemIdentifiers:(NSToolbar *)toolbar
{
	return [NSArray arrayWithObjects:
		FJNContainableToolbarNewIdentifier,
		FJNContainableToolbarDeleteIdentifier,
		NSToolbarSeparatorItemIdentifier,
		FJNContainableToolbarPreviousIdentifier,
		FJNContainableToolbarNextIdentifier,
		NSToolbarSeparatorItemIdentifier,
		FJNContainableToolbarDeselectSortIdentifier,
		FJNIndexableToolbarReindexSelectionIdentifier,
		NSToolbarFlexibleSpaceItemIdentifier,
		FJNContainableToolbarSearchContentIdentifier,
		nil];
}

@end
