//
//  FJNContainableWindowController.m
//  FJNCoreData
//
//  Created by FUJIDANA on 06/08/17.
//  Copyright 2006-2008 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "FJNContainableWindowController.h"
#import "FJNContainerArrayController.h"
#import "FJNContentArrayController.h"


NSString *FJNContainableToolbarNewIdentifier               = @"FJNContainableToolbarNewIdentifier";
NSString *FJNContainableToolbarNewContentIdentifier        = @"FJNContainableToolbarNewContentIdentifier";
NSString *FJNContainableToolbarNewContainerIdentifier      = @"FJNContainableToolbarNewContainerIdentifier";
NSString *FJNContainableToolbarDeleteIdentifier            = @"FJNContainableToolbarDeleteIdentifier";
NSString *FJNContainableToolbarDeleteContentIdentifier     = @"FJNContainableToolbarDeleteContentIdentifier";
NSString *FJNContainableToolbarDeleteContainerIdentifier   = @"FJNContainableToolbarDeleteContainerIdentifier";
NSString *FJNContainableToolbarPreviousIdentifier          = @"FJNContainableToolbarPreviousIdentifier";
NSString *FJNContainableToolbarPreviousContentIdentifier   = @"FJNContainableToolbarPreviousContentIdentifier";
NSString *FJNContainableToolbarPreviousContainerIdentifier = @"FJNContainableToolbarPreviousContainerIdentifier";
NSString *FJNContainableToolbarNextIdentifier              = @"FJNContainableToolbarNextIdentifier";
NSString *FJNContainableToolbarNextContentIdentifier       = @"FJNContainableToolbarNextContentIdentifier";
NSString *FJNContainableToolbarNextContainerIdentifier     = @"FJNContainableToolbarNextContainerIdentifier";
NSString *FJNContainableToolbarDeselectSortIdentifier      = @"FJNContainableToolbarDeselectSortIdentifier";
NSString *FJNContainableToolbarSearchContentIdentifier     = @"FJNContainableToolbarSearchContentIdentifier";

NSString *FJNIndexableToolbarReindexSelectionIdentifier    = @"FJNIndexableToolbarReindexSelectionIdentifier";


@interface NSImage (FJNUnion)

+ (id)unitedImageWithImageName:(NSString *)baseImageName andImageName:(NSString *)frontImageName;
+ (id)unitedImageWithImage:(NSImage *)baseImage andImage:(NSImage *)frontImage;

@end


#pragma mark -


@implementation FJNContainableWindowController

#pragma mark Methods overriding superclass

#pragma mark Accessor methods
- (FJNContentArrayController *)contentArrayController
{
	return contentArrayController;
}

- (FJNContainerArrayController *)containerArrayController
{
	return containerArrayController;
}

#pragma mark Other public methods

- (BOOL)setSelectedObject:(NSManagedObject *)object
{
	if ([[[object entity] name] isEqual:[contentArrayController entityName]])
	{
		[contentArrayController setFilterPredicate:nil];
		NSManagedObject *container = [object valueForKey:@"container"];
		if (container)
		{
			[containerArrayController setSelectedObjects:[NSArray arrayWithObject:container]];
		}
		[[self window] makeFirstResponder:[contentArrayController tableView]];
		return [contentArrayController setSelectedObjects:[NSArray arrayWithObject:object]];
	}
	return NO;
}

#pragma mark Methods to set up toolbar

// --- set up toolbar. subclass may invoke this method in windowDidLoad: if toolbar is needed. ---

- (void)setupToolbarWithIdentifier:(NSString *)identifier
{
	NSToolbar *toolbar = [[NSToolbar alloc] initWithIdentifier:identifier];
    [toolbar setAllowsUserCustomization:YES];
    [toolbar setAutosavesConfiguration:YES];
    [toolbar setDisplayMode:NSToolbarDisplayModeDefault];
	[toolbar setDelegate:self];
	[[self window] setToolbar:toolbar];
	[toolbar release];
}

#pragma mark Methods delegated by NSToolbar

- (NSToolbarItem *)toolbar:(NSToolbar *)toolbar itemForItemIdentifier:(NSString *)itemIdentifier willBeInsertedIntoToolbar:(BOOL)flag
{
	NSToolbarItem *toolbarItem = [[[NSToolbarItem alloc] initWithItemIdentifier:itemIdentifier] autorelease];
	NSString *label, *paletteLabel, *toolTip;
	
	if ([itemIdentifier isEqual:FJNContainableToolbarNewIdentifier])
	{
		// --- New ---
		label = NSLocalizedStringFromTable(@"New", @"CoreDataLocalizable", @"toolbarItem.newFolder.label");
		paletteLabel = NSLocalizedStringFromTable(@"New", @"CoreDataLocalizable", @"toolbarItem.newFolder.paletteLabel");
		toolTip = NSLocalizedStringFromTable(@"Add New", @"CoreDataLocalizable", @"toolbarItem.newFolder.toolTip");
		[toolbarItem setLabel:label];
		[toolbarItem setPaletteLabel:paletteLabel];
		[toolbarItem setToolTip:toolTip];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarNewIcon.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(insert:)];
	}
	else if ([itemIdentifier isEqual:FJNContainableToolbarNewContentIdentifier])
	{
		// --- New Item --- 
		NSString *name = [[contentArrayController localizedEntityName] capitalizedString];
		label = [NSString stringWithFormat:NSLocalizedStringFromTable(@"New %@", @"CoreDataLocalizable", @"toolbarItem.newItem.label"), name];
		paletteLabel = [NSString stringWithFormat:NSLocalizedStringFromTable(@"New %@", @"CoreDataLocalizable", @"toolbarItem.newItem.paletteLabel"), name];
		toolTip = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Add New %@", @"CoreDataLocalizable", @"toolbarItem.newItem.toolTip"), name];
		[toolbarItem setLabel:label];
		[toolbarItem setPaletteLabel:paletteLabel];
		[toolbarItem setToolTip:toolTip];
		[toolbarItem setImage:[NSImage unitedImageWithImageName:[contentArrayController entityImageName] andImageName:@"ToolbarNewBadgeIcon.tiff" ]];
		[toolbarItem setTarget:contentArrayController];
		[toolbarItem setAction:@selector(insert:)];
	}
	else if ([itemIdentifier isEqual:FJNContainableToolbarNewContainerIdentifier])
	{
		// --- New Folder ---
		NSString *name = [[containerArrayController localizedEntityName] capitalizedString];
		label = [NSString stringWithFormat:NSLocalizedStringFromTable(@"New %@", @"CoreDataLocalizable", @"toolbarItem.newFolder.label"), name];
		paletteLabel = [NSString stringWithFormat:NSLocalizedStringFromTable(@"New %@", @"CoreDataLocalizable", @"toolbarItem.newFolder.paletteLabel"), name];
		toolTip = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Add New %@", @"CoreDataLocalizable", @"toolbarItem.newFolder.toolTip"), name];
		[toolbarItem setLabel:label];
		[toolbarItem setPaletteLabel:paletteLabel];
		[toolbarItem setToolTip:toolTip];
		[toolbarItem setImage:[NSImage unitedImageWithImageName:[containerArrayController entityImageName] andImageName:@"ToolbarNewBadgeIcon.tiff" ]];
		[toolbarItem setTarget:containerArrayController];
		[toolbarItem setAction:@selector(insert:)];
	}
	else if ([itemIdentifier isEqual:FJNContainableToolbarDeleteIdentifier])
	{
		//  --- Remove ---
		label = NSLocalizedStringFromTable(@"Delete", @"CoreDataLocalizable", @"toolbarItem.delete.label");
		paletteLabel = NSLocalizedStringFromTable(@"Delete", @"CoreDataLocalizable", @"toolbarItem.delete.paletteLabel");
		toolTip = NSLocalizedStringFromTable(@"Delete Selection", @"CoreDataLocalizable", @"toolbarItem.deleteItem.toolTip");
		[toolbarItem setLabel:label];
		[toolbarItem setPaletteLabel:paletteLabel];
		[toolbarItem setToolTip:toolTip];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarDeleteIcon.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(remove:)];
	
	}
	else if ([itemIdentifier isEqual:FJNContainableToolbarDeleteContentIdentifier])
	{
		// --- Remove Item ---
		NSString *name = [[contentArrayController localizedEntityName] capitalizedString];
		label = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Delete %@", @"CoreDataLocalizable", @"toolbarItem.deleteItem.label"), name];
		paletteLabel = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Delete %@", @"CoreDataLocalizable", @"toolbarItem.deleteItem.paletteLabel"), name];
		toolTip = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Delete Selected %@", @"CoreDataLocalizable", @"toolbarItem.deleteItem.toolTip"), name];
		[toolbarItem setLabel:label];
		[toolbarItem setPaletteLabel:paletteLabel];
		[toolbarItem setToolTip:toolTip];
		[toolbarItem setImage:[NSImage unitedImageWithImageName:[contentArrayController entityImageName] andImageName:@"ToolbarDeleteIcon.tiff" ]];
		[toolbarItem setTarget:contentArrayController];
		[toolbarItem setAction:@selector(remove:)];
	}
	else if ([itemIdentifier isEqual:FJNContainableToolbarDeleteContainerIdentifier])
	{
		// --- Remove Folder ---
		NSString *name = [[containerArrayController localizedEntityName] capitalizedString];
		label = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Delete %@", @"CoreDataLocalizable", @"toolbarItem.deleteFolder.label"), name];
		paletteLabel = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Delete %@", @"CoreDataLocalizable", @"toolbarItem.deleteItem.paletteLabel"), name];
		toolTip = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Delete Selected %@", @"CoreDataLocalizable", @"toolbarItem.deleteItem.toolTip"), name];
		[toolbarItem setLabel:label];
		[toolbarItem setPaletteLabel:paletteLabel];
		[toolbarItem setToolTip:toolTip];
		[toolbarItem setImage:[NSImage unitedImageWithImageName:[containerArrayController entityImageName] andImageName:@"ToolbarDeleteIcon.tiff" ]];
		[toolbarItem setTarget:containerArrayController];
		[toolbarItem setAction:@selector(remove:)];
	}
	else if ([itemIdentifier isEqual:FJNContainableToolbarPreviousIdentifier])
	{
		// --- Select Previous  ---
		label = NSLocalizedStringFromTable(@"Previous", @"CoreDataLocalizable", @"toolbarItem.selectPrevious.label");
		paletteLabel = NSLocalizedStringFromTable(@"Previous", @"CoreDataLocalizable", @"toolbarItem.selectPrevious.paletteLabel");
		toolTip = NSLocalizedStringFromTable(@"Select Previous", @"CoreDataLocalizable", @"toolbarItem.selectPrevious.toolTip");
		[toolbarItem setLabel:label];
		[toolbarItem setPaletteLabel:paletteLabel];
		[toolbarItem setToolTip:toolTip];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarSelectPreviousIcon.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(selectPrevious:)];
	}
	else if ([itemIdentifier isEqual:FJNContainableToolbarPreviousContentIdentifier])
	{
		// --- Select Previous Item ---
		NSString *name = [[contentArrayController localizedEntityName] capitalizedString];
		label = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Previous %@", @"CoreDataLocalizable", @"toolbarItem.selectPreviousItem.label"), name];
		paletteLabel = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Previous %@", @"CoreDataLocalizable", @"toolbarItem.selectPreviousItem.paletteLabel"), name];
		toolTip = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Select Previous %@", @"CoreDataLocalizable", @"toolbarItem.selectPreviousItem.toolTip"), name];
		[toolbarItem setLabel:label];
		[toolbarItem setPaletteLabel:paletteLabel];
		[toolbarItem setToolTip:toolTip];
		[toolbarItem setImage:[NSImage unitedImageWithImageName:[contentArrayController entityImageName] andImageName:@"ToolbarSelectPreviousBadgeIcon.tiff" ]];
		[toolbarItem setTarget:contentArrayController];
		[toolbarItem setAction:@selector(selectPrevious:)];
	}
	else if ([itemIdentifier isEqual:FJNContainableToolbarPreviousContainerIdentifier])
	{
		// --- Select Previous Folder ---
		NSString *name = [[containerArrayController localizedEntityName] capitalizedString];
		label = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Previous %@", @"CoreDataLocalizable", @"toolbarItem.selectPreviousFolder.label"), name];
		paletteLabel = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Previous %@", @"CoreDataLocalizable", @"toolbarItem.selectPreviousFolder.paletteLabel"), name];
		toolTip = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Select Previous %@", @"CoreDataLocalizable", @"toolbarItem.selectPreviousFolder.toolTip"), name];
		[toolbarItem setLabel:label];
		[toolbarItem setPaletteLabel:paletteLabel];
		[toolbarItem setToolTip:toolTip];
		[toolbarItem setImage:[NSImage unitedImageWithImageName:[containerArrayController entityImageName] andImageName:@"ToolbarSelectPreviousBadgeIcon.tiff" ]];
		[toolbarItem setTarget:containerArrayController];
		[toolbarItem setAction:@selector(selectPrevious:)];
	}
	else if ([itemIdentifier isEqual:FJNContainableToolbarNextIdentifier])
	{
		// --- Select Next ---
		label = NSLocalizedStringFromTable(@"Next", @"CoreDataLocalizable", @"toolbarItem.selectNext.label");
		paletteLabel = NSLocalizedStringFromTable(@"Next", @"CoreDataLocalizable", @"toolbarItem.selectNext.paletteLabel");
		toolTip = NSLocalizedStringFromTable(@"Select Next", @"CoreDataLocalizable", @"toolbarItem.selectNext.toolTip");
		[toolbarItem setLabel:label];
		[toolbarItem setPaletteLabel:paletteLabel];
		[toolbarItem setToolTip:toolTip];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarSelectNextIcon.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(selectNext:)];
	}
	else if ([itemIdentifier isEqual:FJNContainableToolbarNextContentIdentifier])
	{
		// --- Select Next Item ---
		NSString *name = [[contentArrayController localizedEntityName] capitalizedString];
		label = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Next %@", @"CoreDataLocalizable", @"toolbarItem.selectNextItem.label"), name];
		paletteLabel = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Next %@", @"CoreDataLocalizable", @"toolbarItem.selectNextItem.paletteLabel"), name];
		toolTip = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Select Next %@", @"CoreDataLocalizable", @"toolbarItem.selectNextItem.toolTip"), name];
		[toolbarItem setLabel:label];
		[toolbarItem setPaletteLabel:paletteLabel];
		[toolbarItem setToolTip:toolTip];
		[toolbarItem setImage:[NSImage unitedImageWithImageName:[contentArrayController entityImageName] andImageName:@"ToolbarSelectNextBadgeIcon.tiff" ]];
		[toolbarItem setTarget:contentArrayController];
		[toolbarItem setAction:@selector(selectNext:)];
	}
	else if ([itemIdentifier isEqual:FJNContainableToolbarNextContainerIdentifier])
	{
		// --- Select Next Folder ---
		NSString *name = [[containerArrayController localizedEntityName] capitalizedString];
		label = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Next %@", @"CoreDataLocalizable", @"toolbarItem.selectNextFolder.label"), name];
		paletteLabel = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Next %@", @"CoreDataLocalizable", @"toolbarItem.selectNextFolder.paletteLabel"), name];
		toolTip = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Select Next %@", @"CoreDataLocalizable", @"toolbarItem.selectNextFolder.toolTip"), name];
		[toolbarItem setLabel:label];
		[toolbarItem setPaletteLabel:paletteLabel];
		[toolbarItem setToolTip:toolTip];
		[toolbarItem setImage:[NSImage unitedImageWithImageName:[containerArrayController entityImageName] andImageName:@"ToolbarSelectNextBadgeIcon.tiff" ]];
		[toolbarItem setTarget:containerArrayController];
		[toolbarItem setAction:@selector(selectNext:)];
	}
	else if ([itemIdentifier isEqual:FJNContainableToolbarDeselectSortIdentifier])
	{
		// Deselect sort
		label = NSLocalizedStringFromTable(@"Deselect Sort", @"CoreDataLocalizable", @"toolbarItem.deselectSort.label");
		paletteLabel = NSLocalizedStringFromTable(@"Deselect Sort", @"CoreDataLocalizable", @"toolbarItem.deselectSort.paletteLabel");
		toolTip = NSLocalizedStringFromTable(@"Revert Sort Order to Default Settings", @"CoreDataLocalizable", @"toolbarItem.deselectSort.toolTip");
		[toolbarItem setLabel:label];
		[toolbarItem setPaletteLabel:paletteLabel];
		[toolbarItem setToolTip:toolTip];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarDeselectSortIcon.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(deselectSort:)];
	}
	else if ([itemIdentifier isEqual:FJNContainableToolbarSearchContentIdentifier])
	{
		// Search
		[toolbarItem setLabel:NSLocalizedStringFromTable(@"Search", @"CoreDataLocalizable", @"toolbar.search.label")];
		[toolbarItem setPaletteLabel:NSLocalizedStringFromTable(@"Search", @"CoreDataLocalizable", @"toolbar.search.paletteLabel")];
		[toolbarItem setToolTip:NSLocalizedStringFromTable(@"Show Only Items Containing String Specified", @"CoreDataLocalizable", @"toolbar.search.toolTip")];
		[toolbarItem setView:searchField];
		[toolbarItem setMinSize:NSMakeSize(60, NSHeight([searchField frame]))];
		[toolbarItem setMaxSize:NSMakeSize(210, NSHeight([searchField frame]))];
		[toolbarItem setVisibilityPriority:NSToolbarItemVisibilityPriorityHigh];
		
		NSMenuItem *menuItem = [[NSMenuItem alloc] initWithTitle:NSLocalizedStringFromTable(@"Clear Search", @"CoreDataLocalizable", @"toolbar.search.menuRepresentationTitle") 
														  action:@selector(clearPredicate:)
												   keyEquivalent:@""];
		[toolbarItem setMenuFormRepresentation:menuItem];
		[menuItem autorelease];
	}
	else if ([itemIdentifier isEqual:FJNIndexableToolbarReindexSelectionIdentifier])
	{
		// --- Reindex Selection ---
		label = NSLocalizedStringFromTable(@"Reindex", @"CoreDataLocalizable", @"toolbarItem.reindexSelection.label");
		paletteLabel = NSLocalizedStringFromTable(@"Reindex Selection", @"CoreDataLocalizable", @"toolbarItem.reindexSelection.paletteLabel");
		toolTip = [NSString stringWithFormat:NSLocalizedStringFromTable(@"Reindex Number of Selected %@.", @"CoreDataLocalizable", @"toolbarItem.reindexSelection.toolTip"), [[contentArrayController localizedEntityName] capitalizedString]];
		[toolbarItem setLabel:label];
		[toolbarItem setPaletteLabel:paletteLabel];
		[toolbarItem setToolTip:toolTip];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarReindexSelectionIcon.tiff"]];
		[toolbarItem setTarget:contentArrayController];
		[toolbarItem setAction:@selector(reindexSelection:)];
	}
	else
	{
		toolbarItem = nil;
	}
	return toolbarItem;
}

- (NSArray *)toolbarDefaultItemIdentifiers:(NSToolbar *)toolbar
{
	return [NSArray arrayWithObjects:FJNContainableToolbarNewContentIdentifier,
			FJNContainableToolbarNewContainerIdentifier,
			FJNContainableToolbarDeleteIdentifier,
			NSToolbarSeparatorItemIdentifier,
			FJNContainableToolbarPreviousContentIdentifier,
			FJNContainableToolbarNextContentIdentifier,
			FJNContainableToolbarPreviousContainerIdentifier,
			FJNContainableToolbarNextContainerIdentifier,
			NSToolbarSeparatorItemIdentifier,
			FJNContainableToolbarDeselectSortIdentifier,
			NSToolbarFlexibleSpaceItemIdentifier,
			FJNContainableToolbarSearchContentIdentifier,
			nil];
}

- (NSArray *)toolbarAllowedItemIdentifiers:(NSToolbar *)toolbar
{
	return [NSArray arrayWithObjects:FJNContainableToolbarNewContentIdentifier,
			FJNContainableToolbarNewContainerIdentifier,
			FJNContainableToolbarNewIdentifier,
			FJNContainableToolbarDeleteContentIdentifier,
			FJNContainableToolbarDeleteContainerIdentifier,
			FJNContainableToolbarDeleteIdentifier,
			FJNContainableToolbarPreviousContentIdentifier,
			FJNContainableToolbarNextContentIdentifier,
			FJNContainableToolbarPreviousContainerIdentifier,
			FJNContainableToolbarNextContainerIdentifier,
			FJNContainableToolbarPreviousIdentifier,
			FJNContainableToolbarNextIdentifier,
			FJNContainableToolbarDeselectSortIdentifier,
			FJNContainableToolbarSearchContentIdentifier,
			NSToolbarSeparatorItemIdentifier,
			NSToolbarFlexibleSpaceItemIdentifier,
			NSToolbarSpaceItemIdentifier,
			nil];
}

- (void)toolbarDidRemoveItem:(NSNotification *)notification
{
	NSToolbarItem *removedItem = [[notification userInfo] objectForKey:@"item"];
	if ([[removedItem itemIdentifier] isEqual:FJNContainableToolbarSearchContentIdentifier])
	{
		// If ``search'' toolbar item is removed, clear search word.
		[self clearPredicate:nil];
	}
}

#pragma mark Methods implementing NSUserInterfaceValidations protocol

- (BOOL)validateUserInterfaceItem:(id <NSValidatedUserInterfaceItem>)theItem
{
	if ([theItem action] == @selector(insert:) ||
		[theItem action] == @selector(remove:) ||
		[theItem action] == @selector(selectPrevious:) ||
		[theItem action] == @selector(selectNext:) ||
		[theItem action] == @selector(deselectSort:))
	{
		NSResponder *firstResponder = [[self window] firstResponder];
		if (firstResponder == [contentArrayController tableView])
		{
			return [contentArrayController validateUserInterfaceItem:theItem];
		}
		else if (firstResponder == [containerArrayController tableView])
		{
			return [containerArrayController validateUserInterfaceItem:theItem];
		}
		return NO;
	}
	else if ([theItem action] == @selector(clearPredicate:))
	{
		return ([[searchField stringValue] isEqualToString:@""] == NO);
	}
	return [super validateUserInterfaceItem:theItem];
}

#pragma mark Action mehtods

- (IBAction)insert:(id)sender
{
	NSResponder *firstResponder = [[self window] firstResponder];
	if (firstResponder == [contentArrayController tableView])
		[contentArrayController insert:sender];
	else if (firstResponder == [containerArrayController tableView])
		[containerArrayController insert:sender];
}

- (IBAction)remove:(id)sender
{
	NSResponder *firstResponder = [[self window] firstResponder];
	if (firstResponder == [contentArrayController tableView])
		[contentArrayController remove:sender];
	else if (firstResponder == [containerArrayController tableView])
		[containerArrayController remove:sender];
}

- (IBAction)selectPrevious:(id)sender
{
	NSResponder *firstResponder = [[self window] firstResponder];
	if (firstResponder == [contentArrayController tableView])
		[contentArrayController selectPrevious:sender];
	else if (firstResponder == [containerArrayController tableView])
		[containerArrayController selectPrevious:sender];
}

- (IBAction)selectNext:(id)sender
{
	NSResponder *firstResponder = [[self window] firstResponder];
	if (firstResponder == [contentArrayController tableView])
		[contentArrayController selectNext:sender];
	else if (firstResponder == [containerArrayController tableView])
		[containerArrayController selectNext:sender];
}

- (IBAction)deselectSort:(id)sender
{
	NSResponder *firstResponder = [[self window] firstResponder];
	if (firstResponder == [contentArrayController tableView])
		[contentArrayController deselectSort:sender];
	else if (firstResponder == [containerArrayController tableView])
		[containerArrayController deselectSort:sender];
}

- (IBAction)find:(id)sender
{
	[[self window] makeKeyAndOrderFront:sender];
	[[self window] makeFirstResponder:searchField];
}

- (IBAction)clearPredicate:(id)sender
{
	[searchField setStringValue:@""];
	[searchField performClick:sender];
}

@end


#pragma mark -


@implementation NSImage (FJNUnion)

+ (id)unitedImageWithImageName:(NSString *)baseImageName andImageName:(NSString *)frontImageName
{
	return [NSImage unitedImageWithImage:[NSImage imageNamed:baseImageName] andImage:[NSImage imageNamed:frontImageName]];
}

+ (id)unitedImageWithImage:(NSImage *)baseImage andImage:(NSImage *)frontImage
{
	if (baseImage == nil) return nil;
	
	NSImage *image = [[[NSImage alloc] initWithSize:[baseImage size]] autorelease];
	[image lockFocus];
	[baseImage drawAtPoint:NSZeroPoint fromRect:NSZeroRect operation:NSCompositeCopy fraction:1.0];
	[frontImage drawAtPoint:NSZeroPoint fromRect:NSZeroRect operation:NSCompositeSourceOver fraction:1.0];
	[image unlockFocus];
	
//	NSLog(@"%@ : %@", [baseImage name], [frontImage name]);
	
	return image;
}

@end
