//
//  ICSCalendarItem.m
//  iCal to KS2
//
//  Created by FUJIDANA on 05/05/11.
//  Copyright 2005 FUJIDANA. All rights reserved.
//
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "ICSCalendarItem.h"

@implementation ICSCalendarItem

#pragma mark class methods
+ (NSDictionary *)dictionaryWithRFC2425Representation:(NSString *)string
{
	NSScanner *scanner = [NSScanner scannerWithString:string];
	[scanner setCharactersToBeSkipped:[NSCharacterSet whitespaceCharacterSet]];
	
	NSMutableDictionary *rootDictionary		= [NSMutableDictionary dictionaryWithCapacity:12];
	NSString *nameAndParamPairs;
	NSString *name, *value;
	
	while ([scanner isAtEnd] == NO) {
		if ([scanner scanUpToString:@":" intoString:&nameAndParamPairs] &&
			[scanner scanString:@":" intoString:nil] &&
			[scanner scanUpToString:@"\r\n" intoString:&value] && 
			[scanner scanString:@"\r\n" intoString:nil]) {
			
			NSArray *nameAndParams = [nameAndParamPairs componentsSeparatedByString:@";"];
			
			name = [nameAndParams objectAtIndex:0];
			
			int i;
			NSMutableDictionary *entryDictionary = [NSMutableDictionary dictionaryWithCapacity:[nameAndParams count]];
			for (i = 1; i < [nameAndParams count]; i++) {
				NSArray *paramPairArray = [[nameAndParams objectAtIndex:i] componentsSeparatedByString:@"="];
				if ([paramPairArray count] == 2) {
					[entryDictionary setObject:[paramPairArray objectAtIndex:1]
										forKey:[paramPairArray objectAtIndex:0]];
				}
			}
			
			//
			NSMutableDictionary *tempDict;
			
			if ([name isEqualToString:@"EXDATE"] &&
				(tempDict = [rootDictionary objectForKey:@"EXDATE"])) {
				NSString *string = [tempDict valueForKey:@"_value"];
				string = [string stringByAppendingFormat:@",%@", value];
				[tempDict setObject:string forKey:@"_value"];
				[rootDictionary setObject:tempDict forKey:name];
			} else {
			//
				[entryDictionary setObject:value forKey:@"_value"];
				[rootDictionary setObject:entryDictionary forKey:name];
			}
		}
	}
	return [NSDictionary dictionaryWithDictionary:rootDictionary];
}

+ (NSArray *)arrayWithRFC2425Representation:(NSString *)string
{
	NSScanner *scanner = [NSScanner scannerWithString:string];
	[scanner setCharactersToBeSkipped:[NSCharacterSet whitespaceCharacterSet]];
	
	NSMutableArray *array = [NSMutableArray arrayWithCapacity:20];
	
	NSString *nameAndParamPairs;
	NSString *name, *value;
	NSMutableDictionary *paramDictionary;
	
	while ([scanner isAtEnd] == NO) {
		if ([scanner scanUpToString:@":" intoString:&nameAndParamPairs] &&
			[scanner scanString:@":" intoString:nil] &&
			[scanner scanUpToString:@"\r\n" intoString:&value] && 
			[scanner scanString:@"\r\n" intoString:nil]) {
			
			NSArray *nameAndParams = [nameAndParamPairs componentsSeparatedByString:@";"];
			
			name = [nameAndParams objectAtIndex:0];
			
			int i;
			paramDictionary = [NSMutableDictionary dictionaryWithCapacity:([nameAndParams count] - 1)];
			for (i = 1; i < [nameAndParams count]; i++) {
				NSArray *paramPairArray = [[nameAndParams objectAtIndex:i] componentsSeparatedByString:@"="];
				if ([paramPairArray count] == 2) {
					[paramDictionary setObject:[paramPairArray objectAtIndex:1]
										forKey:[paramPairArray objectAtIndex:0]];
				}
			}
			
			NSDictionary *contentlineDictionary = [NSDictionary dictionaryWithObjectsAndKeys:name, 
				@"name", 
				paramDictionary, 
				@"param", 
				value, 
				@"value", 
				nil];
			[array addObject:contentlineDictionary];
		}
	}
	return array;
}

+ (NSString *)stringWithEscapedString:(NSString *)string
{
	NSScanner		*scanner		= [NSScanner scannerWithString:string];
	NSMutableString	*resultString	= [NSMutableString stringWithCapacity:[string length]];
	NSString		*tempString;
	
	while ([scanner isAtEnd] == NO) {
		if ([scanner scanUpToString:@"\\" intoString:&tempString]) {
			[resultString appendString:tempString];
		}
		if ([scanner scanString:@"\\" intoString:nil]) {
			if ([scanner scanString:@"\\" intoString:&tempString] || 
				[scanner scanString:@";" intoString:&tempString] ||
				[scanner scanString:@"," intoString:&tempString]) {
				
				[resultString appendString:tempString];
			} else if ([scanner scanString:@"n" intoString:&tempString]) {
				[resultString appendString:@"\r\n"];
			}
		}
		
	}
	return [NSString stringWithString:resultString];
}

#pragma mark initialization and deallocation
- (id) initWithIdentifier:(NSString *)anIdentifier
{
	self = [super init];
	if (self != nil) {
		identifier = [anIdentifier copy];
	}
	return self;
}


- (void) dealloc {
	[identifier release];
	[self setSummary:nil];
	[self setNotes:nil];
	[self setStampDate:nil];
	[self setUrl:nil];
	
	[super dealloc];
}

#pragma mark implementation method for NSCopying
- (id)copyWithZone:(NSZone *)zone
{
    id newObject = [[[self class] allocWithZone:zone] initWithIdentifier:[self identifier]];
	[newObject setSummary:[self summary]];
	[newObject setNotes:[self notes]];
	[newObject setSequence:[self sequence]];
	[newObject setStampDate:[self stampDate]];
	[newObject setUrl:[self url]];
	
	return newObject;
}

#pragma mark accessor methods
- (NSString *)identifier
{
	return identifier;
}

- (NSString *)summary
{
	return summary;
}
- (void)setSummary:(NSString *)value
{
	if (summary != value) {
		[summary release];
		summary = [value copy];
	}
}

- (NSString *)notes
{
	return notes;
}
- (void)setNotes:(NSString *)value
{
	if (notes != value) {
		[notes release];
		notes = [value copy];
	}
}

- (int)sequence
{
	return sequence;
}
- (void)setSequence:(int)value
{
	sequence = value;
}

- (NSCalendarDate *)stampDate
{
	return stampDate;
}
- (void)setStampDate:(NSCalendarDate *)value
{
	if (stampDate != value) {
		[stampDate release];
		stampDate = [value copy];
	}
}

- (NSString *)url
{
	return url;
}
- (void)setUrl:(NSString *)value
{
	if (url != value) {
		[url release];
		url = [value copy];
	}
}

@end
