﻿module y4d_draw.fpslayer;

private import y4d_timer.fpstimer;
private import y4d_draw.drawlayer;
private import y4d_draw.screen;
private import y4d_aux.stringconv;

///	FPSを画面に表示するクラス
/**
	FpsTimerをセットしておけば、それを画面に表示してくれる。
	あくまでデバッグ用。もしくは、サンプル目的。<BR>

	自分用は、これを改造して使ってもらえれば良いと思う。
*/
class FpsLayer : DrawLayer {
	this(FpsTimer fpstimer_) { fpstimer = fpstimer_; size = 25; }
	this() { size = 25; }

	///	FpsTimerのsetter
	/**
		コンストラクタで渡しそびれた時のために。
	*/
	void	setFpsTimer(FpsTimer fpstimer_) { fpstimer = fpstimer_; }

	///	FpsTimerのgetter
	FpsTimer getFpsTimer() { return fpstimer; }

	///	文字のサイズの設定
	/**
		defaultは25。
		※ 色は、Screenに対してセットすればok。
	*/
	void	setSize(int size_) { size = size_; }

	///	文字のサイズの取得
	int getSize() { return size; }

	///	描画メソッド
	void	onDraw(Screen screen,int x,int y){
		if (!fpstimer) return ;
		int fps = fpstimer.getFps();
		int realfps = fpstimer.getRealFps();

		screen.setLineWidth((cast(float)size)/6 + 1);

		char[] txt = 
			StringConv.toConvHelpperU(realfps,10,4,' ');
		txt ~= "FPS";
		int r,g,b;
		screen.getColor(r,g,b); // 色を保存
		screen.setColor(0,120,0);
		screen.drawString(txt,x,y,size);
		screen.setColor(r,g,b); // 色を復帰
	}

private:
	FpsTimer fpstimer;	//	fps timer
	int size;			//	文字サイズ
}
