module yamalib.gui.guiscrollbar;

private import y4d_draw.texture;
private import y4d_draw.drawbase;
private import y4d_draw.screen;
private import y4d_input.mouse;

private import yamalib.gui.guiparts;

class Scrollbar : IGUIParts {
	
	/// スクロールバーのサイズ
	void setSize(int x_, int y_) {
		this.m_sx = x_;
		this.m_sy = y_;
	}
	
	/// 位置の設定
	override void setXY(int x_, int y_) {
		super.setXY(x_,y_);
	}
	
	/// 全体のトータルの高さを設定する
	void setScrollSize(int sz) {
		m_vsz = sz;
	}
	
	/// スクロールポジションの取得(0 - 1.0)
	float getScrollPos() {
		if ( m_sy >= m_vsz ) return 0.0f;
		int height = m_pos - y;
		if (height == 0) {
			return 0.0f;
		}
		
		return height / cast(float) m_sy;
	}
	
	
	/// 毎回呼び出すなり
	override void onMove(Screen screen) {
		if ( m_pos < this.y ) {
			m_pos = this.y;
		}
		
		int mx,my;
		mouse.getPos(mx,my);
		m_texSz = getBarHeight();
		if ( mouse.isPress(MouseInput.button.left) ) {
			// キャッチしていない時に、スクロールバーをキャッチした
			if ( 0==m_catch  && ptInRect( mx, my, x, m_pos, x + m_sx, m_pos+m_texSz ) ) {
				m_catch = 1;
				m_catchOy = m_pos - my;
			}
			
			// キャッチしてないときに、自分を選択された
			else if ( 0==m_catch && ptInRect( mx, my, x, y, x + m_sx, y + m_sy ) ) {
				m_catch = 2;
				m_catchOy = 0;
			}
		} else {
			m_catch = 0;
			// ホイール対応
			if (mouse.isPress(MouseInput.button.wheel_up) ) {
				m_catch = 1;
				m_catchOy = (m_pos - my) - (m_texSz / 2);
			} else if (mouse.isPress(MouseInput.button.wheel_down)) {
				m_catch = 1;
				m_catchOy = (m_pos - my) + (m_texSz / 2);
			}
		}
		
		
		// キャッチしている
		if ( m_catch != 0 ) {
			m_pos = my + m_catchOy;
			if ( m_pos + m_texSz > this.y + m_sy ) {
				m_pos = this.y + m_sy - m_texSz;
			} else if ( m_pos < this.y ) {
				m_pos = this.y;
			}
		} 
	}
	
	/// 毎回呼び出す名なり
	override void onDraw(Screen screen) {
		Color4ub colorOrg = screen.getColor4ub();
		screen.setColor(0,255,0);
		screen.drawPolygon(
			x,			m_pos,
			x,			m_pos+m_texSz,
			x+m_sx,		m_pos+m_texSz,
			x+m_sx,		m_pos
		);
		// 色戻し
		screen.setColor( colorOrg );
	}

protected:
	/// 点が矩形の内側にあるかどうか
	static bool ptInRect(int px, int py, int left, int top, int right, int bottom) {
		return cast(bool) (px >= left && px < right
			&& py >= top && py < bottom);
	}
	
	/// バーの高さを取得
	int getBarHeight() {
		return cast(int) ( (m_sy / cast(float) m_vsz) * m_sy );
	}
	
	static const int LC_SCROLL_MAX = 65535;

	
	int m_texSz;
	int m_sx;
	int m_sy;
	int m_vsz;	//!< 全体のサイズ
	int m_pos;	//!< 現在のスクロールバーの位置
	int m_catch;	//!< スクロールバーをつかんでいるか
	int m_catchOy;

}


class TexturalScrollbar : Scrollbar {
	/// バーテクスチャの設定
	void setBarTexture(Texture t_) {
		m_barTex = t_;
	}
	
	/// バーテクスチャの取得
	Texture getBarTexture() {
		return m_barTex;
	}
		
	/// 毎回呼び出す名なり
	override void onDraw(Screen screen) {
		screen.blt(m_barTex, 
			x - cast(int) (m_barTex.getWidth()/2), 
			m_pos);
	}

protected:
	/// バーの高さを取得する
	override int getBarHeight() 
	in
	{
		assert( !(m_barTex is null) );
	}
	body
	{
		return cast(int) m_barTex.getHeight();
	}

	Texture m_barTex;
}
