﻿module kyojintati4d.task4koma;

private import y4d;
private import y4d_aux.filesys;
private import y4d_aux.direnumerator;

private import kyojintati4d.myapp;
private import kyojintati4d.gameinfo;
private import kyojintati4d.component.komacontroller;
private import kyojintati4d.component.komadata;
private import kyojintati4d.component.komaview;

private import yamalib.log.log;

class Task4Koma : GameTaskBase {
	
	/// タスク名を返却する
	/**
		このタスク名称を使って、コントローラ部でタスク判別を行う可能性があるので
		ユニークな名前で、実装しておくべきである
	*/	
	override char[] toString() {
		with (kyojintati4d.val.kyojinconst) {
			return cast(char[]) KyojinConst.TASK_NAME[KyojinConst.Task.Task_Bookmark];
		}
	}
	
	/// onMove+onDraw
	override int task(Object o) {
		return 0;
	}
	
	/// 移動計算処理
	override int onMove(Object o) {
		try {
			GameInfo info = cast(GameInfo) o;
			info.screen.blendSrcAlpha();
			
			if ( !m_init ) {
				onInit(info);
				m_init = true;		
			}
			
			m_ctl.onMove(info.screen);

			return 0;
		} catch (Exception e) {
			Log.printFatal("Exception %s#onMove : [%s][%s]", 
				super.toString(), e.toString(), e.msg);
			throw e;
		}
	}

	/// 実描画処理
	override int onDraw(Object o) {
		try {
			GameInfo info = cast(GameInfo) o;

			// 画面クリア
			info.screen.clear();

			m_ctl.onDraw(info.screen);

			return 0;
		} catch (Exception e) {
			Log.printFatal("Exception %s#onDraw : [%s][%s]", 
				super.toString(), e.toString(), e.msg);
			throw e;
		}
	}

	void destroy() {
		// TODO 必要であれば実装すること
		Log.print("%s#destroy", this.toString());
	}
	
private:
	/// 初期化処理
	void onInit(GameInfo info) {
		GameInfo.printMemoryState();
		
		this.m_ctl = new KomaController();
		this.m_ctl.setFontLoader(info.fontloader, 1);
		this.m_ctl.load(cast(char[]) "./4koma/subject1");
	}
	
	/// サブジェクトを列挙する
	void enumSubject() {
		DirEnumerator dir = new DirEnumerator();
		dir.setDir( cast(char[]) KOMA_DIR );
		dir.setFileOnly( false );	// ディレクトリも列挙
		dir.setSubDir( false );		// サブディレクトリは見に行かない
		
		foreach (char[] filename; dir) {
			if ( DirEnumerator.isFile( filename ) ) {
				// ファイル名
//				if ( FileEx.isValid(filename) ) {
//					subjectPath ~= filename;
//				}
				
			} else {
				// ディレクトリ名であれば、そのディレクトリ内に layer.xmlが存在すること
				if ( FileSys.isExist( filename ~ "layer.xml") ) {
					subjectPath ~= filename;
				}
			}
		}
	}
	
	

private:
	static const char[] KOMA_DIR = "./4koma/"; //!< 四コマデータの配備ディレクトリ

	char[][] subjectPath;
	bool m_init;
	KomaController m_ctl;
	

	
}